<?php
if (!defined('ABSPATH')) exit;
require_once BOTAMI_PLUGIN_PATH . 'includes/class-chat-messages.php';
require_once BOTAMI_PLUGIN_PATH . 'includes/class-lead-generator.php';

class Botami_Activator {
    public static function activate() {
            // Create messages table
            $chatMessages = new Botami_Chat_Messages();
            $chatMessages->create_table();
            update_option('botami_is_active', '1');

            $lead_generator = Botami_Lead_Generator::getInstance();
            $lead_generator->create_leads_table();

            // Auto-detect and set theme colors on activation
            self::botami_detect_and_set_theme_colors();
    }

    /**
     * Detect theme colors and set them for the chatbot
     */
    private static function botami_detect_and_set_theme_colors() {
        // Only set colors if they haven't been set before
        $existing_primary = get_option('botami_primary_color');
        $existing_secondary = get_option('botami_secondary_color');

        // Skip if colors are already set
        if (!empty($existing_primary) && !empty($existing_secondary)) {
            return;
        }

        $primary_color = '#31377B';
        $secondary_color = '#673DE6';

        // Try to get theme mod colors (most modern themes use this)
        $theme_primary = get_theme_mod('primary_color');
        $theme_accent = get_theme_mod('accent_color');
        $theme_link = get_theme_mod('link_color');

        // Try custom theme mods with common names
        if (empty($theme_primary)) {
            $theme_primary = get_theme_mod('header_background_color');
        }
        if (empty($theme_primary)) {
            $theme_primary = get_theme_mod('theme_color');
        }

        // Try to get colors from customizer settings
        if (empty($theme_primary)) {
            $theme_primary = get_theme_mod('header_textcolor');
        }

        // Use detected primary color if valid
        if (!empty($theme_primary)) {
            $sanitized = self::botami_sanitize_hex_color($theme_primary);
            if ($sanitized) {
                $primary_color = $sanitized;
            }
        }

        // Use detected accent/link color as secondary if valid
        if (!empty($theme_accent)) {
            $sanitized = self::botami_sanitize_hex_color($theme_accent);
            if ($sanitized) {
                $secondary_color = $sanitized;
            }
        } elseif (!empty($theme_link)) {
            $sanitized = self::botami_sanitize_hex_color($theme_link);
            if ($sanitized) {
                $secondary_color = $sanitized;
            }
        }

        // Save the detected colors with WordPress sanitization
        update_option('botami_primary_color', sanitize_hex_color($primary_color));
        update_option('botami_secondary_color', sanitize_hex_color($secondary_color));
    }

    /**
     * Sanitize hex color code with WordPress standards
     *
     * @param string $color Color to sanitize
     * @return string|null Sanitized hex color or null if invalid
     */
    private static function botami_sanitize_hex_color($color) {
        // Remove any whitespace
        $color = trim($color);

        // Add # if missing
        if (strpos($color, '#') !== 0) {
            $color = '#' . $color;
        }

        // Use WordPress built-in function for validation
        $sanitized = sanitize_hex_color($color);

        // Return sanitized color or null
        return $sanitized ? $sanitized : null;
    }
}