<?php
if (!defined('ABSPATH')) exit;

class Botami_Chatbot {

    public function __construct() {
        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }

    private function load_dependencies() {
        require_once BOTAMI_PLUGIN_PATH . 'admin/class-admin-assets.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-language-manager.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/language-helper.php'; 
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-settings-sanitizer.php';
        require_once BOTAMI_PLUGIN_PATH . 'admin/class-admin.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-session-handler.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-lead-email-notifier.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-ajax-handler.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-chat-messages.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-lead-generator.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-url-checker.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-assets.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-widget.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-dashboard-metrics.php';
        require_once BOTAMI_PLUGIN_PATH . 'includes/class-token-usage.php';
    }


    private function define_admin_hooks() {
        $plugin_admin = new Botami_Chatbot_Admin();
        add_action('admin_menu', [$plugin_admin, 'add_plugin_admin_menu']);
        add_action('admin_enqueue_scripts', [$plugin_admin, 'enqueue_styles']);
        add_action('admin_enqueue_scripts', [$plugin_admin, 'enqueue_scripts']);
        add_action('wp_ajax_botami_verify_chatbot_api', [$plugin_admin, 'verify_api_key_ajax']);
        add_action('wp_ajax_botami_mark_setup_complete', [$plugin_admin, 'mark_setup_complete_ajax']);
        add_action('wp_ajax_botami_handle_chatbot_file_upload', [$plugin_admin, 'handle_pdf_upload']);
        add_action('admin_init', [$plugin_admin, 'chatbot_register_settings']);
        add_action('admin_post_update_chatbot_settings', [$plugin_admin, 'handle_form_submission']);
        add_action('wp_ajax_botami_export_chat_messages', [$plugin_admin, 'handle_chat_export']);
        add_action('wp_ajax_botami_export_lead_data', [$plugin_admin, 'handle_lead_export']);
        add_action('wp_ajax_botami_delete_knowledge_file', [$plugin_admin, 'botami_delete_knowledge_file']);
    }

    private function define_public_hooks() {
        if (get_option('botami_api_key', false) && get_option('botami_is_active', '1') === '1') {
            $asset_class = new Botami_Assets();
            add_action('wp_enqueue_scripts', [$asset_class, 'enqueue_assets']);
            $widget_class = new Botami_Widget();
            add_action('wp_footer', [$widget_class, 'add_to_footer']);
        }
    }

}
