<?php
if (!defined('ABSPATH')) exit;
class Botami_Language_Manager {
    private static $translations = [
        'en' => [
            // Frontend widget translations
            'online_status' => 'Online 24/7',
            'powered_by' => 'Powered by Botami',
            'greeting' => 'Hi! 👋',
            'assist_message' => 'Do you want me to assist you? ✨',
            'refresh_message' => 'Reload your old messages✨',
            'write_message' => 'Write a message...',
            'typing_message' => 'Botami writing',
            'error_message' => 'Sorry, got a temporary delay.',
            'no_message' => 'No message provided.',
            'service_unavailable' => 'Service currently unavailable.',
            'communication_error' => 'Error communicating with assistant.',
            'try_again_later' => 'Error communicating with assistant. Try again later.',
            'limit_exceed' => 'The assistant is unavailable for the moment.',
            'first_message' => 'Hello! How can I help you?',
            'was_helpful' => 'Was it helpful?',
            'yes' => 'yes',
            'no' => 'no',
            'feedback_positive' => '👍 This message was helpful',
            'feedback_negative' => '👎 This message was not helpful',
            'feedback_response_positive' => 'Thank you for your positive feedback! Is there anything else I can help you with?',
            'feedback_response_negative' => "I'm sorry my response wasn't helpful. Could you tell me more about what you're looking for so I can provide better assistance?",
            'lead_form_transition' => "I'd love to help you further. Could you share your contact information so I can provide you with more detailed assistance?",
            'questionnaire_fallback' => "Thank you for completing the questionnaire! Based on your responses, I'm here to help you with your needs. How can I assist you further?",

            // Admin dashboard translations
            'admin' => [
                // Dashboard tab
                'dashboard_title' => 'Dashboard summary',
                'dashboard_botami' => 'Botami Dashboard',
                'api_active' => 'API Active',
                'total_conversations' => 'Total Conversations',
                'messages_exchanged' => 'Messages exchanged',
                'leads_generated' => 'Leads generated',
                'api_key_info' => 'API Key Information',
                'api_key' => 'API Key',
                'active_plan' => 'Active plan',
                'token_usage' => 'Credit usage this month',
                'credis_used' => 'credits used',
                'max_credis' => 'maximum credits',
                'refresh_data' => 'Refresh data',
                'modify_api_key' => 'Modify API Key',
                'verify_api_key' => 'Verify API Key',
                'quick_links' => 'Quick Links',
                'chatbot_config' => 'Chatbot Configuration',
                'customization' => 'Customization',
                'quick_replies' => 'Quick Replies',
                'export_conversations' => 'Export & Download',
                'need_help' => 'Need help?',
                'help_desc' => 'Do you have questions about your chatbot or API? Check our help resources or contact us.',
                'documentation' => 'Documentation',
                'help_center' => 'Help Center',
                'contact_support' => 'Contact support',
                'confirm_api_change' => 'Are you sure you want to modify your API key? The chatbot will not work until a new valid key is provided.',
                'data_refreshed' => 'Data has been refreshed!',
                'connect_botami' => 'Connect Botami to your site',
                'connect_desc' => 'To activate your chatbot, start by generating an API key in your personal space on Botami.ai. Once you have the key, copy and paste it below to finalize the connection.',
                'get_api_key' => 'Get an API key >',
                'view_dashboard' => 'Dashboard >',

                // Setup animation translations
                'setup_animation_title' => 'Configuration in progress',
                'setup_animation_init' => 'Initializing your intelligent assistant...',
                'setup_animation_building' => 'Building the knowledge base...',
                'setup_animation_learning' => 'Learning your data...',
                'setup_animation_optimizing' => 'Optimizing performance...',
                'setup_animation_customizing' => 'Customizing the interface...',
                'setup_animation_finalizing' => 'Finalizing the configuration...',
                'setup_animation_ready' => 'Your chatbot is ready!',
                'setup_animation_no_content' => 'Setup complete! You can now add content to your knowledge base in the Knowledge Base tab.',

                // General tab
                'general_title' => 'Customization',
                'personalization' => 'Personalization',
                'personalization_desc' => 'This tab allows you to customize the messages displayed by the chatbot, such as the welcome message, online status, or interface texts visible to your users.',
                'chatbot_activation' => 'Chatbot Activation',
                'activation_desc' => 'This option allows you to activate or deactivate the chatbot on your entire site.',
                'enable_disable' => 'Enable/Disable the chatbot',
                'conversation_persistence' => 'Conversation Persistence',
                'persistence_desc' => 'Enable this option to keep the chatbot conversation open while the user navigates between pages on the site.',
                'enable_disable_persistence' => 'Enable/Disable conversation persistence',
                'texts_messages' => 'Texts and Messages',
                'texts_desc' => 'Customize the texts displayed in your chatbot for an experience tailored to your brand.',
                'welcome_message' => 'Catchphrase',
                'welcome_message_desc' => 'The welcome bubble is a short message that automatically appears on the bot to grab your visitors attention and encourage them to start a conversation.',
                'enable_disable_welcome' => 'Enable/Disable welcome message',
                'chatbot_title' => 'Chatbot Title',
                'chatbot_title_desc' => 'This text appears as the main title in the chatbot header.',
                'status_text' => 'Status Text',
                'status_text_desc' => 'This text indicates the availability status of your chatbot.',
                'reload_text' => 'Reload Text',
                'reload_text_desc' => 'This text appears on the button to reload old conversations.',
                'input_placeholder' => 'Input Space Text',
                'input_placeholder_desc' => 'This text appears as a placeholder in the message input field.',
                'default_message' => 'Default Message',
                'default_message_desc' => 'This message appears as a default introduction in the chatbot.',
                'chatbot_preview' => 'Hello! How can I help you?',
                'preview_desc' => 'Here is a preview of how your chatbot will look on your site. Text modifications will be reflected in real-time.',
                'excluded_pages' => 'Excluded Pages',
                'excluded_desc' => 'Exclude the chatbot from specific pages on the site. You can add complete URLs or relative paths.',
                'add_excluded_url' => 'Add',
                'excluded_url_info' => 'To exclude multiple pages, add them one by one. URLs can be relative paths (/my-page) or complete URLs.',
                'api_key_placeholder' => 'Enter your API key',
                'excluded_url_example' => 'ex: /about-us or https://example.com/contact or example.com/contact',
                'auto_translation' => 'Automatic Translation',
                'auto_translation_desc' => 'Enable automatic translation for chatbot interface texts. When enabled, texts like welcome messages, placeholders, and default messages will be automatically translated to the selected languages based on your users\' browser language.',
                'enabled_languages' => 'Enabled Languages',
                'enabled_languages_desc' => 'Select which languages should be available for automatic translation',
                'input_language' => 'Input Language',
                'input_language_desc' => 'The language you will write these texts in. Other enabled languages will be auto-translated.',
                'auto_translate_note' => '<strong>Note:</strong> When you modify the texts below, they will automatically be translated to all enabled languages when you save.',

                // Bot config tab
                'bot_config_title' => 'Knowledge Base',
                'bot_config_desc' => 'This tab allows you to enrich your chatbot\'s knowledge. Add here the links and content that the bot can use to provide accurate responses to your users.',
                'context' => 'Context',
                'context_desc' => 'Add information about your website here to train the AI behavior. This information will serve as a knowledge base for your chatbot.',
                'context_placeholder' => 'Add information about your website to train the AI behavior...',
                'knowledge_urls' => 'Knowledge URLs',
                'knowledge_urls_desc' => 'Add URLs of pages containing relevant information (FAQ, product pages, etc.) to enrich your chatbot\'s knowledge base.',
                'add_url' => 'Add',
                'premium_feature' => 'This feature is only available with a Pro subscription or higher.',
                'file_import' => 'File Import',
                'file_import_desc' => 'Import a single file containing information to enrich your chatbot\'s knowledge base. This file will be used with the context above, sharing the same character limit.',
                'file_import_drag' => 'Drag and drop or click to add files (PDF, DOCX, CSV, XLS, XLSX)',
                'file_import_info' => 'These files will train the AI with information specific to your activity',
                'uploaded_knowledge_file' => 'Uploaded Knowledge File',
                'uploading_file' => 'Uploading File...',
                'content_truncated_warning' => 'Content was truncated due to plan limits. Upgrade your plan to process larger files.',
                'file_too_large_for_plan' => 'File size exceeds your plan limit. Some content may have been truncated.',

                // Quick replies tab
                'quick_replies_title' => 'Surveys',
                'quick_replies_desc' => 'Quick replies are predefined buttons that will appear in the chat for your visitors. They can click on them instead of typing a message.',
                'add_reply' => 'Add',
                'clear_all' => 'Clear all',
                'no_replies' => 'No quick replies added',
                'add_first' => 'Add your first reply above',
                'chat_preview' => 'Preview in chat',
                'buttons_appear' => 'These buttons will appear at the bottom of the chat to help visitors interact easily.',
                'quick_reply_example_1' => 'What do you offer?',
                'quick_reply_example_2' => 'Your prices',
                'quick_reply_example_3' => 'Make an appointment',

                'questionnaire_branching_title' => 'Enhanced Branching Logic',
                'questionnaire_branching_subtitle' => 'Branching Logic',
                'questionnaire_branching_desc' => 'This questionnaire system supports advanced branching based on specific answer choices. You can:',
                'questionnaire_branching_feature_1' => 'Create questions that follow different paths based on user answers',
                'questionnaire_branching_feature_2' => 'Set up conditional logic where certain questions only appear after specific answers',
                'questionnaire_branching_feature_3' => 'Build complex, personalized questionnaire flows',
                
                'questionnaire_main_desc' => 'Create an interactive questionnaire that adapts based on user responses. Each question can have multiple answer options, and you can set up conditional logic to show different follow-up questions based on which option the user selects.',
                
                'questionnaire_input_placeholder' => 'Enter your question (e.g., \'What type of service are you interested in?\')',
                'questions_created' => 'questions created',
                'questionnaire_help_title' => 'How Branching Logic Works',
                'questionnaire_help_creating_title' => 'Creating Questions:',
                'questionnaire_help_creating_1' => 'Each question can have multiple answer options',
                'questionnaire_help_creating_2' => 'Users will see buttons for each option',
                'questionnaire_help_creating_3' => 'Add as many options as needed per question',
                
                'questionnaire_help_branching_title' => 'Setting Up Branching:',
                'questionnaire_help_branching_1' => 'Choose which question comes before this one',
                'questionnaire_help_branching_2' => 'Optionally, choose which specific answer triggers this question',
                'questionnaire_help_branching_3' => 'Questions without specific triggers will show after any answer',
                
                'questionnaire_example_label' => 'Example:',
                'questionnaire_example_text' => 'Question 1 asks "What service?" with options "Web Design" and "SEO". You can create Question 2a that only appears if they chose "Web Design" and Question 2b that only appears if they chose "SEO".',
                
                // Lead Generation Enhanced Section
                'lead_gen_questionnaire_desc' => 'The lead form can now be triggered at the end of specific questionnaire paths.',
                'lead_form_triggering_title' => 'Enhanced Lead Form Triggering',
                'lead_form_triggering_desc' => 'With the branching system, you can now trigger the lead form at the end of specific questionnaire paths. This allows for more targeted lead collection based on user responses.',
                
                'lead_form_question_selection_desc' => 'Select which question\'s completion should trigger the lead form',
                'smart_end_node_detection_title' => 'Smart End-Node Detection:',
                'smart_end_node_detection_desc' => 'Only questions that can be the final step in a questionnaire path are shown here. Questions that always lead to other questions are automatically excluded.',
                'smart_end_node_detection_note' => 'This ensures the lead form appears at natural stopping points in your questionnaire flow.',
                
                // Form Preview Enhanced
                'form_preview_enhanced_desc' => 'With branching logic, this form can now appear at different points based on user responses.',

                // Lead generation
                'lead_generation' => 'Lead Generation',
                'lead_export' => 'Export leads (CSV)',
                'lead_gen_desc' => 'Collect visitor information to convert them into potential customers. The capture form will appear at the optimal moment.',
                'enable_lead_gen' => 'Enable lead generation',
                'lead_gen_enabled' => 'When enabled, a contact form will appear during the conversation.',
                'when_display' => 'When to display the capture form?',
                'after_reply' => 'After a specific quick reply:',
                'no_specific_reply' => '-- None (use default behavior) --',
                'info_end_sequence' => 'Only quick replies that are at the end of a sequence can trigger the form. This allows for a better user experience.',
                'customize_form' => 'Customize the capture form',
                'intro_message' => 'Introduction message:',
                'lead_gen_intro_message' => 'To better assist you, please provide your information:',
                'intro_message_desc' => 'This message appears just before the form.',
                'form_fields' => 'Form fields',
                'field_label' => 'Field 1 - Label:',
                'field_placeholder' => 'Name:',
                'field2_label' => 'Field 2 - Label:',
                'field2_placeholder' => 'Email:',
                'field3_label' => 'Field 3 - Label:',
                'field3_placeholder' => 'Custom:',
                'consent_message' => 'I agree to be contacted regarding my request.',
                'consent_message_desc' => 'This message appears next to the checkbox.',
                'consent_toggle' => 'Hide/Show',
                'consent_toggle_desc' => 'Consent message activation',
                'consent_toggle_message' => 'Activate this option to hide the consent message.',
                'submit_button' => 'Submit',
                'thank_you_message' => 'Thank !',
                'thank_you_desc' => 'This message appears after submitting the form.',
                'form_preview' => 'Form preview',
                'form_preview_desc' => 'This form will appear in the conversation to collect your visitors\' information.',
                
                'lead_email_notifications_title' => '📧 Lead Email Notifications',
                'enable_lead_email_notifications' => 'Enable email notifications for new leads',
                'lead_email_admin_desc' => 'Emails will be sent to the WordPress admin address: {admin_email}',
                'current_email_address' => '📍 Current email address:',
                'change_email_instructions' => 'To change this address, go to Settings → General in your WordPress dashboard.',

                // Appearance tab
                'appearance_title' => 'Appearance',
                'chatbot_logo' => 'Chatbot logo',
                'choose_logo' => 'Choose a predefined logo:',
                'standard_robot' => 'Standard Robot',
                'ai_assistant' => 'AI Assistant',
                'pro_support' => 'Pro Support',
                'custom_logo' => 'Your custom logo',
                'upload_logo' => 'Or upload your own logo:',
                'click_select' => 'Click to select',
                'an_image' => ' an image',
                'from_media' => ' from the media library',
                'upload_info' => 'PNG, JPG, GIF up to 10MB',
                'primary_color' => 'Primary Color',
                'secondary_color' => 'Secondary Color',
                'chatbot_preview_desc' => 'I need information about your services.',
                
                // Export tab
                'export_title' => 'Select a date range for exporting the conversations',
                'select_start' => 'Select start date',
                'to' => 'to',
                'select_end' => 'Select end date',
                'export_download' => 'Export & Download',
                
                // Common admin elements
                'save_changes' => 'Save Changes',
                'paid_feature' => 'Paid Feature',
                'paid_feature_desc' => 'This feature is locked. To access it, please <a href="https://botami.ai" target="_blank" class="text-blue-500 underline">upgrade your plan.</a>',
                'close' => 'Close',
                
                // Alerts and notifications
                'settings_updated' => 'Settings updated successfully',
                'token_limit_exceeded' => 'Your monthly credit limit has been exceeded. Upgrade your plan for more discussions.',
                'chatbot_disabled' => 'The chatbot is currently disabled. When disabled, the chatbot widget will not appear to visitors, but all your settings will be preserved.',
                'please_enter_api' => 'Please enter an API key',
                'api_verified' => 'API key verified successfully!',
                'verification_failed' => 'Verification failed',
                'invalid_api' => 'Invalid API key',
                'upload_failed' => 'Upload failed',
                'file_uploaded' => 'File "{filename}" uploaded successfully!',
                'error_uploading' => 'An error occurred during upload',
                'please_select_dates' => 'Please select both start and end dates',
                'export_failed' => 'Export failed. Please try again.',
                'please_enter_reply' => 'Please enter a quick reply message',
                'max_items_allowed' => 'Maximum of {max} URLs allowed',
                'url_already_in_list' => 'This URL is already in the list',
                'invalid_file_format' => 'Please upload a valid file format (PDF, DOCX, CSV, XLS, XLSX)',
                'no_messages_found' => 'No messages found for the selected date range',
                'no_file_selected' => 'No file selected.',
                'file_not_image' => 'Please upload an image file (PNG, JPG, GIF).',
                'file_too_large' => 'The file exceeds the maximum size of 10 MB.',
                'error_reading_file' => 'An error occurred while reading the file.',

                // Quick Replies UI translations
                'question_number' => 'Question #',
                'interactive_questionnaire' => 'Interactive questionnaire',
                'delete_question' => 'Delete this question',
                'main_question' => 'Main Question',
                'enter_question' => 'Enter your question here...',
                'response_options' => 'Response Options',
                'add_option' => 'Add Option',
                'enter_option' => 'Enter option {letter} here...',
                'previous_question' => 'Previous Question',
                'optional' => 'Optional',
                'no_previous_question' => 'No previous question',
                'previous_answer_option' => 'Previous Answer Option',
                'no_specific_answer' => 'No specific previous answer required',
                'only_after_answer' => 'This question will only appear if the user selected the specific answer option above.',
                'auto_save_enabled' => 'Auto-save enabled',
                'edit' => 'Edit',
                'delete_question_confirm' => 'Are you sure you want to delete this question?',
                'enter_question_message' => 'Please enter a question message',
                'remove_all_confirm' => 'Are you sure you want to remove all quick replies?',
            ]
        ],
        'fr' => [
            // Frontend widget translations
            'online_status' => 'En ligne 24/7',
            'powered_by' => 'Propulsé par Botami',
            'greeting' => 'Bonjour! 👋',
            'assist_message' => 'Puis-je vous aider? ✨',
            'refresh_message' => 'Rafraichir les anciens messages ✨',
            'write_message' => 'Écrivez un message...',
            'typing_message' => 'Botami écrit',
            'error_message' => 'Désolé, il y a un délai temporaire.',
            'no_message' => 'Aucun message fourni.',
            'service_unavailable' => 'Service temporairement indisponible.',
            'communication_error' => "Erreur de communication avec l'assistant.",
            'try_again_later' => "Erreur de communication avec l'assistant. Réessayez plus tard.",
            'limit_exceed' => "L'assistant est indisponible pour le moment.",
            'first_message' => 'Bonjour! Comment puis-je vous aider?',
            'was_helpful' => 'Ce message est utile?',
            'yes' => 'oui',
            'no' => 'non',
            'feedback_positive' => '👍 Ce message était utile',
            'feedback_negative' => "👎 Ce message n'était pas utile",
            'feedback_response_positive' => 'Merci pour votre retour positif! Y a-t-il autre chose avec laquelle je peux vous aider ?',
            'feedback_response_negative' => 'Je suis désolé que ma réponse ne vous ait pas été utile. Pouvez-vous me donner plus de détails sur ce que vous recherchez afin que je puisse mieux vous aider?',
            'lead_form_transition' => "Je serais ravi de vous aider davantage. Pourriez-vous communiquer vos informations de contact pour que je puisse vous fournir une assistance plus détaillée ?",
            'questionnaire_fallback' => "Merci d'avoir complété le questionnaire ! En me basant sur vos réponses, je suis là pour vous aider avec vos besoins. Comment puis-je vous assister davantage ?",

            // Admin dashboard translations
            'admin' => [
                'support_botami' => 'Supporter Botami',
                'powered_by_help' => 'Afficher "Propulsé par Botami" pour aider les autres à découvrir notre service',
                'show_attribution' => "Afficher l'attribution",
                // Powered by popup translations
                'popup_thank_you' => 'Merci d\'avoir installé Botami !',
                'popup_description' => 'Souhaitez-vous nous aider à grandir en affichant un petit lien "Propulsé par Botami" sur votre chatbot ? Ceci est complètement optionnel et aide d\'autres utilisateurs à découvrir notre service.',
                'popup_yes' => 'Oui, l\'afficher',
                'popup_no' => 'Non merci',
                'popup_change_later' => 'Vous pouvez toujours changer cela plus tard dans les paramètres de votre tableau de bord.',
                'popup_no_problem' => 'Aucun problème ! Vous pouvez l\'activer à tout moment dans les paramètres.',
                // Dashboard tab
                'dashboard_title' => 'Résumé Tableau de Bord',
                'dashboard_botami' => 'Tableau de bord Botami',
                'api_active' => 'API Active',
                'total_conversations' => 'Conversations totales',
                'messages_exchanged' => 'Messages échangés',
                'leads_generated' => 'Leads générés',
                'api_key_info' => 'Informations de la clé API',
                'api_key' => 'Clé API',
                'active_plan' => 'Plan actif',
                'token_usage' => 'Utilisation des credits ce mois-ci',
                'credis_used' => 'credits utilisés',
                'max_credis' => 'credits maximum',
                'refresh_data' => 'Actualiser les données',
                'modify_api_key' => 'Modifier la clé API',
                'verify_api_key' => 'Verifier la clé API',
                'quick_links' => 'Liens rapides',
                'chatbot_config' => 'Configuration du chatbot',
                'customization' => 'Personnalisation',
                'quick_replies' => 'Réponses rapides',
                'export_conversations' => 'Export et téléchargement',
                'need_help' => 'Besoin d\'aide ?',
                'help_desc' => 'Vous avez des questions concernant votre chatbot ou votre API ? Consultez nos ressources d\'aide ou contactez-nous.',
                'documentation' => 'Documentation',
                'help_center' => 'Centre d\'aide',
                'contact_support' => 'Contacter le support',
                'confirm_api_change' => 'Êtes-vous sûr de vouloir modifier votre clé API ? Le chatbot ne fonctionnera plus jusqu\'à ce qu\'une nouvelle clé valide soit fournie.',
                'data_refreshed' => 'Les données ont été actualisées !',
                'connect_botami' => 'Connecter Botami à votre site',
                'connect_desc' => 'Pour activer votre chatbot, commencez par générer une clé API dans votre espace personnel sur Botami.ai. Une fois la clé obtenue, copiez-la et collez-la ci-dessous pour finaliser la connexion.',
                'get_api_key' => 'Obtenir une clé d\'API >',
                'view_dashboard' => 'Tableau de bord >',

                // Setup animation translations
                'setup_animation_title' => 'Configuration en cours',
                'setup_animation_init' => 'Initialisation de votre assistant intelligent...',
                'setup_animation_building' => 'Construction de la base de connaissances...',
                'setup_animation_learning' => 'Apprentissage de vos données en cours...',
                'setup_animation_optimizing' => 'Optimisation des performances...',
                'setup_animation_customizing' => 'Personnalisation de l\'interface...',
                'setup_animation_finalizing' => 'Finalisation de la configuration...',
                'setup_animation_ready' => 'Votre chatbot est prêt !',
                'setup_animation_no_content' => 'Configuration terminée ! Vous pouvez maintenant ajouter du contenu à votre base de connaissances dans l\'onglet Base de connaissances.',

                // General tab
                'general_title' => 'Personnalisation',
                'personalization' => 'Personnalisation',
                'personalization_desc' => 'Cet onglet vous permet de personnaliser les messages affichés par le chatbot, comme le message de bienvenue, le statut en ligne ou encore les textes d\'interface visibles par vos utilisateurs.',
                'chatbot_activation' => 'Activation du Chatbot',
                'activation_desc' => 'Cette option vous permet d\'activer ou de désactiver le chatbot sur l\'ensemble de votre site.',
                'enable_disable' => 'Activer/Désactiver le chatbot',
                'conversation_persistence' => 'Persistance de Conversation',
                'persistence_desc' => 'Activer cette option pour maintenir la conversation du chatbot ouverte pendant que l\'utilisateur navigue entre les pages du site.',
                'enable_disable_persistence' => 'Activer/Désactiver la persistance de conversation',
                'texts_messages' => 'Textes et Messages',
                'texts_desc' => 'Personnalisez les textes affichés dans votre chatbot pour une expérience adaptée à votre marque.',
                'welcome_message' => "Message d'accroche",
                'welcome_message_desc' => "La bulle d'accroche est un petit message qui s'affiche automatiquement sur le bot pour attirer l'attention de vos visiteurs et les inciter à engager la conversation.",
                'enable_disable_welcome' => 'Activer/Désactiver le message de bienvenue',
                'chatbot_title' => 'Titre du Chatbot',
                'chatbot_title_desc' => 'Ce texte apparaît comme titre principal dans l\'en-tête du chatbot.',
                'status_text' => 'Texte de Statut',
                'status_text_desc' => 'Ce texte indique le statut de disponibilité de votre chatbot.',
                'reload_text' => 'Texte de Rechargement',
                'reload_text_desc' => 'Ce texte s\'affiche sur le bouton de rechargement des anciennes conversations.',
                'input_placeholder' => 'Texte de l\'Espace de Saisie',
                'input_placeholder_desc' => 'Ce texte apparaît comme placeholder dans le champ de saisie du message.',
                'default_message' => 'Message par Défaut',
                'default_message_desc' => 'Ce message s\'affiche comme introduction par défaut dans le chatbot.',
                'chatbot_preview' => 'Bonjour ! Comment puis-je vous aider ?',
                'preview_desc' => 'Voici un aperçu de l\'apparence de votre chatbot sur votre site. Les modifications des textes seront reflétées en temps réel.',
                'excluded_pages' => 'Pages Exclues',
                'excluded_desc' => 'Exclure le chatbot de certaines pages spécifiques du site. Vous pouvez ajouter des URLs complètes ou des chemins relatifs.',
                'add_excluded_url' => 'Ajouter',
                'excluded_url_info' => 'Pour exclure plusieurs pages, ajoutez-les une par une. Les URLs peuvent être des chemins relatifs (/ma-page) ou des URLs complètes.',
                'api_key_placeholder' => 'Entrez votre clé API',
                'excluded_url_example' => 'ex: /a-propos ou https://exemple.com/contact ou exemple.com/contact',
                'auto_translation' => 'Traduction Automatique',
                'auto_translation_desc' => 'En activant cette option et en cochant les langues disponibles, votre chatbot sera accessible dans ces langues. Les textes de personnalisation (espace de saisie, message de bienvenue, texte de rechargement) seront automatiquement traduits selon la langue de préférence de l\'utilisateur.',
                'enabled_languages' => 'Langues Activées',
                'enabled_languages_desc' => 'Sélectionnez les langues qui doivent être disponibles pour la traduction automatique',
                'input_language' => 'Langue de Saisie',
                'input_language_desc' => 'La langue dans laquelle vous écrirez ces textes',
                'auto_translate_note' => '<strong>Remarque :</strong> Lorsque vous modifiez les textes ci-dessous, ils seront automatiquement traduits dans toutes les langues activées lorsque vous enregistrez.',

                // Bot config tab
                'bot_config_title' => 'Base de connaissance',
                'bot_config_desc' => "Cet onglet vous permet d'enrichir les connaissances de votre chatbot. Ajoutez ici les liens et contenus que le bot pourra utiliser pour répondre de manière précise à vos utilisateurs.",
                'context' => 'Contexte',
                'context_desc' => 'Ajoutez ici des informations sur votre site web pour entraîner le comportement de l\'IA. Ces informations serviront de base de connaissances pour votre chatbot.',
                'context_placeholder' => 'Ajoutez des informations sur votre site web pour entraîner le comportement de l\'IA...',
                'knowledge_urls' => 'URLs de Connaissances',
                'knowledge_urls_desc' => 'Ajoutez des URLs de pages contenant des informations pertinentes (FAQ, pages produits, etc.) pour enrichir la base de connaissances de votre chatbot.',
                'add_url' => 'Ajouter',
                'premium_feature' => 'Cette fonctionnalité est disponible uniquement avec un abonnement Pro ou supérieur.',
                'file_import' => 'Importation de Fichiers',
                'file_import_desc' => 'Importez un seul fichier contenant des informations pour enrichir la base de connaissances de votre chatbot. Ce fichier sera utilisé avec le contexte ci-dessus, partageant la même limite de caractères.',
                'file_import_drag' => 'Glissez-déposez ou cliquez pour ajouter des fichiers (PDF, DOCX, CSV, XLS, XLSX)',
                'file_import_info' => 'Ces fichiers permettront d\'entraîner l\'IA avec des informations spécifiques à votre activité',
                'uploaded_knowledge_file' => 'Fichier de connaissances téléchargé',
                'uploading_file' => 'Téléchargement du fichier...',
                'content_truncated_warning' => 'Le contenu a été tronqué en raison des limites du plan. Mettez à niveau votre plan pour traiter des fichiers plus volumineux.',
                'file_too_large_for_plan' => 'La taille du fichier dépasse la limite de votre plan. Une partie du contenu a pu être tronquée.',

                // Quick replies tab
                'quick_replies_title' => 'Questionnaires',
                'quick_replies_desc' => 'Les réponses rapides sont des boutons prédéfinis qui apparaîtront dans le chat pour vos visiteurs. Ils pourront cliquer dessus au lieu de taper un message.',
                'add_reply' => 'Ajouter',
                'clear_all' => 'Tout effacer',
                'no_replies' => 'Aucune réponse rapide ajoutée',
                'add_first' => 'Ajoutez votre première réponse ci-dessus',
                'chat_preview' => 'Aperçu dans le chat',
                'buttons_appear' => 'Ces boutons apparaîtront au bas du chat pour aider les visiteurs à interagir facilement.',
                'quick_reply_example_1' => 'Qu\'est-ce que vous proposez?',
                'quick_reply_example_2' => 'Vos tarifs',
                'quick_reply_example_3' => 'Prendre rendez-vous',
                
                'questionnaire_branching_title' => 'Logique de Branchement Avancée',
                'questionnaire_branching_subtitle' => 'Logique de Branchement',
                'questionnaire_branching_desc' => 'Ce système de questionnaire prend en charge le branchement avancé basé sur des choix de réponse spécifiques. Vous pouvez :',
                'questionnaire_branching_feature_1' => 'Créer des questions qui suivent différents chemins basés sur les réponses des utilisateurs',
                'questionnaire_branching_feature_2' => 'Configurer une logique conditionnelle où certaines questions n\'apparaissent qu\'après des réponses spécifiques',
                'questionnaire_branching_feature_3' => 'Construire des flux de questionnaire complexes et personnalisés',
                
                'questionnaire_main_desc' => 'Créez un questionnaire interactif qui s\'adapte selon les réponses des utilisateurs. Chaque question peut avoir plusieurs options de réponse, et vous pouvez configurer une logique conditionnelle pour afficher différentes questions de suivi basées sur l\'option sélectionnée.',
                
                'questionnaire_input_placeholder' => 'Entrez votre question (ex: \'Quel type de service vous intéresse?\')',
                'questions_created' => 'questions créées',
                'questionnaire_help_title' => 'Comment Fonctionne la Logique de Branchement',
                'questionnaire_help_creating_title' => 'Création de Questions :',
                'questionnaire_help_creating_1' => 'Chaque question peut avoir plusieurs options de réponse',
                'questionnaire_help_creating_2' => 'Les utilisateurs verront des boutons pour chaque option',
                'questionnaire_help_creating_3' => 'Ajoutez autant d\'options que nécessaire par question',
                
                'questionnaire_help_branching_title' => 'Configuration du Branchement :',
                'questionnaire_help_branching_1' => 'Choisissez quelle question vient avant celle-ci',
                'questionnaire_help_branching_2' => 'Optionnellement, choisissez quelle réponse spécifique déclenche cette question',
                'questionnaire_help_branching_3' => 'Les questions sans déclencheurs spécifiques s\'afficheront après toute réponse',
                
                'questionnaire_example_label' => 'Exemple :',
                'questionnaire_example_text' => 'La Question 1 demande "Quel service ?" avec les options "Web Design" et "SEO". Vous pouvez créer la Question 2a qui n\'apparaît que si "Web Design" est choisi et la Question 2b qui n\'apparaît que si "SEO" est choisi.',
                
                // Lead Generation Enhanced Section (French)
                'lead_gen_questionnaire_desc' => 'Le formulaire de lead peut maintenant être déclenché à la fin de chemins de questionnaire spécifiques.',
                'lead_form_triggering_title' => 'Déclenchement Avancé du Formulaire de Lead',
                'lead_form_triggering_desc' => 'Avec le système de branchement, vous pouvez maintenant déclencher le formulaire de lead à la fin de chemins de questionnaire spécifiques. Cela permet une collecte de leads plus ciblée basée sur les réponses des utilisateurs.',
                
                'lead_form_question_selection_desc' => 'Sélectionnez quelle question complétée devrait déclencher le formulaire de lead',
                'smart_end_node_detection_title' => 'Détection Intelligente des Nœuds de Fin :',
                'smart_end_node_detection_desc' => 'Seules les questions qui peuvent être l\'étape finale d\'un chemin de questionnaire sont montrées ici. Les questions qui mènent toujours à d\'autres questions sont automatiquement exclues.',
                'smart_end_node_detection_note' => 'Cela garantit que le formulaire de lead apparaît aux points d\'arrêt naturels de votre flux de questionnaire.',
                
                // Form Preview Enhanced (French)
                'form_preview_enhanced_desc' => 'Avec la logique de branchement, ce formulaire peut maintenant apparaître à différents points basés sur les réponses des utilisateurs.',
                // Lead generation
                'lead_generation' => 'Génération de leads',
                'lead_export' => 'Exporter les leads (CSV)',
                'lead_gen_desc' => 'Collectez les coordonnées de vos visiteurs pour les convertir en clients potentiels. Le formulaire de capture apparaîtra au moment optimal.',
                'enable_lead_gen' => 'Activer la génération de leads',
                'lead_gen_enabled' => 'Lorsqu\'elle est activée, un formulaire de contact apparaîtra pendant la conversation.',
                'when_display' => 'Quand afficher le formulaire de capture?',
                'after_reply' => 'Après une réponse rapide spécifique:',
                'no_specific_reply' => '-- Aucune (utiliser le comportement par défaut) --',
                'info_end_sequence' => 'Seules les réponses rapides qui sont à la fin d\'une séquence peuvent déclencher le formulaire. Cela permet une meilleure expérience utilisateur.',
                'customize_form' => 'Personnaliser le formulaire de capture',
                'intro_message' => 'Message d\'introduction:',
                'lead_gen_intro_message' => 'Veuillez fournir les informations suivantes :',
                'intro_message_desc' => 'Ce message s\'affiche juste avant le formulaire.',
                'form_fields' => 'Champs du formulaire',
                'field_label' => 'Champ 1 - Libellé:',
                'field_placeholder' => 'Nom:',
                'field2_label' => 'Champ 2 - Libellé:',
                'field2_placeholder' => 'Email:',
                'field3_label' => 'Champ 3 - Libellé:',
                'field3_placeholder' => 'Personalisé:',
                'consent_message' => 'J\'accepte d\'ètre contacté concernant ma demande.',
                'consent_message_desc' => 'Ce message s\'affiche à côté de la case à cocher.',
                'consent_toggle' => 'Afficher/Masquer',
                'consent_toggle_desc' => 'Activation du message de consentement',
                'consent_toggle_message' => 'Activez cette option pour masquer le message de consentement.',
                'submit_button' => 'Soumettre',
                'thank_you_message' => 'Merci !',
                'thank_you_desc' => 'Ce message s\'affiche après l\'envoi du formulaire.',
                'form_preview' => 'Aperçu du formulaire',
                'form_preview_desc' => 'Ce formulaire apparaîtra dans la conversation pour collecter les coordonnées de vos visiteurs.',
                
                'lead_email_notifications_title' => '📧 Notifications Email des Prospects',
                'enable_lead_email_notifications' => 'Activer les notifications email pour les nouveaux prospects',
                'lead_email_admin_desc' => 'Les emails seront envoyés à l\'adresse administrateur WordPress: {admin_email}',
                'current_email_address' => '📍 Adresse email actuelle:',
                'change_email_instructions' => 'Pour modifier cette adresse, allez dans Réglages → Général dans votre tableau de bord WordPress.',

                // Appearance tab
                'appearance_title' => 'Apparence',
                'chatbot_logo' => 'Logo du chatbot',
                'choose_logo' => 'Choisir un logo prédéfini :',
                'standard_robot' => 'Robot Standard',
                'ai_assistant' => 'Assistant IA',
                'pro_support' => 'Support Pro',
                'custom_logo' => 'Votre logo personnalisé',
                'upload_logo' => 'Ou télécharger votre propre logo :',
                'click_select' => 'Cliquez pour sélectionner',
                'an_image' => ' une image',
                'from_media' => ' dans la médiathèque',
                'upload_info' => 'PNG, JPG, GIF jusqu\'à 10MB',
                'primary_color' => 'Couleur Primaire',
                'secondary_color' => 'Couleur Secondaire',
                'chatbot_preview_desc' => 'Quels sont vos services?',

                // Export tab
                'export_title' => 'Sélectionnez une plage de dates pour exporter les conversations',
                'select_start' => 'Sélectionner la date de début',
                'to' => 'à',
                'select_end' => 'Sélectionner la date de fin',
                'export_download' => 'Exporter & Télécharger',
                
                // Common admin elements
                'save_changes' => 'Enregistrer les modifications',
                'paid_feature' => 'Fonctionnalité payante',
                'paid_feature_desc' => 'Cette fonctionnalité est verrouillée. Pour y accéder, veuillez <a href="https://botami.ai" target="_blank" class="text-blue-500 underline">mettre à niveau votre forfait.</a>',
                'close' => 'Fermer',
                
                // Alerts and notifications
                'settings_updated' => 'Paramètres mis à jour avec succès',
                'token_limit_exceeded' => 'Votre limite mensuelle de credits a été dépassée. Mettez à niveau votre forfait pour plus de discussions.',
                'chatbot_disabled' => 'Le chatbot est actuellement désactivé. Lorsqu\'il est désactivé, le widget du chatbot n\'apparaîtra pas aux visiteurs, mais tous vos paramètres seront conservés.',
                'please_enter_api' => 'Veuillez entrer une clé API',
                'api_verified' => 'Clé API vérifiée avec succès !',
                'verification_failed' => 'Échec de la vérification',
                'invalid_api' => 'Clé API invalide',
                'upload_failed' => 'Échec du téléchargement',
                'file_uploaded' => 'Fichier "{filename}" téléchargé avec succès !',
                'error_uploading' => 'Une erreur s\'est produite lors du téléchargement',
                'please_select_dates' => 'Veuillez sélectionner les dates de début et de fin',
                'export_failed' => 'Échec de l\'exportation. Veuillez réessayer.',
                'please_enter_reply' => 'Veuillez entrer un message de réponse rapide',
                'max_items_allowed' => 'Maximum de {max} URLs autorisées',
                'url_already_in_list' => 'Cette URL est déjà dans la liste',
                'invalid_file_format' => 'Veuillez télécharger un format de fichier valide (PDF, DOCX, CSV, XLS, XLSX)',
                'no_messages_found' => 'Aucun message trouvé pour la plage de dates sélectionnée',
                'no_file_selected' => 'Aucun fichier sélectionné.',
                'file_not_image' => 'Veuillez télécharger un fichier image (PNG, JPG, GIF).',
                'file_too_large' => 'Le fichier dépasse la taille maximale de 10 Mo.',
                'error_reading_file' => 'Une erreur s\'est produite lors de la lecture du fichier.',

                // Quick Replies UI translations
                'question_number' => 'Question #',
                'interactive_questionnaire' => 'Questionnaire interactif',
                'delete_question' => 'Supprimer cette question',
                'main_question' => 'Question principale',
                'enter_question' => 'Saisissez votre question ici...',
                'response_options' => 'Options de réponse',
                'add_option' => 'Ajouter option',
                'enter_option' => 'Saisissez l\'option {letter} ici...',
                'previous_question' => 'Question précédente',
                'optional' => 'Optionnel',
                'no_previous_question' => 'Aucune question précédente',
                'previous_answer_option' => 'Option de réponse précédente',
                'no_specific_answer' => 'Aucune Option de réponse précédente',
                'only_after_answer' => 'Cette question n\'apparaîtra que si l\'utilisateur a sélectionné l\'option de réponse spécifique ci-dessus.',
                'auto_save_enabled' => 'Sauvegarde automatique',
                'edit' => 'Modifier',
                'delete_question_confirm' => 'Êtes-vous sûr de vouloir supprimer cette question ?',
                'enter_question_message' => 'Veuillez entrer un message de question',
                'remove_all_confirm' => 'Êtes-vous sûr de vouloir supprimer toutes les réponses rapides ?',
            ]
        ]
    ];

    private static $supported_languages = ['en', 'fr'];

    /**
     * Get the site language based on WordPress locale
     * 
     * @return string Language code ('en' or 'fr')
     */
    public static function get_site_language() {
        // Get WordPress locale
        $locale = get_locale();
        
        // Extract the language part (e.g., 'fr' from 'fr_FR')
        $lang = substr($locale, 0, 2);
        
        // Return the language if supported, otherwise default to English
        return in_array($lang, self::$supported_languages) ? $lang : 'en';
    }
    
    /**
     * Get the user's browser language (used for frontend)
     * 
     * @return string Language code ('en' or 'fr')
     */
    public static function get_user_language() {
        // Get the Accept-Language header
        $accept_language = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) 
            ? sanitize_text_field(wp_unslash($_SERVER['HTTP_ACCEPT_LANGUAGE']))
            : '';
            
        
        if (!empty($accept_language)) {
            // Split the string and get language codes
            $browser_languages = array_map(
                function($lang) {
                    // Extract just the language code part (e.g., 'en' from 'en-US')
                    return sanitize_text_field(strtolower(substr(trim($lang), 0, 2)));
                },
                explode(',', $accept_language)
            );
            
            foreach ($browser_languages as $lang) {
                if (in_array($lang, self::$supported_languages, true)) {
                    return $lang;
                }
            }
        }
        
        // If browser language detection fails, fall back to site language
        return self::get_site_language();
    }
    
    /**
     * Get text for widget front-end
     *
     * @param string $key Translation key
     * @return string Translated text
     */
    public static function get_text($key) {
        $language = self::get_user_language();
        return self::$translations[$language][$key] ?? self::$translations['en'][$key];
    }
    
    /**
     * Get text for admin dashboard
     *
     * @param string $key Translation key in dot notation (e.g., 'admin.dashboard_title')
     * @param array $replacements Optional array of key-value pairs for string replacements
     * @return string Translated text
     */
    public static function get_admin_text($key, $replacements = []) {
        $language = self::get_site_language();
        
        // Split the key to navigate the nested array
        $parts = explode('.', $key);
        
        // Handle standard admin keys (with 'admin.' prefix)
        if (count($parts) === 2 && $parts[0] === 'admin') {
            $sub_key = $parts[1];
            
            // Get the translation or fall back to English
            $text = self::$translations[$language]['admin'][$sub_key] ?? 
                    self::$translations['en']['admin'][$sub_key] ?? 
                    null;
        } 
        // Handle direct widget keys (without the 'admin.' prefix)
        else {
            // Try to find the key directly in the top-level translations
            $text = self::$translations[$language][$key] ?? 
                    self::$translations['en'][$key] ?? 
                    null;
        }
        
        // If no translation found, return an error message
        if ($text === null) {
            return "Missing translation: {$key}";
        }
        
        // Apply any replacements
        if (!empty($replacements)) {
            foreach ($replacements as $search => $replace) {
                $text = str_replace('{' . $search . '}', $replace, $text);
            }
        }
        
        return $text;
    }
}