<?php
if (!defined('ABSPATH')) exit;
class Botami_Assets {
    public static function enqueue_assets() {
        if (!Botami_Url_Checker::is_url_excluded()) {
            $cache_buster = get_option('botami_cache_buster', BOTAMI_VERSION);
            wp_enqueue_script('botami-script', BOTAMI_PLUGIN_URL . 'assets/js/chatbot.js', ['jquery'], $cache_buster, true);

            wp_localize_script('botami-script', 'botamiChatbot', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce'    => wp_create_nonce('chatbot_nonce'),
                'nonceMessage'    => wp_create_nonce('message_chatbot_nonce'),
            ]);

            $api_key = get_option('botami_api_key', '');
            $plan = get_option('botami_plan', '');
            
            $access_level = 'no_api';
            if (!empty($api_key)) {
                $access_level = in_array($plan, ['free', 'pro', 'premium', 'entreprise']) ? $plan : 'free';
            }
            
            $is_premium = in_array($access_level, ['premium', 'entreprise']);
            $is_pro_or_higher = in_array($access_level, ['pro', 'premium', 'entreprise']);

            $should_reload = get_option('botami_should_reload', '1');

            $lead_gen_enabled = $is_premium && get_option('botami_lead_gen_enabled', '0') === '1';
            $consent_is_active = $is_premium && get_option('botami_lead_consent_is_active', '0') === '1';
            
            $lead_gen_field_placeholder = $is_premium ? get_option('botami_lead_gen_field_placeholder', '') : '';

            $lead_gen_name_placeholder = $is_premium ? get_option(
                'botami_lead_gen_name_placeholder', 
                Botami_Language_Manager::get_admin_text('admin.field_placeholder')
            ) : '';

            $lead_gen_email_placeholder = $is_premium ? get_option(
                'botami_lead_gen_email_placeholder', 
                Botami_Language_Manager::get_admin_text('admin.field2_placeholder')
            ) : '';

            $lead_gen_button_text = $is_premium ? get_option(
                'botami_lead_gen_button_text', 
                Botami_Language_Manager::get_admin_text('admin.submit_button')
            ) : '';

            $lead_gen_consentment = $is_premium ? get_option(
                'botami_lead_gen_consentment', 
                Botami_Language_Manager::get_admin_text('admin.consent_message')
            ) : '';

            $has_submitted_lead = false;
            if ($lead_gen_enabled) {
                $lead_generator = Botami_Lead_Generator::getInstance();
                $has_submitted_lead = $lead_generator->has_submitted_lead();
            }

            $lead_gen_intro_message = $is_premium ? get_option('botami_lead_gen_intro_message', 'To better assist you, please provide your information:') : '';
            $lead_gen_thank_you = $is_premium ? get_option('botami_lead_gen_thank_you', 'Thank you! Your information has been saved.') : '';
            $lead_gen_quick_reply = $is_premium ? get_option('botami_lead_gen_quick_reply', '') : '';

            wp_localize_script('botami-script', 'botami_site_data', [
                'site_name' => get_bloginfo('name'),
                'bot_image_url' => get_option('botami_bot_image_url', BOTAMI_PLUGIN_URL . 'assets/img/bot_image.jpeg' ),
                'primary_color' => get_option('botami_primary_color', '#31377B'),
                'secondary_color' => get_option('botami_secondary_color', '#673DE6'),
                'message_bienvenue' => botami_get_translated_text(
                    'botami_default_message', 
                    Botami_Language_Manager::get_text('first_message')
                ),
                'placeholder_text' => botami_get_translated_text(
                    'botami_placeholder_text', 
                    Botami_Language_Manager::get_text('write_message')
                ),
                'reload_text' => botami_get_translated_text(
                    'botami_reload_text', 
                    Botami_Language_Manager::get_text('refresh_message')
                ),
                'welcome_message' => botami_get_translated_text(
                    'botami_welcome_message', 
                    Botami_Language_Manager::get_text('assist_message')
                ),
                
                'quick_replies' => $is_premium ? get_option('botami_quick_replies', '[]') : '[]',
                
                'lead_gen_enabled' => $lead_gen_enabled,
                'lead_gen_field_placeholder' => $lead_gen_field_placeholder,
                'lead_gen_name_placeholder' => $lead_gen_name_placeholder,
                'lead_gen_email_placeholder' => $lead_gen_email_placeholder,
                'lead_gen_button_text' => $lead_gen_button_text,
                'lead_gen_consentment' => $lead_gen_consentment,
                'consent_is_active' => $consent_is_active,
                'lead_gen_intro_message' => $lead_gen_intro_message,
                'lead_gen_thank_you' => $lead_gen_thank_you,
                'lead_already_submitted' => $has_submitted_lead,
                'lead_gen_quick_reply' => $lead_gen_quick_reply,
                'should_reload' => $should_reload,
                'translations' => array(
                    'typing_message' => Botami_Language_Manager::get_text('typing_message'),
                    'error_message' => Botami_Language_Manager::get_text('error_message'),
                    'was_helpful' => Botami_Language_Manager::get_text('was_helpful'),
                    'yes' => Botami_Language_Manager::get_text('yes'),
                    'no' => Botami_Language_Manager::get_text('no'),
                    'feedback_positive' => Botami_Language_Manager::get_text('feedback_positive'),
                    'feedback_negative' => Botami_Language_Manager::get_text('feedback_negative'),
                    'feedback_response_positive' => Botami_Language_Manager::get_text('feedback_response_positive'),
                    'feedback_response_negative' => Botami_Language_Manager::get_text('feedback_response_negative'),
                    'lead_form_transition' => Botami_Language_Manager::get_text('lead_form_transition'),
                    'questionnaire_fallback' => Botami_Language_Manager::get_text('questionnaire_fallback')
                )
            ]);
        }
    }
}