<?php
if (!defined('ABSPATH')) exit;
class Botami_API_Config {
    private static $base_url = 'https://serveur.botami.ai';

    public static function get_endpoint($path) {
        return self::$base_url . '/api/v1/' . trim($path, '/');
    }
    
    public static function get_verify_endpoint() {
        return self::get_endpoint('verify');
    }
    
    public static function get_upload_endpoint() {
        return self::get_endpoint('upload-content');
    }
    
    public static function get_pdf_upload_endpoint() {
        return self::get_endpoint('upload-pdf');
    }

    public static function get_registration_endpoint() {
        return self::get_endpoint('plugin-activate');
    }
    
    public static function get_message_endpoint() {
        return self::get_endpoint('send-message');
    }

    public static function get_save_feedback_endpoint() {
        return self::get_endpoint('save-feedback');
    }

    public static function get_scrape_urls_endpoint() {
        return self::get_endpoint('scrape-urls');
    }

    public static function get_token_usage_endpoint() {
        return self::get_endpoint('token-usage');
    }

    public static function get_delete_content_endpoint() {
        return self::get_endpoint('delete-content');
    }

    public static function get_translation_endpoint() {
        return self::get_endpoint('translate-texts');
    }
}