<?php
if (!defined('ABSPATH')) exit;
?>
<div class="wrap btm-mx-auto btm-mt-10 btm-mr-5 bg-admin-panel btm-rounded-lg btm-shadow-lg btm-bot-global">
    <nav class="btm-relative btm-flex btm-w-full btm-flex-wrap btm-items-center btm-justify-between btm-bg-[#673DE6] btm-py-2 shadow-dark-mild dark:btm-bg-neutral-700 lg:btm-py-4">
        <div class="btm-flex btm-w-full btm-flex-wrap btm-items-center btm-justify-between btm-px-3">
            <div>
                <a class="btm-mx-2 btm-my-1 btm-flex btm-items-center lg:btm-mb-0 lg:btm-mt-0" href="#">
                    <?php
                    $bot_logo_url = BOTAMI_PLUGIN_URL . 'assets/img/bot_image.jpeg';
                    echo wp_kses(sprintf(
                        '<img src="%s" alt="%s" class="btm-inline-block btm-w-12 btm-h-12 btm-m-5 btm-border-none btm-rounded-full btm-align-middle" />',
                        esc_url($bot_logo_url),
                        esc_attr__('Bot Image', 'botami-chatbot')
                    ), array(
                        'img' => array(
                            'src' => array(),
                            'alt' => array(),
                            'class' => array()
                        )
                    ));
                    ?>
                    <span class="text-color-botami btm-text-4xl"><?php botamichat_admin_e('admin.dashboard_botami'); ?></span>
                </a>
            </div>
        </div>
    </nav>
    <div class="btm-p-4 btm-m-4 btm-text-sm btm-text-green-800 btm-rounded-lg btm-bg-green-50 dark:btm-bg-gray-800 dark:btm-text-green-400 <?php echo (isset($_GET['settings-updated']) && $_GET['settings-updated'] == true) ? '' : 'btm-hidden' ?>" id="success-alert" role="alert">
        <?php botamichat_admin_e('admin.settings_updated'); ?>
    </div>
    <div
        class="btm-p-4 btm-m-4 btm-text-sm btm-text-red-800 btm-rounded-lg btm-bg-red-50 dark:btm-bg-gray-800 dark:btm-text-red-400 btm-hidden"
        id="error-alert"
        role="alert"></div>
    <?php if (get_option('botami_exceed_limit') !== false && get_option('botami_exceed_limit') == 1) { ?>
        <div
            class="btm-p-4 btm-m-4 btm-text-sm btm-text-yellow-800 btm-rounded-lg btm-bg-yellow-50 dark:btm-bg-gray-800 dark:btm-text-yellow-400"
            role="alert">
            <?php botamichat_admin_e('admin.token_limit_exceeded'); ?>
        </div>
    <?php } ?>
    <?php if (get_option('botami_is_active', '1') !== '1') { ?>
        <div
            class="btm-p-4 btm-m-4 btm-text-sm btm-text-yellow-800 btm-rounded-lg btm-bg-yellow-50 dark:btm-bg-gray-800 dark:btm-text-yellow-400"
            role="alert">
            <?php botamichat_admin_e('admin.chatbot_disabled'); ?>
        </div>
    <?php } ?>
    <div class="btm-p-6">
        <nav class="btm-flex btm-space-x-4 btm-border-b btm-border-gray-200 btm-mb-6 btm-text-center">
            <button
                class="tab-link btm-px-6 btm-py-2 text-link-admin-panel btm-font-semibold"
                data-tab="dashboard">
                <?php botamichat_admin_e('admin.dashboard_title'); ?>
            </button>
            <button
                class="tab-link btm-px-6 btm-py-2 text-link-admin-panel btm-font-semibold"
                data-tab="general">
                <?php botamichat_admin_e('admin.general_title'); ?>
            </button>
            <button
                class="tab-link btm-px-6 btm-py-2 text-link-admin-panel btm-font-semibold"
                data-tab="appearance">
                <?php botamichat_admin_e('admin.appearance_title'); ?>
            </button>
            <button
                class="tab-link btm-px-6 btm-py-2 text-link-admin-panel btm-font-semibold"
                data-tab="bot-config">
                <?php botamichat_admin_e('admin.bot_config_title'); ?>
            </button>
            <button
                class="tab-link btm-px-6 btm-py-2 text-link-admin-panel btm-font-semibold"
                data-tab="bot-quick-replies">
                <?php botamichat_admin_e('admin.quick_replies_title'); ?> & <?php botamichat_admin_e('admin.lead_generation'); ?>
            </button>
            <button
                class="tab-link btm-px-6 btm-py-2 text-link-admin-panel btm-font-semibold"
                data-tab="bot-export">
                <?php botamichat_admin_e('admin.export_conversations'); ?>
            </button>
        </nav>
        <div id="api-validation-message" class="btm-hidden btm-mb-4 btm-p-4 btm-rounded"></div>
        <form
            method="post"
            action="<?php echo esc_url(admin_url('admin-post.php')); ?>"
            enctype="multipart/form-data">
            <?php wp_nonce_field('chatbot_settings_action', 'chatbot_settings_nonce'); ?>
            <input type="hidden" name="action" value="update_chatbot_settings" />
            <input type="hidden" name="current_tab" id="current_tab" value="dashboard">
            <!-- API Key Tab -->
            <div
                class="tab-content btm-transition-opacity btm-flex btm-flex-col btm-duration-500 btm-opacity-0 btm-hidden"
                id="dashboard">
                <?php if ($has_api): ?>
                    <!-- Dashboard pour utilisateur avec clé API active -->
                    <div class="btm-bg-white btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6 btm-w-full">
                        <div class="btm-flex btm-items-center btm-justify-between btm-mb-6">
                            <h2 class="btm-text-2xl btm-font-bold btm-text-gray-800">
                                <?php botamichat_admin_e('admin.dashboard_title'); ?>
                            </h2>
                            <div class="btm-flex btm-items-center">
                                <span class="btm-inline-flex btm-items-center btm-px-3 btm-py-1 btm-rounded-full btm-text-sm btm-font-medium btm-bg-green-100 btm-text-green-800">
                                    <svg class="btm-w-4 btm-h-4 btm-mr-1.5 btm-text-green-500" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    <?php botamichat_admin_e('admin.api_active'); ?>
                                </span>
                            </div>
                        </div>
                        <!-- Statistiques -->
                        <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-3 btm-gap-6 btm-mb-6">
                            <div class="btm-bg-gradient-to-br btm-from-blue-50 btm-to-indigo-50 btm-p-6 btm-rounded-lg btm-shadow">
                                <div class="btm-flex btm-justify-between btm-items-center">
                                    <div>
                                        <h3 class="btm-text-sm btm-font-medium btm-text-gray-500"><?php botamichat_admin_e('admin.total_conversations'); ?></h3>
                                        <p class="btm-text-3xl btm-font-bold btm-text-gray-800">
                                            <?php
                                            $total_conversations = get_option('botami_total_conversations', 0);
                                            echo esc_html($total_conversations);
                                            ?>
                                        </p>
                                    </div>
                                    <div class="btm-p-3 btm-bg-white btm-rounded-full">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-indigo-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="btm-bg-gradient-to-br btm-from-green-50 btm-to-teal-50 btm-p-6 btm-rounded-lg btm-shadow">
                                <div class="btm-flex btm-justify-between btm-items-center">
                                    <div>
                                        <h3 class="btm-text-sm btm-font-medium btm-text-gray-500"><?php botamichat_admin_e('admin.messages_exchanged'); ?></h3>
                                        <p class="btm-text-3xl btm-font-bold btm-text-gray-800">
                                            <?php
                                            $total_messages = get_option('botami_total_messages', 0);
                                            echo esc_html($total_messages);
                                            ?>
                                        </p>
                                    </div>
                                    <div class="btm-p-3 btm-bg-white btm-rounded-full">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-teal-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="btm-bg-gradient-to-br btm-from-purple-50 btm-to-pink-50 btm-p-6 btm-rounded-lg btm-shadow">
                                <div class="btm-flex btm-justify-between btm-items-center">
                                    <div>
                                        <h3 class="btm-text-sm btm-font-medium btm-text-gray-500"><?php botamichat_admin_e('admin.leads_generated'); ?></h3>
                                        <p class="btm-text-3xl btm-font-bold btm-text-gray-800">
                                            <?php
                                            $total_leads = get_option('botami_total_leads', 0);
                                            echo esc_html($total_leads);
                                            ?>
                                        </p>
                                    </div>
                                    <div class="btm-p-3 btm-bg-white btm-rounded-full">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-purple-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Lien vers le tableau de bord -->
                        <div class="btm-mb-6">
                            <a href="https://app.botami.ai/dashboard" target="_blank" class="btn-botami btm-text-black btm-px-4 btm-py-2 btm-rounded-lg btm-text-sm">
                                <?php botamichat_admin_e('admin.view_dashboard'); ?>
                            </a>
                        </div>
                        <!-- Informations sur l'API -->
                        <div class="btm-bg-white btm-border btm-border-gray-200 btm-rounded-lg btm-p-6 btm-mb-6">
                            <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4"><?php botamichat_admin_e('admin.api_key_info'); ?></h3>
                            <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-4">
                                <div>
                                    <p class="btm-text-sm btm-text-gray-500"><?php botamichat_admin_e('admin.api_key'); ?></p>
                                    <div class="btm-flex btm-items-center btm-mt-1">
                                        <input type="text" name="botami_api_key" placeholder="<?php botamichat_admin_attr_e('admin.modify_api_key'); ?>" class="btm-bg-gray-50 btm-border btm-border-gray-300 btm-text-gray-900 btm-text-sm btm-rounded-lg btm-focus:ring-blue-500 btm-focus:border-blue-500 btm-block btm-w-full btm-p-2.5" />
                                    </div>
                                </div>
                                <div>
                                    <p class="btm-text-sm btm-text-gray-500"><?php botamichat_admin_e('admin.active_plan'); ?></p>
                                    <div class="btm-flex btm-items-center btm-mt-1">
                                        <span class="btm-bg-gray-50 btm-border btm-border-gray-300 btm-text-gray-900 btm-text-sm btm-rounded-lg btm-block btm-w-full btm-p-2.5">
                                            <?php echo esc_html($access_level); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="btm-mt-4">
                                <p class="btm-text-sm btm-text-gray-500"><?php botamichat_admin_e('admin.token_usage'); ?></p>
                                <div class="btm-mt-1 btm-bg-gray-200 btm-rounded-full btm-h-4 btm-overflow-hidden">
                                    <?php
                                    $usage_percent = Botami_Token_Usage::get_usage_percentage();
                                    $bar_color = Botami_Token_Usage::get_usage_color_class();
                                    ?>
                                    <div class="<?php echo esc_attr($bar_color); ?> btm-h-4" style="width: <?php echo esc_attr($usage_percent); ?>%"></div>
                                </div>
                                <div class="btm-flex btm-justify-between btm-mt-1 btm-text-xs btm-text-gray-500">
                                    <span><?php echo esc_html(Botami_Token_Usage::get_formatted_usage()); ?> <?php botamichat_admin_e('admin.credis_used'); ?></span>
                                    <span><?php echo esc_html(Botami_Token_Usage::get_formatted_limit()); ?> <?php botamichat_admin_e('admin.max_credis'); ?></span>
                                </div>
                            </div>
                            <div class="btm-mt-6 btm-flex btm-items-center btm-justify-between">
                                <button id="refresh-api-status" class="btm-text-sm btm-text-blue-600 hover:btm-text-blue-800 btm-flex btm-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-4 btm-w-4 btm-mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                    </svg>
                                    <?php botamichat_admin_e('admin.refresh_data'); ?>
                                </button>
                                <button id="verify-api-key" type="button" class="btn-botami btm-text-black btm-px-4 btm-py-2 btm-rounded-lg btm-text-sm">
                                    <?php botamichat_admin_e('admin.modify_api_key'); ?>
                                </button>
                            </div>
                        </div>
                        <!-- Liens rapides et aide -->
                        <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-6">
                            <div class="btm-bg-white btm-border btm-border-gray-200 btm-rounded-lg btm-p-6">
                                <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4"><?php botamichat_admin_e('admin.quick_links'); ?></h3>
                                <ul class="btm-space-y-2">
                                    <li>
                                        <a href="?page=botami-settings&tab=bot-config" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c-.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            </svg>
                                            <?php botamichat_admin_e('admin.chatbot_config'); ?>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="?page=botami-settings&tab=appearance" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01" />
                                            </svg>
                                            <?php botamichat_admin_e('admin.customization'); ?>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="?page=botami-settings&tab=bot-quick-replies" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                                            </svg>
                                            <?php botamichat_admin_e('admin.quick_replies'); ?>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="?page=botami-settings&tab=bot-export" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                            <?php botamichat_admin_e('admin.export_conversations'); ?>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="btm-bg-white btm-border btm-border-gray-200 btm-rounded-lg btm-p-6">
                                <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4"><?php botamichat_admin_e('admin.need_help'); ?></h3>
                                <p class="btm-text-gray-600 btm-mb-4"><?php botamichat_admin_e('admin.help_desc'); ?></p>
                                <div class="btm-space-y-3">
                                    <a href="https://botami.ai/docs" target="_blank" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                        </svg>
                                        <?php botamichat_admin_e('admin.documentation'); ?>
                                    </a>
                                    <a href="https://botami.ai/support" target="_blank" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                                        </svg>
                                        <?php botamichat_admin_e('admin.help_center'); ?>
                                    </a>
                                    <a href="https://botami.ai/contact" target="_blank" class="btm-flex btm-items-center btm-text-blue-600 hover:btm-text-blue-800 btm-transition-colors">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                        </svg>
                                        <?php botamichat_admin_e('admin.contact_support'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php else: ?>
                    <!-- Affichage pour les utilisateurs sans clé API -->
                    <div class="btm-flex btm-gap-2">
                        <div class="btm-p-6 btm-mr-6 btm-mb-6">
                            <h2 class="btm-text-2xl btm-font-bold text-color-botami btm-mb-4"><?php botamichat_admin_e('admin.api_key'); ?></h2>
                            <p class="text-color-botami btm-mb-4">
                                <?php botamichat_admin_e('admin.connect_desc'); ?>
                            </p>
                            <div class="btm-mb-4">
                                <input
                                    type="text"
                                    name="botami_api_key"
                                    class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-h-10 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200"
                                    placeholder="<?php botamichat_admin_attr_e('admin.api_key_placeholder'); ?>" />
                            </div>
                            <button
                                type="button"
                                id="verify-api-key"
                                class="btn-botami btm-text-black btm-px-4 btm-py-2 btm-rounded">
                                <?php botamichat_admin_e('admin.verify_api_key'); ?>
                            </button>
                        </div>
                        <div class="clr-bg-green btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6">
                            <h2 class="btm-text-4xl btm-font-bold btm-text-black btm-mb-4">
                                <?php botamichat_admin_e('admin.connect_botami'); ?>
                            </h2>
                            <p class="btm-text-black btm-mb-4">
                                <?php botamichat_admin_e('admin.connect_desc'); ?>
                            </p>
                            <div class="btm-mb-4">
                                <a
                                    href="https://app.botami.ai/sign-in"
                                    target="_blank"
                                    class="btm-inline-block btn clr-bg-blue btm-text-white btm-p-4 btm-rounded hover:btm-bg-gray-200 hover:btm-text-black">
                                    <?php botamichat_admin_e('admin.get_api_key'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <?php if ($has_api): ?>
                <!-- General Tab -->
                <div class="tab-content btm-transition-opacity btm-duration-500" id="general">
                    <div class="btm-bg-white btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6">
                        <h2 class="btm-text-2xl btm-font-bold btm-text-gray-800 btm-mb-4">
                            <?php botamichat_admin_e('admin.personalization'); ?>
                        </h2>
                        <p class="btm-text-gray-600 btm-mb-6">
                            <?php botamichat_admin_e('admin.personalization_desc'); ?>
                        </p>
                        <!-- Section d'activation du chatbot -->
                        <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg btm-mb-6">
                            <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-2"><?php botamichat_admin_e('admin.chatbot_activation'); ?></h3>
                            <p class="btm-text-gray-600 btm-mb-3"><?php botamichat_admin_e('admin.activation_desc'); ?></p>
                            <div class="btm-flex btm-items-center btm-mb-2">
                                <label class="toggle-switch">
                                    <input type="hidden" name="botami_is_active" value="0">
                                    <input type="checkbox" id="chatbot-active-toggle" name="botami_is_active" value="1" <?php checked(get_option('botami_is_active', '1'), '1'); ?>>
                                    <span class="toggle-slider"></span>
                                </label>
                                <span class="btm-ml-3 btm-text-sm btm-font-medium btm-text-gray-900"><?php botamichat_admin_e('admin.enable_disable'); ?></span>
                            </div>
                        </div>
                        <!-- Section de persistance de conversation -->
                        <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg btm-mb-6">
                            <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-2"><?php botamichat_admin_e('admin.conversation_persistence'); ?></h3>
                            <p class="btm-text-gray-600 btm-mb-3"><?php botamichat_admin_e('admin.persistence_desc'); ?></p>
                            <div class="btm-flex btm-items-center btm-mb-2">
                                <label class="toggle-switch">
                                    <input type="hidden" name="botami_should_reload" value="0">
                                    <input type="checkbox" id="should-reload-checkbox" name="botami_should_reload" value="1" <?php checked(get_option('botami_should_reload', '1'), '1'); ?>>
                                    <span class="toggle-slider"></span>
                                </label>
                                <span class="btm-ml-3 btm-text-sm btm-font-medium btm-text-gray-900"><?php botamichat_admin_e('admin.enable_disable_persistence'); ?></span>
                            </div>
                        </div>
                        <!-- Section messages et interfaces -->
                        <div class="btm-mb-6 btm-bg-gradient-to-r btm-from-blue-50 btm-to-indigo-50 btm-border-l-4 btm-border-blue-500 btm-rounded-lg btm-p-6">
                            <h3 class="btm-text-xl btm-font-semibold btm-text-gray-800 btm-mb-2 btm-flex btm-items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-6 btm-w-6 btm-mr-2 btm-text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129" />
                                </svg>
                                <?php botamichat_admin_e('admin.auto_translation'); ?>
                            </h3>
                            <p class="btm-text-gray-600 btm-text-sm btm-mb-4"><?php botamichat_admin_e('admin.auto_translation_desc'); ?></p>

                            <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-6">
                                <!-- Input Language Selection -->
                                <div>
                                    <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2">
                                        <?php botamichat_admin_e('admin.input_language'); ?>
                                    </label>
                                    <p class="btm-text-gray-500 btm-text-xs btm-mb-2"><?php botamichat_admin_e('admin.input_language_desc'); ?></p>
                                    <?php
                                    // Use WordPress site language as default instead of hardcoded 'en'
                                    $default_language = Botami_Language_Manager::get_site_language();
                                    $current_input_language = get_option('botami_input_language', $default_language);
                                    ?>
                                    <select name="botami_input_language" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring-2 btm-focus:ring-blue-500 btm-bg-white">
                                        <option value="en" <?php selected($current_input_language, 'en'); ?>>English (EN)</option>
                                        <option value="fr" <?php selected($current_input_language, 'fr'); ?>>Français (FR)</option>
                                    </select>
                                </div>

                                <!-- Enabled Languages Checkboxes -->
                                <div>
                                    <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2">
                                        <?php botamichat_admin_e('admin.enabled_languages'); ?>
                                    </label>
                                    <p class="btm-text-gray-500 btm-text-xs btm-mb-3"><?php botamichat_admin_e('admin.enabled_languages_desc'); ?></p>

                                    <div class="btm-flex btm-flex-col btm-gap-3">
                                        <?php
                                        // Use WordPress site language as default instead of hardcoded 'en'
                                        $default_language = Botami_Language_Manager::get_site_language();
                                        $default_enabled_languages = json_encode([$default_language]);
                                        $enabled_languages_json = get_option('botami_enabled_languages', $default_enabled_languages);
                                        $enabled_languages = json_decode($enabled_languages_json, true);
                                        if (!is_array($enabled_languages)) {
                                            $enabled_languages = [$default_language];
                                        }
                                        ?>
                                        <label class="btm-flex btm-items-center btm-bg-white btm-p-3 btm-rounded btm-border btm-border-gray-200 hover:btm-border-blue-300 btm-transition btm-cursor-pointer">
                                            <input type="checkbox" name="botami_enabled_languages[]" value="en"
                                                <?php checked(in_array('en', $enabled_languages)); ?>
                                                class="btm-mr-3 btm-w-4 btm-h-4 btm-text-blue-600">
                                            <span class="btm-font-medium">English (EN)</span>
                                        </label>

                                        <label class="btm-flex btm-items-center btm-bg-white btm-p-3 btm-rounded btm-border btm-border-gray-200 hover:btm-border-blue-300 btm-transition btm-cursor-pointer">
                                            <input type="checkbox" name="botami_enabled_languages[]" value="fr"
                                                <?php checked(in_array('fr', $enabled_languages)); ?>
                                                class="btm-mr-3 btm-w-4 btm-h-4 btm-text-blue-600">
                                            <span class="btm-font-medium">Français (FR)</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="btm-mt-4 btm-p-3 btm-bg-blue-100 btm-rounded btm-text-sm btm-text-blue-800">
                                <?php echo wp_kses_post(botamichat_admin_text('admin.auto_translate_note')); ?>
                            </div>
                        </div>
                        <div class="btm-flex btm-mb-6">
                            <div class="btm-w-1/2 btm-pr-4">
                                <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg">
                                    <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4"><?php botamichat_admin_e('admin.texts_messages'); ?></h3>
                                    <p class="btm-text-gray-600 btm-mb-4"><?php botamichat_admin_e('admin.texts_desc'); ?></p>
                                    <div class="btm-mb-4">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.welcome_message'); ?></label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mb-2"><?php botamichat_admin_e('admin.welcome_message_desc'); ?></p>
                                        <input
                                            type="text"
                                            name="botami_welcome_message"
                                            id="welcome-message-input"
                                            value="<?php echo esc_attr(get_option('botami_welcome_message', botamichat_admin_text('admin.chatbot_preview'))); ?>"
                                            class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                        <div class="btm-mt-2 btm-flex btm-items-center">
                                            <label class="toggle-switch">
                                                <input type="hidden" name="botami_welcome_message_enabled" value="0">
                                                <input type="checkbox" id="welcome-message-toggle" name="botami_welcome_message_enabled" value="1" <?php checked(get_option('botami_welcome_message_enabled', '1'), '1'); ?>>
                                                <span class="toggle-slider"></span>
                                            </label>
                                            <span class="btm-ml-3 btm-text-sm btm-font-medium btm-text-gray-900"><?php botamichat_admin_e('admin.enable_disable_welcome'); ?></span>
                                        </div>
                                    </div>
                                    <div class="btm-mb-4">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.chatbot_title'); ?></label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mb-2"><?php botamichat_admin_e('admin.chatbot_title_desc'); ?></p>
                                        <input
                                            type="text"
                                            name="botami_heading_text"
                                            id="heading-text-input"
                                            value="<?php echo esc_attr(get_option('botami_heading_text', botamichat_admin_text('greeting'))); ?>"
                                            class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                    </div>
                                    <div class="btm-mb-4">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.status_text'); ?></label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mb-2"><?php botamichat_admin_e('admin.status_text_desc'); ?></p>
                                        <input
                                            type="text"
                                            name="botami_online_status_text"
                                            id="online-status-input"
                                            value="<?php echo esc_attr(get_option('botami_online_status_text', botamichat_admin_text('online_status'))); ?>"
                                            class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                    </div>
                                    <div class="btm-mb-4">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.reload_text'); ?></label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mb-2"><?php botamichat_admin_e('admin.reload_text_desc'); ?></p>
                                        <input
                                            type="text"
                                            name="botami_reload_text"
                                            id="reload-text-input"
                                            value="<?php echo esc_attr(get_option('botami_reload_text', botamichat_admin_text('refresh_message'))); ?>"
                                            class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                    </div>
                                    <div class="btm-mb-4">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.input_placeholder'); ?></label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mb-2"><?php botamichat_admin_e('admin.input_placeholder_desc'); ?></p>
                                        <input
                                            type="text"
                                            name="botami_placeholder_text"
                                            id="placeholder-input"
                                            value="<?php echo esc_attr(get_option('botami_placeholder_text', botamichat_admin_text('write_message'))); ?>"
                                            class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                    </div>
                                    <div class="btm-mb-4">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.default_message'); ?></label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mb-2"><?php botamichat_admin_e('admin.default_message_desc'); ?></p>
                                        <input
                                            type="text"
                                            name="botami_default_message"
                                            id="default-message-input"
                                            value="<?php echo esc_attr(get_option('botami_default_message', botamichat_admin_text('assist_message'))); ?>"
                                            class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                    </div>
                                </div>
                            </div>
                            <div class="btm-w-1/2 btm-pl-4">
                                <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg btm-h-full">
                                    <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4"><?php botamichat_admin_e('admin.chatbot_preview'); ?></h3>
                                    <p class="btm-text-gray-600 btm-mb-4"><?php botamichat_admin_e('admin.preview_desc'); ?></p>
                                    <?php
                                    $current_language = botami_get_current_language();
                                    $image_file = ($current_language === 'fr') ? 'screen_fr.png' : 'screen_en.png';
                                    $image_file_welcome_message = ($current_language === 'fr') ? 'welcome_msg_fr.png' : 'welcome_msg_en.png';
                                    $welcome_image_url = BOTAMI_PLUGIN_URL . 'assets/img/' . $image_file_welcome_message;
                                    $screen_image_url = BOTAMI_PLUGIN_URL . 'assets/img/' . $image_file;
                                    ?>
                                    <?php echo wp_kses(sprintf(
                                        '<img src="%s" class="btm-border btm-border-white btm-overflow-hidden btm-mb-12 size-img-welcome-message btm-rounded-xl" alt="%s">',
                                        esc_url($welcome_image_url),
                                        esc_attr(botamichat_admin_text('admin.chatbot_preview'))
                                    ), array(
                                        'img' => array(
                                            'src' => array(),
                                            'class' => array(),
                                            'alt' => array()
                                        )
                                    )); ?>
                                    <?php echo wp_kses(sprintf(
                                        '<img src="%s" class="btm-border btm-border-white btm-overflow-hidden img_aparence btm-rounded-xl" style="width: 350px;" alt="%s">',
                                        esc_url($screen_image_url),
                                        esc_attr(botamichat_admin_text('admin.chatbot_preview'))
                                    ), array(
                                        'img' => array(
                                            'src' => array(),
                                            'class' => array(),
                                            'alt' => array(),
                                            'style' => array()
                                        )
                                    )); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Section URLs exclues -->
                        <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg btm-mb-6">
                            <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-2"><?php botamichat_admin_e('admin.excluded_pages'); ?></h3>
                            <p class="btm-text-gray-600 btm-mb-4"><?php botamichat_admin_e('admin.excluded_desc'); ?></p>
                            <!-- Champ d'ajout d'URL visible directement -->
                            <div class="btm-w-full btm-mb-4" id="form_add_excluded_url">
                                <div class="btm-flex btm-gap-2 btm-w-full">
                                    <input
                                        type="text"
                                        class="btm-flex-1 btm-bg-gray-50 btm-border btm-border-gray-300 btm-text-gray-900 btm-text-sm btm-rounded-lg btm-focus:ring-2 btm-focus:ring-blue-500 btm-focus:border-blue-500 btm-block btm-px-4 btm-py-2.5 btm-transition-all"
                                        id="excluded_url_input"
                                        placeholder="<?php botamichat_admin_attr_e('admin.excluded_url_example'); ?>" />
                                    <button
                                        id="add_excluded_url_submit"
                                        class="btn-botami btm-text-black btm-font-medium btm-px-6 btm-py-2.5 btm-rounded-lg btm-shadow-md btm-hover:shadow-lg btm-transition-all btm-whitespace-nowrap">
                                        <?php botamichat_admin_e('admin.add_excluded_url'); ?>
                                    </button>
                                </div>
                                <p class="btm-text-gray-500 btm-text-sm btm-mt-2"><?php botamichat_admin_e('admin.excluded_url_info'); ?></p>
                            </div>
                            <div
                                id="excluded_urls_container"
                                class="btm-relative btm-overflow-x-auto btm-shadow-md btm-sm:rounded-lg <?php echo empty(get_option('botami_excluded_urls')) ? 'btm-hidden' : ''; ?>">
                                <input
                                    type="hidden"
                                    name="botami_excluded_urls"
                                    id="botami_excluded_urls_input"
                                    value="<?php echo esc_attr(get_option('botami_excluded_urls')); ?>" />
                                <table
                                    class="btm-w-full btm-text-sm btm-text-left rtl:btm-text-right btm-text-gray-500 dark:btm-text-gray-400">
                                    <tbody id="excluded_urls_list">
                                        <?php
                                        $excluded_urls = get_option('botami_excluded_urls', '');
                                        if (!empty($excluded_urls)) {
                                            $urls = explode('||', $excluded_urls);
                                            foreach ($urls as $url) {
                                                if (empty($url)) continue;
                                        ?>
                                                <tr
                                                    class="btm-bg-white btm-border-b dark:btm-bg-gray-800 dark:btm-border-gray-700 hover:btm-bg-gray-50 dark:hover:btm-bg-gray-600">
                                                    <th
                                                        scope="row"
                                                        class="btm-px-6 btm-py-4 btm-font-medium btm-text-gray-900 btm-whitespace-nowrap dark:btm-text-white">
                                                        <?php echo esc_html($url); ?>
                                                    </th>
                                                    <td class="btm-px-6 btm-py-4 btm-text-right">
                                                        <svg
                                                            xmlns="http://www.w3.org/2000/svg"
                                                            class="btm-h-8 btm-w-8 btm-text-green-500"
                                                            fill="none"
                                                            viewBox="0 0 24 24"
                                                            stroke="currentColor"
                                                            stroke-width="2">
                                                            <path
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                d="M5 13l4 4L19 7" />
                                                        </svg>
                                                    </td>
                                                    <td
                                                        class="btm-px-6 btm-py-4 btm-text-right btm-cursor-pointer delete-excluded-url"
                                                        data-url="<?php echo esc_attr($url); ?>">
                                                        <svg
                                                            xmlns="http://www.w3.org/2000/svg"
                                                            class="btm-h-6 btm-w-6 btm-text-gray-600 hover:btm-text-red-500 btm-transition btm-duration-300"
                                                            fill="none"
                                                            viewBox="0 0 24 24"
                                                            stroke="currentColor"
                                                            stroke-width="2">
                                                            <path
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6M10 4h4m-4 0a1 1 0 00-1 1v1h6V5a1 1 0 00-1-1m-4 0h4" />
                                                        </svg>
                                                    </td>
                                                </tr>
                                        <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Appearance Tab -->
                <div
                    class="tab-content btm-transition-opacity btm-duration-500 btm-opacity-0 btm-hidden"
                    id="appearance">
                    <div class="btm-bg-white btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6">
                        <h2 class="btm-text-2xl btm-font-bold btm-text-gray-800 btm-mb-4">
                            <?php botamichat_admin_e('admin.appearance_title'); ?>
                        </h2>
                        <?php
                            $logo_1_url = BOTAMI_PLUGIN_URL . 'assets/img/bot_logo_3.png';
                            $logo_2_url = BOTAMI_PLUGIN_URL . 'assets/img/bot_logo_2.png';
                            $logo_3_url = BOTAMI_PLUGIN_URL . 'assets/img/bot_image.jpeg';
                            $logo_4_url = BOTAMI_PLUGIN_URL . 'assets/img/IMG1_botami.png';
                            $logo_5_url = BOTAMI_PLUGIN_URL . 'assets/img/IMG2_botami.png';
                            $logo_6_url = BOTAMI_PLUGIN_URL . 'assets/img/IMG3_botami.png';
                            $logo_7_url = BOTAMI_PLUGIN_URL . 'assets/img/IMG4_botami.png';
                            $logo_8_url = BOTAMI_PLUGIN_URL . 'assets/img/IMG5_botami.png';
                            $logo_9_url = BOTAMI_PLUGIN_URL . 'assets/img/IMG6_botami.png';
                            $upload_placeholder_url = BOTAMI_PLUGIN_URL . 'assets/img/uplod-img.png';
                            $current_logo_url = get_option('botami_bot_image_url', $upload_placeholder_url);
                        ?>
                        <div class="btm-flex btm-flex-wrap btm--mx-2">
                            <!-- Colonne des paramètres -->
                            <div class="btm-w-full md:btm-w-1/2 btm-px-2">
                                <div class="btm-mb-4">
                                    <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.chatbot_logo'); ?></label>
                                    <input
                                        type="text"
                                        name="botami_bot_image_url"
                                        id="botami_bot_image_url"
                                        value="<?php echo esc_attr(get_option('botami_bot_image_url', $logo_1_url )); ?>"
                                        class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200" />
                                    <div class="btm-mt-4 btm-mb-6">
                                        <h3 class="btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.choose_logo'); ?></h3>
                                        <div class="btm-grid btm-grid-cols-4 md:btm-grid-cols-5 btm-gap-3">
                                            <!-- Logo 1 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_1_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_1_url),
                                                    esc_attr(botamichat_admin_text('admin.standard_robot'))
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php botamichat_admin_e('admin.standard_robot'); ?></p>
                                            </div>
                                            <!-- Logo 2 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_2_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_2_url),
                                                    esc_attr(botamichat_admin_text('admin.ai_assistant'))
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php botamichat_admin_e('admin.ai_assistant'); ?></p>
                                            </div>
                                            <!-- Logo 3 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr( $logo_3_url ); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_3_url),
                                                    esc_attr(botamichat_admin_text('admin.pro_support'))
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php botamichat_admin_e('admin.pro_support'); ?></p>
                                            </div>
                                            <!-- Logo 4 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_4_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_4_url),
                                                    esc_attr__('Logo 4', 'botami-chatbot')
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php echo esc_html__('Logo 4', 'botami-chatbot'); ?></p>
                                            </div>
                                            <!-- Logo 5 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_5_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_5_url),
                                                    esc_attr__('Logo 5', 'botami-chatbot')
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php echo esc_html__('Logo 5', 'botami-chatbot'); ?></p>
                                            </div>
                                            <!-- Logo 6 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_6_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_6_url),
                                                    esc_attr__('Logo 6', 'botami-chatbot')
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php echo esc_html__('Logo 6', 'botami-chatbot'); ?></p>
                                            </div>
                                            <!-- Logo 7 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_7_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_7_url),
                                                    esc_attr__('Logo 7', 'botami-chatbot')
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php echo esc_html__('Logo 7', 'botami-chatbot'); ?></p>
                                            </div>
                                            <!-- Logo 8 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_8_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_8_url),
                                                    esc_attr__('Logo 8', 'botami-chatbot')
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php echo esc_html__('Logo 8', 'botami-chatbot'); ?></p>
                                            </div>
                                            <!-- Logo 9 -->
                                            <div class="logo-template btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                                data-logo="<?php echo esc_attr($logo_9_url); ?>"
                                                style="cursor: pointer;">
                                                <?php echo wp_kses(sprintf(
                                                    '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                    esc_url($logo_9_url),
                                                    esc_attr__('Logo 9', 'botami-chatbot')
                                                ), array(
                                                    'img' => array(
                                                        'src' => array(),
                                                        'alt' => array(),
                                                        'class' => array()
                                                    )
                                                )); ?>
                                                <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php echo esc_html__('Logo 9', 'botami-chatbot'); ?></p>
                                            </div>
                                        </div>
                                        <div class="logo-template btm-mt-5 btm-cursor-pointer btm-transition-all btm-duration-300 btm-border-2 hover:btm-border-blue-500 btm-rounded-lg btm-p-2 hover:btm-shadow-md <?php echo (!$is_pro_or_higher) ? 'premium-component' : ''; ?>"
                                            data-logo="<?php echo  esc_attr(get_option('botami_bot_image_url', BOTAMI_PLUGIN_URL . 'assets/img/uplod-img.png' )); ?>"
                                            style="cursor: pointer;">
                                            <?php echo wp_kses(sprintf(
                                                '<img src="%s" alt="%s" class="btm-w-12 btm-h-12 btm-mx-auto btm-rounded-full btm-object-cover">',
                                                esc_url($current_logo_url),
                                                esc_attr(botamichat_admin_text('admin.custom_logo'))
                                            ), array(
                                                'img' => array(
                                                    'src' => array(),
                                                    'alt' => array(),
                                                    'class' => array()
                                                )
                                            )); ?>
                                            <p class="btm-text-center btm-mt-1 btm-text-xs btm-font-medium"><?php botamichat_admin_e('admin.custom_logo'); ?></p>
                                        </div>
                                    </div>
                                    <!-- Section d'upload de logo personnalisé -->
                                    <div class="btm-mt-4">
                                        <h3 class="btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.upload_logo'); ?></h3>
                                        <div class="btm-w-[400px] btm-mt-2 btm-relative btm-border-2 btm-border-gray-300 btm-border-dashed btm-rounded-lg btm-p-6 <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>" id="dropzone">
                                            <!-- WordPress Media Button -->
                                            <button
                                                type="button"
                                                id="upload-image-button"
                                                class="btm-w-full btm-h-full btm-bg-white btm-text-indigo-600 hover:btm-text-indigo-800 hover:btm-bg-gray-50 btm-transition-colors btm-font-medium btm-px-4 btm-py-2 btm-rounded-md <?php echo (!$is_pro_or_higher) ? 'btm-opacity-50 btm-cursor-not-allowed' : ''; ?>"
                                                <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?>>
                                                <div class="btm-text-center">
                                                    <img
                                                        class="btm-mx-auto btm-h-12 btm-w-12"
                                                        src="<?php echo esc_attr($upload_placeholder_url); ?>"
                                                        alt="Upload icon" />
                                                    <h3 class="btm-mt-2 btm-text-sm btm-font-medium btm-text-gray-900">
                                                        <span><?php botamichat_admin_e('admin.click_select'); ?></span>
                                                        <span class="btm-text-indigo-600"><?php botamichat_admin_e('admin.an_image'); ?></span>
                                                        <span><?php botamichat_admin_e('admin.from_media'); ?></span>
                                                    </h3>
                                                    <p class="btm-mt-1 btm-text-xs btm-text-gray-500">
                                                        <?php botamichat_admin_e('admin.upload_info'); ?>
                                                    </p>
                                                </div>
                                            </button>
                                            <!-- Hidden input to store image ID -->
                                            <input type="hidden" name="botami_bot_image_id" id="botami_bot_image_id" value="<?php echo esc_attr(get_option('botami_bot_image_id', '')); ?>" />
                                            <!-- Aperçu de l'image -->
                                            <?php echo wp_kses(sprintf(
                                                '<img src="" class="btm-mt-4 btm-mx-auto btm-max-h-40 btm-hidden btm-rounded-full btm-shadow-md btm-object-cover" id="preview" alt="%s" />',
                                                esc_attr__('Image Preview', 'botami-chatbot')
                                            ), array(
                                                'img' => array(
                                                    'src' => array(),
                                                    'class' => array(),
                                                    'id' => array(),
                                                    'alt' => array()
                                                )
                                            )); ?>
                                            <!-- Message d'erreur -->
                                            <p class="btm-mt-4 btm-text-red-500 btm-hidden" id="error-message">
                                                <?php botamichat_admin_e('admin.file_not_image'); ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="btm-flex btm-space-x-4">
                                    <div class="btm-mb-4 btm-w-1/2">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.primary_color'); ?></label>
                                        <div class="btm-flex btm-items-center btm-space-x-2">
                                            <input
                                                type="color"
                                                name="botami_primary_color"
                                                id="botami_primary_color"
                                                value="<?php echo esc_attr(get_option('botami_primary_color', '#31377B')); ?>"
                                                class="btm-w-12 btm-h-12 rounded-input-color btm-shadow-md btm-border btm-border-gray-300 btm-focus:outline-none <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>"
                                                <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                                            <input
                                                type="text"
                                                name="botami_primary_color_text"
                                                id="botami_primary_color_text"
                                                value="<?php echo esc_attr(get_option('botami_primary_color', '#673DE6')); ?>"
                                                class="btm-w-full fileImg btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>"
                                                <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                                        </div>
                                    </div>
                                    <div class="btm-mb-4 btm-w-1/2">
                                        <label class="btm-block btm-text-gray-700 btm-font-medium btm-mb-2"><?php botamichat_admin_e('admin.secondary_color'); ?></label>
                                        <div class="btm-flex btm-items-center btm-space-x-2">
                                            <input
                                                type="color"
                                                name="botami_secondary_color"
                                                id="botami_secondary_color"
                                                value="<?php echo esc_attr(get_option('botami_secondary_color', '#673de6')); ?>"
                                                class="btm-w-12 btm-h-12 rounded-input-color btm-shadow-md btm-border btm-border-gray-300 btm-focus:outline-none <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>"
                                                <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                                            <input
                                                type="text"
                                                name="botami_secondary_color_text"
                                                id="botami_secondary_color_text"
                                                value="<?php echo esc_attr(get_option('botami_secondary_color', '#673de6')); ?>"
                                                class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>"
                                                <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $preview_bot_image_url = get_option('botami_bot_image_url', $logo_1_url);
                            ?>
                            <!-- Colonne de prévisualisation -->
                            <div class="btm-w-full md:btm-w-1/2 btm-px-2">
                                <!-- Prévisualisation du chatbot -->
                                <div class="btm-w-full btm-max-w-md btm-mx-auto h-prevision btm-rounded-xl btm-overflow-hidden btm-shadow-lg">
                                    <!-- Partie contenant le chatbot prévisualisé -->
                                    <div id="chatbot-preview-container" class="btm-w-full">
                                        <!-- En-tête du chatbot -->
                                        <div id="chatbot-header" class="btm-p-4 text-white btm-flex btm-justify-between btm-items-center">
                                            <div class="btm-flex btm-items-center">
                                                <div id="bot-avatar" class="btm-w-8 btm-h-8 btm-rounded-full btm-bg-white btm-flex btm-items-center btm-justify-center btm-overflow-hidden btm-mr-3">
                                                    <?php echo wp_kses(sprintf(
                                                        '<img id="preview-bot-image" src="%s" alt="%s" class="btm-w-full btm-h-full btm-object-cover">',
                                                        esc_url($preview_bot_image_url),
                                                        esc_attr__('Bot', 'botami-chatbot')
                                                    ), array(
                                                        'img' => array(
                                                            'id' => array(),
                                                            'src' => array(),
                                                            'alt' => array(),
                                                            'class' => array()
                                                        )
                                                    )); ?>
                                                </div>
                                                <div>
                                                    <h4 id="preview-heading-text" class="btm-font-bold btm-text-sm btm-mb-0"><?php echo esc_attr(get_option('botami_heading_text', botamichat_admin_text('greeting'))); ?></h4>
                                                    <div class="btm-flex btm-items-center">
                                                        <span class="btm-w-2 btm-h-2 btm-bg-green-500 btm-rounded-full btm-inline-block btm-mr-2"></span>
                                                        <p id="preview-online-status" class="btm-text-xs btm-mb-0"><?php echo esc_attr(get_option('botami_online_status_text', botamichat_admin_text('online_status'))); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="btm-cursor-pointer">
                                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                                <line x1="6" y1="6" x2="18" y2="18"></line>
                                            </svg>
                                        </div>
                                        <!-- Zone de rechargement de conversation -->
                                        <div class="btm-text-center btm-py-2" id="refresh-section">
                                            <button id="preview-reload-button" class="btm-text-white btm-text-xs btm-px-4 preview-reload-button btm-py-1 btm-rounded"><?php echo esc_attr(get_option('botami_reload_text', botamichat_admin_text('admin.reload_text'))); ?></button>
                                        </div>
                                        <!-- Zone de messages -->
                                        <div id="chatbot-messages" class="btm-bg-gray-50 btm-p-4 h-prevision2 btm-overflow-y-auto btm-flex btm-flex-col">
                                            <!-- Message du bot -->
                                            <div class="btm-mb-3 btm-max-w-[80%] btm-bg-white btm-rounded-tr-xl btm-rounded-bl-xl btm-rounded-br-xl btm-shadow-sm btm-p-3 btm-text-gray-800 btm-text-sm btm-self-start">
                                                <span id="preview-default-message"><?php echo esc_attr(get_option('botami_default_message', botamichat_admin_text('first_message'))); ?></span>
                                            </div>
                                            <!-- Message de l'utilisateur -->
                                            <div id="bot-message-gradient" class="btm-mb-3 btm-max-w-[80%] text-white btm-rounded-tl-xl btm-rounded-tr-xl btm-rounded-bl-xl btm-shadow-sm btm-p-3 btm-text-sm btm-self-end">
                                                <?php echo esc_html(botamichat_admin_text('admin.chatbot_preview_desc')); ?>
                                            </div>
                                        </div>
                                        <!-- Input pour taper le message -->
                                        <div class="btm-border-t btm-border-gray-200 btm-bg-white btm-p-3 btm-flex btm-items-center">
                                            <button class="btm-text-gray-500 btm-mr-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <circle cx="12" cy="12" r="10"></circle>
                                                    <path d="M8 14s1.5 2 4 2 4-2 4-2"></path>
                                                    <line x1="9" y1="9" x2="9.01" y2="9"></line>
                                                    <line x1="15" y1="9" x2="15.01" y2="9"></line>
                                                </svg>
                                            </button>
                                            <input id="preview-placeholder" type="text" placeholder="<?php echo esc_attr(get_option('botami_placeholder_text', botamichat_admin_text('write_message'))); ?>" class="btm-flex-1 btm-border btm-border-gray-300 btm-rounded-lg btm-py-2 btm-px-3 btm-text-sm btm-focus:outline-none btm-focus:ring-2 btm-focus:ring-blue-300 btm-mr-2">
                                            <button disabled id="send-button" class="btm-text-white btm-rounded-lg btm-p-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white" width="20px" height="20px">
                                                    <path d="M2.01 21L23 12 2.01 3v7l15 2-15 2z" />
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Botami Configuration Tab -->
                <div class="tab-content btm-transition-opacity btm-duration-500" id="bot-config">
                    <div class="btm-bg-white btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6">
                        <h2 class="btm-text-2xl btm-font-bold btm-text-gray-800 btm-mb-4">
                            <?php botamichat_admin_e('admin.bot_config_title'); ?>
                        </h2>
                        <p class="btm-text-gray-600 btm-mb-4">
                            <?php botamichat_admin_e('admin.bot_config_desc'); ?>
                        </p>
                        <!-- Contexte -->
                        <div class="btm-bg-white btm-p-7 btm-rounded btm-w-9/12 btm-mx-auto btm-mb-6">
                            <div class="btm-relative btm-flex btm-flex-col btm-p-4 btm-text-gray-400 btm-border btm-border-gray-200 btm-rounded">
                                <label for="message" class="btm-block btm-mb-2 btm-text-sm btm-font-medium btm-text-gray-900 dark:btm-text-white"><?php botamichat_admin_e('admin.context'); ?></label>
                                <p class="btm-text-gray-600 btm-mb-3"><?php botamichat_admin_e('admin.context_desc'); ?></p>
                                <textarea
                                    id="message"
                                    rows="4"
                                    class="btm-block btm-p-2.5 btm-w-full btm-text-sm btm-text-gray-900 btm-bg-gray-50 btm-rounded-lg btm-border btm-border-gray-300
                           btm-focus:outline-none btm-focus:ring-0 dark:btm-bg-gray-700 dark:btm-border-gray-600
                           dark:btm-placeholder-gray-400 dark:btm-text-white"
                                    placeholder="<?php botamichat_admin_attr_e('admin.context_placeholder'); ?>"
                                    name="botami_knowledge_document"><?php echo esc_attr(get_option('botami_knowledge_document')); ?></textarea>
                                <div id="char-limit-feedback" class="btm-flex btm-justify-between btm-items-center btm-text-sm btm-text-gray-500 btm-mt-2">
                                </div>
                            </div>
                        </div>
                        <!-- URLs de connaissances -->
                        <div class="btm-bg-white btm-p-7 btm-rounded btm-w-9/12 btm-mx-auto btm-mb-6 <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>">
                            <div class="btm-relative btm-flex btm-flex-col btm-p-4 btm-text-gray-400 btm-border btm-border-gray-200 btm-rounded">
                                <label class="btm-block btm-mb-2 btm-text-sm btm-font-medium btm-text-gray-900 dark:btm-text-white"><?php botamichat_admin_e('admin.knowledge_urls'); ?></label>
                                <p class="btm-text-gray-600 btm-mb-3"><?php botamichat_admin_e('admin.knowledge_urls_desc'); ?></p>
                                <?php if ($is_pro_or_higher): ?>
                                    <div class="btm-w-full btm-mt-3 btm-mb-3" id="form_add_url">
                                        <div class="btm-flex btm-gap-2 btm-w-full">
                                            <input
                                                type="text"
                                                class="btm-flex-1 btm-bg-gray-50 btm-border btm-border-gray-300 btm-text-gray-900 btm-text-sm btm-rounded-lg btm-focus:ring-2 btm-focus:ring-blue-500 btm-focus:border-blue-500 btm-block btm-px-4 btm-py-2.5 btm-transition-all"
                                                id="knowledge_url_input"
                                                placeholder="exemple.com/faq" />
                                            <button
                                                id="add_url_submit"
                                                class="btn-botami btm-text-black btm-font-medium btm-px-6 btm-py-2.5 btm-rounded-lg btm-shadow-md btm-hover:shadow-lg btm-transition-all btm-whitespace-nowrap">
                                                <?php botamichat_admin_e('admin.add_url'); ?>
                                            </button>
                                        </div>
                                    </div>
                                    <div
                                        id="knowledge_urls_container"
                                        class="btm-relative btm-overflow-x-auto btm-shadow-md btm-sm:rounded-lg btm-mt-3 <?php echo empty(get_option('botami_knowledge_urls')) ? 'btm-hidden' : ''; ?>">
                                        <input
                                            type="hidden"
                                            name="botami_knowledge_urls"
                                            id="botami_knowledge_urls_input"
                                            value="<?php echo esc_attr(get_option('botami_knowledge_urls')); ?>" />
                                        <table class="btm-w-full btm-text-sm btm-text-left rtl:btm-text-right btm-text-gray-500 dark:btm-text-gray-400">
                                            <tbody id="knowledge_urls_list">
                                                <?php
                                                $knowledge_urls = get_option('botami_knowledge_urls', '');
                                                if (!empty($knowledge_urls)) {
                                                    $urls = explode('||', $knowledge_urls);
                                                    foreach ($urls as $url) {
                                                        if (empty($url)) continue;
                                                ?>
                                                        <tr class="btm-bg-white btm-border-b dark:btm-bg-gray-800 dark:btm-border-gray-700 hover:btm-bg-gray-50 dark:hover:btm-bg-gray-600">
                                                            <th scope="row" class="btm-px-6 btm-py-4 btm-font-medium btm-text-gray-900 btm-whitespace-nowrap dark:btm-text-white">
                                                                <?php echo esc_html($url); ?>
                                                            </th>
                                                            <td class="btm-px-6 btm-py-4 btm-text-right">
                                                                <svg
                                                                    xmlns="http://www.w3.org/2000/svg"
                                                                    class="btm-h-8 btm-w-8 btm-text-green-500"
                                                                    fill="none"
                                                                    viewBox="0 0 24 24"
                                                                    stroke="currentColor"
                                                                    stroke-width="2">
                                                                    <path
                                                                        stroke-linecap="round"
                                                                        stroke-linejoin="round"
                                                                        d="M5 13l4 4L19 7" />
                                                                </svg>
                                                            </td>
                                                            <td
                                                                class="btm-px-6 btm-py-4 btm-text-right btm-cursor-pointer delete-url"
                                                                data-url="<?php echo esc_attr($url); ?>">
                                                                <svg
                                                                    xmlns="http://www.w3.org/2000/svg"
                                                                    class="btm-h-6 btm-w-6 btm-text-gray-600 hover:btm-text-red-500 btm-transition btm-duration-300"
                                                                    fill="none"
                                                                    viewBox="0 0 24 24"
                                                                    stroke="currentColor"
                                                                    stroke-width="2">
                                                                    <path
                                                                        stroke-linecap="round"
                                                                        stroke-linejoin="round"
                                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                                </svg>
                                                            </td>
                                                        </tr>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="btm-bg-gray-50 btm-p-4 btm-rounded-lg btm-text-center">
                                        <p class="btm-text-gray-600"><?php botamichat_admin_e('admin.premium_feature'); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- Importation de fichiers -->
                        <div class="btm-bg-white btm-p-7 btm-mt-5 btm-rounded btm-w-9/12 btm-mx-auto <?php echo (!$is_pro_or_higher) ? 'pro-badge premium-component' : ''; ?>" id="file_component_div">
                            <div class="btm-relative btm-flex btm-flex-col btm-p-4 btm-text-gray-400 btm-border btm-border-gray-200 btm-rounded">
                                <label class="btm-block btm-mb-2 btm-text-sm btm-font-medium btm-text-gray-900 dark:btm-text-white"><?php botamichat_admin_e('admin.file_import'); ?></label>
                                <p class="btm-text-gray-600 btm-mb-3"><?php botamichat_admin_e('admin.file_import_desc'); ?></p>
                                <div x-data="dataFileDnD()" class="btm-relative">
                                    <div x-ref="dnd"
                                        class="btm-relative btm-flex btm-flex-col btm-text-gray-400 btm-border btm-border-gray-200 btm-border-dashed btm-rounded btm-cursor-pointer btm-p-4">
                                        <input type="file"
                                            class="btm-absolute filePdf btm-inset-0 btm-z-50 btm-w-full btm-h-full btm-p-0 btm-m-0 btm-outline-none btm-opacity-0 btm-cursor-pointer"
                                            @change="addFiles($event)"
                                            @dragover="$refs.dnd.classList.add('btm-border-blue-400', 'btm-ring-4', 'btm-ring-inset');"
                                            @dragleave="$refs.dnd.classList.remove('btm-border-blue-400', 'btm-ring-4', 'btm-ring-inset');"
                                            @drop="$refs.dnd.classList.remove('btm-border-blue-400', 'btm-ring-4', 'btm-ring-inset');"
                                            title="" <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                                        <div class="btm-flex btm-flex-col btm-items-center btm-justify-center btm-py-10 btm-text-center">
                                            <svg class="btm-w-6 btm-h-6 btm-mr-1 btm-text-current-50" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                            <p class="btm-m-0"><?php botamichat_admin_e('admin.file_import_drag'); ?></p>
                                            <p class="btm-text-xs btm-text-gray-500 btm-mt-1"><?php botamichat_admin_e('admin.file_import_info'); ?></p>
                                        </div>
                                    </div>
                                    <template x-if="files.length > 0">
                                        <div class="btm-grid btm-grid-cols-2 btm-gap-4 btm-mt-4 md:btm-grid-cols-6" @drop.prevent="drop($event)"
                                            @dragover.prevent="$event.dataTransfer.dropEffect = 'move'">
                                            <template x-for="(_, index) in Array.from({ length: files.length })">
                                                <div class="btm-relative btm-flex btm-flex-col btm-items-center btm-overflow-hidden btm-text-center btm-bg-gray-100 btm-border btm-rounded btm-cursor-move btm-select-none"
                                                    style="padding-top: 100%;" @dragstart="dragstart($event)"
                                                    @dragend="fileDragging = null"
                                                    :class="{'btm-border-blue-600': fileDragging == index}" draggable="true"
                                                    :data-index="index">
                                                    <button
                                                        class="btm-absolute btm-top-0 btm-right-0 btm-z-50 btm-p-1 btm-bg-white btm-rounded-bl btm-focus:outline-none"
                                                        type="button" @click="remove(index)">
                                                        <svg class="btm-w-4 btm-h-4 btm-text-gray-700" xmlns="http://www.w3.org/2000/svg"
                                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                        </svg>
                                                    </button>
                                                    <template x-if="files[index].type.includes('audio/')">
                                                        <svg class="btm-absolute btm-w-12 btm-h-12 btm-text-gray-400 btm-transform btm-top-1/2 btm--translate-y-2/3"
                                                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                            stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3" />
                                                        </svg>
                                                    </template>
                                                    <template
                                                        x-if="files[index].type.includes('application/') || files[index].type === ''">
                                                        <svg class="btm-absolute btm-w-12 btm-h-12 btm-text-gray-400 btm-transform btm-top-1/2 btm--translate-y-2/3"
                                                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                            stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                                        </svg>
                                                    </template>
                                                    <template x-if="files[index].type.includes('image/')">
                                                        <img class="btm-absolute btm-inset-0 btm-z-0 btm-object-cover btm-w-full btm-h-full btm-border-4 btm-border-white preview"
                                                            x-bind:src="loadFile(files[index])" />
                                                    </template>
                                                    <template x-if="files[index].type.includes('video/')">
                                                        <video
                                                            class="btm-absolute btm-inset-0 btm-object-cover btm-w-full btm-h-full btm-border-4 btm-border-white btm-pointer-events-none preview">
                                                            <fileDragging x-bind:src="loadFile(files[index])" type="video/mp4">
                                                        </video>
                                                    </template>
                                                    <div
                                                        class="btm-absolute btm-bottom-0 btm-left-0 btm-right-0 btm-flex btm-flex-col btm-p-2 btm-text-xs btm-bg-white btm-bg-opacity-50">
                                                        <span class="btm-w-full btm-font-bold btm-text-gray-900 btm-truncate"
                                                            x-text="files[index].name">Loading</span>
                                                        <span class="btm-text-xs btm-text-gray-900"
                                                            x-text="humanFileSize(files[index].size)">...</span>
                                                    </div>
                                                    <div class="btm-absolute btm-inset-0 btm-z-40 btm-transition-colors btm-duration-300"
                                                        @dragenter="dragenter($event)" @dragleave="fileDropping = null"
                                                        :class="{'btm-bg-blue-200 btm-bg-opacity-80': fileDropping == index && fileDragging != index}">
                                                    </div>
                                                </div>
                                            </template>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>
                        <div id="knowledge-files-container" class="btm-bg-white btm-p-7 btm-mt-5 btm-rounded btm-w-9/12 btm-mx-auto btm-border btm-border-gray-200 btm-rounded <?php echo empty(get_option('botami_knowledge_file', '')) ? 'btm-hidden' : ''; ?>">
                            <h4 class="btm-text-md btm-font-medium btm-text-gray-800 btm-mb-3"><?php botamichat_admin_e('admin.uploaded_knowledge_file'); ?></h4>
                            <ul id="knowledge-files-list" class="btm-space-y-2">
                                <?php
                                $file_info = get_option('botami_knowledge_file', '');
                                if (!empty($file_info)) {
                                    $file = json_decode($file_info, true);
                                    if ($file && isset($file['filename'])) {
                                        $icon_html = '';
                                        $file_type = $file['type'] ?? '';
                                        if (strpos($file_type, 'pdf') !== false) {
                                            $icon_html = '<svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-red-500" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd" /></svg>';
                                        } elseif (strpos($file_type, 'word') !== false || strpos($file_type, 'docx') !== false) {
                                            $icon_html = '<svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-blue-500" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd" /></svg>';
                                        } elseif (strpos($file_type, 'excel') !== false || strpos($file_type, 'spreadsheet') !== false || strpos($file_type, 'xls') !== false) {
                                            $icon_html = '<svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-green-500" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M5 4a3 3 0 00-3 3v6a3 3 0 003 3h10a3 3 0 003-3V7a3 3 0 00-3-3H5zm-1 9v-1h5v2H5a1 1 0 01-1-1zm7 1h4a1 1 0 001-1v-1h-5v2zm0-4h5V8h-5v2zM9 8H4v2h5V8z" clip-rule="evenodd" /></svg>';
                                        } elseif (strpos($file_type, 'csv') !== false) {
                                            $icon_html = '<svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-yellow-500" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd" /></svg>';
                                        } else {
                                            $icon_html = '<svg xmlns="http://www.w3.org/2000/svg" class="btm-h-8 btm-w-8 btm-text-gray-500" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4z" clip-rule="evenodd" /></svg>';
                                        }
                                        $file_size = isset($file['size']) ? $file['size'] : 0;
                                        $formatted_size = $this->format_file_size($file_size);
                                        $uploaded_at = isset($file['uploaded_at']) ? $file['uploaded_at'] : current_time('mysql');
                                        $formatted_date = date_i18n(get_option('date_format'), strtotime($uploaded_at));
                                        echo '<li class="file-item btm-flex btm-items-center btm-justify-between btm-p-2 btm-bg-gray-50 btm-rounded btm-border btm-border-gray-200 hover:btm-bg-gray-100 btm-transition-colors">';
                                        echo '<div class="btm-flex btm-items-center">';
                                        echo '<div class="file-icon btm-mr-3">' . wp_kses_post($icon_html) . '</div>';
                                        echo '<div class="file-info">';
                                        echo '<div class="file-name btm-text-sm btm-font-medium btm-text-gray-700">' . esc_html($file['filename']) . '</div>';
                                        echo '<div class="btm-text-xs btm-text-gray-500">' . esc_html($formatted_size) . ' • ' . esc_html($formatted_date) . '</div>';
                                        echo '</div>';
                                        echo '</div>';
                                        echo '<button type="button" id="delete-knowledge-file" class="btm-text-gray-400 hover:btm-text-red-500 btm-transition-colors">';
                                        echo '<svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5" viewBox="0 0 20 20" fill="currentColor">';
                                        echo '<path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />';
                                        echo '</svg>';
                                        echo '</button>';
                                        echo '</li>';
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Quick Replies Tab Content -->
                <div class="tab-content btm-transition-opacity btm-duration-500 btm-opacity-0 btm-hidden" id="bot-quick-replies">
                    <div class="btm-bg-white btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6">
                        <!-- Section 1: Quick Replies with Enhanced Branching -->
                        <div class="btm-mb-8 btm-border-b btm-pb-8">
                            <div class="btm-flex btm-items-center btm-mb-4">
                                <div class="btm-bg-blue-100 btm-p-2 btm-rounded-full btm-mr-3">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-text-blue-600">
                                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 012-2h14a2 2 0 012 2z"></path>
                                    </svg>
                                </div>
                                <h2 class="btm-text-2xl btm-font-bold btm-text-gray-800"><?php botamichat_admin_e('admin.quick_replies_title'); ?></h2>
                            </div>
                            <div class="btm-bg-blue-50 btm-p-4 btm-rounded-lg btm-mb-6 btm-border-l-4 btm-border-blue-400">
                                <div class="btm-flex">
                                    <div class="btm-flex-shrink-0">
                                        <svg class="btm-h-5 btm-w-5 btm-text-blue-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div class="btm-ml-3">
                                    <h3 class="btm-text-sm btm-font-medium btm-text-blue-800"><?php botamichat_admin_e('admin.questionnaire_branching_subtitle'); ?></h3>
                                        <div class="btm-mt-2 btm-text-sm btm-text-blue-700">
                                            <p><?php botamichat_admin_e('admin.questionnaire_branching_desc'); ?></p>
                                            <ul class="btm-list-disc btm-list-inside btm-mt-2 btm-space-y-1">
                                                <li><?php botamichat_admin_e('admin.questionnaire_branching_feature_1'); ?></li>
                                                <li><?php botamichat_admin_e('admin.questionnaire_branching_feature_2'); ?></li>
                                                <li><?php botamichat_admin_e('admin.questionnaire_branching_feature_3'); ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <p class="btm-text-gray-600 btm-mb-6"><?php botamichat_admin_e('admin.questionnaire_main_desc'); ?></p>
                            <!-- Enhanced Interface for adding questionnaire questions -->
                            <div class="btm-bg-gray-50 btm-p-5 btm-rounded-lg btm-border btm-border-gray-200 btm-mb-6">
                                <div class="btm-flex btm-flex-col md:btm-flex-row btm-gap-3 btm-mb-4">
                                    <input
                                        type="text"
                                        id="quick_reply_input"
                                        class="btm-flex-1 btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>"
                                        placeholder="<?php botamichat_admin_attr_e('admin.questionnaire_input_placeholder'); ?>"
                                        <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                    <button
                                        id="add_quick_reply_btn"
                                        class="md:btm-w-auto btm-w-full btn-botami text-black btm-px-4 btm-py-2 btm-rounded-md btm-transition btm-duration-300 btm-flex btm-items-center btm-justify-center <?php echo (!$is_premium) ? 'premium-badge premium-component' : ''; ?>"
                                        <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-inline btm-mr-2">
                                            <path d="M12 5v14M5 12h14" />
                                        </svg>
                                        <?php botamichat_admin_e('admin.add_reply'); ?>
                                    </button>
                                </div>
                                <div class="btm-flex btm-justify-between btm-items-center btm-mb-2">
                                    <div class="btm-flex btm-items-center btm-gap-4">
                                        <span class="btm-text-sm btm-text-gray-600">
                                        <span id="items-count">0</span> <?php botamichat_admin_e('admin.questions_created'); ?>
                                        </span>
                                    </div>
                                    <button id="clear-all" class="btm-text-red-600 btm-text-sm btm-flex btm-items-center hover:btm-underline">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-mr-1">
                                            <path d="M3 6h18M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                        </svg>
                                        <?php botamichat_admin_e('admin.clear_all'); ?>
                                    </button>
                                </div>
                                <!-- Input caché pour stocker l'ordre -->
                                <input type="hidden" name="botami_quick_replies" id="quick_replies_order" value="<?php echo esc_attr(get_option('botami_quick_replies', '[]')); ?>">
                                <!-- État vide avec illustration améliorée -->
                                <div class="empty-state btm-flex btm-flex-col btm-items-center btm-justify-center btm-py-12" id="empty-state">
                                    <div class="btm-bg-gray-100 btm-rounded-full btm-p-6 btm-mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" class="btm-text-gray-400">
                                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 012-2h14a2 2 0 012 2z"></path>
                                        </svg>
                                    </div>
                                    <p class="btm-text-gray-500 btm-font-medium"><?php botamichat_admin_e('admin.no_replies'); ?></p>
                                    <p class="btm-text-gray-400 btm-text-sm btm-mt-1"><?php botamichat_admin_e('admin.add_first'); ?></p>
                                </div>
                                <!-- Conteneur pour les éléments triables -->
                                <div class="quick-replies-container btm-mt-4 <?php echo (!$is_premium) ? 'premium-component btm-opacity-50' : ''; ?>">
                                    <!-- Les éléments de réponse rapide seront ajoutés ici dynamiquement -->
                                </div>
                            </div>
                            <!-- Help section for branching logic -->
                            <div class="btm-bg-white btm-border btm-border-gray-200 btm-rounded-lg btm-p-4 btm-mb-6">
                                <h3 class="btm-font-medium btm-text-gray-800 btm-mb-3 btm-flex btm-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-mr-2 btm-text-blue-500">
                                        <circle cx="12" cy="12" r="10"/>
                                        <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/>
                                        <path d="M12 17h.01"/>
                                    </svg>
                                    <?php botamichat_admin_e('admin.questionnaire_help_title'); ?>
                                </h3>
                                <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-4 btm-text-sm btm-text-gray-600">
                                    <div>
                                    <h4 class="btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.questionnaire_help_creating_title'); ?></h4>
                                        <ul class="btm-space-y-1 btm-list-disc btm-list-inside">
                                            <li><?php botamichat_admin_e('admin.questionnaire_help_creating_1'); ?></li>
                                            <li><?php botamichat_admin_e('admin.questionnaire_help_creating_2'); ?></li>
                                            <li><?php botamichat_admin_e('admin.questionnaire_help_creating_3'); ?></li>
                                        </ul>
                                    </div>
                                    <div>
                                        <h4 class="btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.questionnaire_help_branching_title'); ?></h4>
                                        <ul class="btm-space-y-1 btm-list-disc btm-list-inside">
                                            <li><?php botamichat_admin_e('admin.questionnaire_help_branching_1'); ?></li>
                                            <li><?php botamichat_admin_e('admin.questionnaire_help_branching_2'); ?></li>
                                            <li><?php botamichat_admin_e('admin.questionnaire_help_branching_3'); ?></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="btm-mt-4 btm-p-3 btm-bg-blue-50 btm-rounded btm-border-l-4 btm-border-blue-300">
                                    <p class="btm-text-sm btm-text-blue-700">
                                    <strong><?php botamichat_admin_e('admin.questionnaire_example_label'); ?></strong> <?php botamichat_admin_e('admin.questionnaire_example_text'); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- Section 2: Lead Generation -->
                        <div>
                            <div class="btm-flex btm-items-center btm-justify-between btm-mb-4">
                                <div class="btm-flex btm-items-center">
                                    <div class="btm-bg-green-100 btm-p-2 btm-rounded-full btm-mr-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-text-green-600">
                                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                            <circle cx="9" cy="7" r="4"></circle>
                                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                            <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                        </svg>
                                    </div>
                                    <h2 class="btm-text-2xl btm-font-bold btm-text-gray-800"><?php botamichat_admin_e('admin.lead_generation'); ?></h2>
                                </div>
                                <div>
                                    <button id="leadExportButton"
                                        class="btn-botami text-black btm-px-4 btm-py-2 btm-rounded-lg btm-shadow-md btm-flex btm-items-center <?php echo (!$is_premium) ? ' premium-badge premium-component' : ''; ?>"
                                        <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-mr-2">
                                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 01-2-2v-4"></path>
                                            <polyline points="7 10 12 15 17 10"></polyline>
                                            <line x1="12" y1="15" x2="12" y2="3"></line>
                                        </svg>
                                        <?php botamichat_admin_e('admin.lead_export'); ?>
                                    </button>
                                </div>
                            </div>
                            <p class="btm-text-gray-600 btm-mb-6">
                            <?php botamichat_admin_e('admin.lead_gen_questionnaire_desc'); ?>
                            </p>
                            <div class="btm-flex btm-items-center btm-mb-6 btm-bg-gray-50 btm-p-4 btm-rounded-lg btm-border btm-border-gray-200">
                                <input type="hidden" name="botami_lead_gen_enabled" value="0">
                                <div class="btm-flex btm-items-center btm-h-5">
                                    <input id="chatbot-lead-gen-enabled" name="botami_lead_gen_enabled" <?php checked(get_option('botami_lead_gen_enabled', '0'), '1'); ?> type="checkbox" value="1" class="btm-w-5 btm-h-5 btm-text-blue-600 btm-bg-gray-100 btm-border-gray-300 btm-rounded-md btm-focus:ring-blue-500 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                </div>
                                <div class="btm-ml-3 btm-text-sm">
                                    <label for="chatbot-lead-gen-enabled" class="btm-font-medium btm-text-gray-900"><?php botamichat_admin_e('admin.enable_lead_gen'); ?></label>
                                    <p class="btm-text-gray-500"><?php botamichat_admin_e('admin.lead_gen_enabled'); ?></p>
                                </div>
                            </div>
                            <!-- Enhanced Trigger Section -->
                            <div class="btm-mb-6 btm-bg-white btm-border btm-border-gray-200 btm-rounded-lg btm-p-4">
                                <h3 class="btm-font-medium btm-text-gray-800 btm-mb-3"><?php botamichat_admin_e('admin.when_display'); ?></h3>

                                <div class="btm-bg-amber-50 btm-p-3 btm-rounded-lg btm-mb-4 btm-border-l-4 btm-border-amber-400">
                                    <div class="btm-flex">
                                        <div class="btm-flex-shrink-0">
                                            <svg class="btm-h-5 btm-w-5 btm-text-amber-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="btm-ml-3">
                                            <h4 class="btm-text-sm btm-font-medium btm-text-amber-800"><?php botamichat_admin_e('admin.lead_form_triggering_title'); ?></h4>
                                            <p class="btm-text-sm btm-text-amber-700 btm-mt-1"><?php botamichat_admin_e('admin.lead_form_triggering_desc'); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-4">
                                    <div>
                                        <label for="botami_lead_gen_quick_reply" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2">
                                            <?php botamichat_admin_e('admin.after_reply'); ?>
                                        </label>
                                        <select name="botami_lead_gen_quick_reply" id="botami_lead_gen_quick_reply" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                            <option value=""><?php botamichat_admin_e('admin.no_specific_reply'); ?></option>
                                            <?php
                                            $quick_replies = get_option('botami_quick_replies', '[]');
                                            $replies = json_decode($quick_replies, true);
                                            $selected_quick_reply = get_option('botami_lead_gen_quick_reply', '');
                                            if (is_array($replies)) {
                                                foreach ($replies as $reply) {
                                                    if (isset($reply['id']) && isset($reply['text'])) {
                                                        $id = $reply['id'];
                                                        $text = $reply['text'];
                                                        $selected = ($selected_quick_reply === $id) ? 'selected' : '';
                                                        echo "<option value=\"" . esc_attr($id) . "\" " . esc_attr($selected) . ">" . esc_html($text) . "</option>";
                                                    }
                                                }
                                            }
                                            ?>
                                        </select>
                                        <p class="btm-text-xs btm-text-gray-500 btm-mt-1"><?php botamichat_admin_e('admin.lead_form_question_selection_desc'); ?></p>
                                    </div>
                                    <div class="btm-bg-blue-50 btm-p-3 btm-rounded-lg btm-flex">
                                        <div class="btm-flex-shrink-0 btm-mt-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="btm-h-5 btm-w-5 btm-text-blue-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div class="btm-ml-3">
                                            <p class="btm-text-sm btm-text-blue-700">
                                                <strong><?php botamichat_admin_e('admin.smart_end_node_detection_title'); ?></strong> <?php botamichat_admin_e('admin.smart_end_node_detection_desc'); ?>
                                            </p>
                                            <p class="btm-text-xs btm-text-blue-600 btm-mt-2"><?php botamichat_admin_e('admin.smart_end_node_detection_note'); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Form Customization Section -->
                            <div class="btm-mb-6">
                                <h3 class="btm-font-medium btm-text-gray-800 btm-mb-4"><?php botamichat_admin_e('admin.customize_form'); ?></h3>
                                <div class="btm-grid btm-grid-cols-1 btm-gap-5">
                                    <!-- Message d'introduction -->
                                    <div class="btm-bg-gray-50 btm-p-4 btm-rounded-lg">
                                        <label for="botami_lead_gen_intro_message" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.intro_message'); ?></label>
                                        <textarea name="botami_lead_gen_intro_message" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" rows="2" <?php echo (!$is_premium) ? 'disabled' : ''; ?>><?php echo esc_attr(get_option('botami_lead_gen_intro_message', botamichat_admin_text('admin.lead_gen_intro_message'))); ?></textarea>
                                        <p class="btm-text-xs btm-text-gray-500 btm-mt-1"><?php botamichat_admin_e('admin.intro_message_desc'); ?></p>
                                    </div>
                                    <!-- Champs du formulaire -->
                                    <div class="btm-bg-white btm-border btm-border-gray-200 btm-rounded-lg btm-overflow-hidden">
                                        <div class="btm-bg-gray-100 btm-px-4 btm-py-2 btm-border-b">
                                            <h4 class="btm-font-medium btm-text-gray-700"><?php botamichat_admin_e('admin.form_fields'); ?></h4>
                                        </div>
                                        <div class="btm-p-4">
                                            <!-- Champ 1 -->
                                            <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-4 btm-mb-4 btm-pb-4 btm-border-b btm-border-gray-100">
                                                <div>
                                                    <label for="botami_lead_gen_name_placeholder" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.field_placeholder'); ?></label>
                                                    <input type="text" name="botami_lead_gen_name_placeholder" value="<?php echo esc_attr(get_option('botami_lead_gen_name_placeholder', botamichat_admin_text('admin.field_placeholder'))); ?>" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                                </div>
                                            </div>
                                            <!-- Champ 2 -->
                                            <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-4 btm-mb-4 btm-pb-4 btm-border-b btm-border-gray-100">
                                                <div>
                                                    <label for="botami_lead_gen_email_placeholder" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.field2_placeholder'); ?></label>
                                                    <input type="text" name="botami_lead_gen_email_placeholder" value="<?php echo esc_attr(get_option('botami_lead_gen_email_placeholder', botamichat_admin_text('admin.field2_placeholder'))); ?>" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                                </div>
                                            </div>
                                            <!-- Champ 3 -->
                                            <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-4 btm-mb-4">
                                                <div>
                                                    <label for="botami_lead_gen_field_placeholder" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.field3_placeholder'); ?></label>
                                                    <input type="text" name="botami_lead_gen_field_placeholder" value="<?php echo esc_attr(get_option('botami_lead_gen_field_placeholder', botamichat_admin_text('admin.field3_placeholder'))); ?>" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Messages et bouton -->
                                    <div class="btm-grid btm-grid-cols-1 md:btm-grid-cols-2 btm-gap-5">
                                        <div class="btm-bg-gray-50 btm-p-4 btm-rounded-lg">
                                            <label for="botami_lead_gen_consentment" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.consent_message'); ?></label>
                                            <textarea name="botami_lead_gen_consentment" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" rows="2" <?php echo (!$is_premium) ? 'disabled' : ''; ?>><?php echo esc_attr(get_option('botami_lead_gen_consentment', botamichat_admin_text('admin.consent_message'))); ?></textarea>
                                            <p class="btm-text-xs btm-text-gray-500 btm-mt-1"><?php botamichat_admin_e('admin.consent_message_desc'); ?></p>
                                        </div>
                                        <div class="btm-bg-gray-50 btm-p-4 btm-rounded-lg">
                                            <label for="botami_lead_gen_button_text" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.submit_button'); ?></label>
                                            <input type="text" name="botami_lead_gen_button_text" value="<?php echo esc_attr(get_option('botami_lead_gen_button_text', botamichat_admin_text('admin.submit_button'))); ?>" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                        </div>
                                    </div>
                                    <!-- Consent Toggle -->
                                    <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg btm-mb-6">
                                        <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-2"><?php botamichat_admin_e('admin.consent_toggle_desc'); ?></h3>
                                        <p class="btm-text-gray-600 btm-mb-3"><?php botamichat_admin_e('admin.consent_toggle_message'); ?></p>
                                        <div class="btm-flex btm-items-center btm-mb-2">
                                            <label class="toggle-switch">
                                                <input type="hidden" name="botami_lead_consent_is_active" value="0">
                                                <input type="checkbox" id="consent-active-toggle" name="botami_lead_consent_is_active" value="1" <?php checked(get_option('botami_lead_consent_is_active', '1'), '1'); ?> class="<?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                                <span class="toggle-slider"></span>
                                            </label>
                                            <span class="btm-ml-3 btm-text-sm btm-font-medium btm-text-gray-900"><?php botamichat_admin_e('admin.consent_toggle'); ?></span>
                                        </div>
                                    </div>
                                    <!-- Message de remerciement -->
                                    <div class="btm-bg-gray-50 btm-p-4 btm-rounded-lg">
                                        <label for="botami_lead_gen_thank_you" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2"><?php botamichat_admin_e('admin.thank_you_message'); ?></label>
                                        <input type="text" name="botami_lead_gen_thank_you" value="<?php echo esc_attr(get_option('botami_lead_gen_thank_you', botamichat_admin_text('admin.thank_you_message'))); ?>" class="btm-w-full btm-p-3 btm-border btm-border-gray-300 btm-rounded-md btm-focus:outline-none btm-focus:ring btm-focus:ring-blue-200 <?php echo (!$is_premium) ? 'premium-component' : ''; ?>" <?php echo (!$is_premium) ? 'disabled' : ''; ?>>
                                        <p class="btm-text-xs btm-text-gray-500 btm-mt-1"><?php botamichat_admin_e('admin.thank_you_desc'); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="btm-mb-6">
                                <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4">
                                    <?php botamichat_admin_e('admin.lead_email_notifications_title'); ?>
                                </h3>

                                <div class="btm-bg-white btm-p-4 btm-border btm-border-gray-200 btm-rounded-lg">
                                    <!-- Email Notifications Enable/Disable -->
                                    <div class="btm-mb-4">
                                        <input type="hidden" name="botami_lead_email_enabled" value="0">
                                        <label class="btm-flex btm-items-center">
                                            <input
                                                type="checkbox"
                                                name="botami_lead_email_enabled"
                                                value="1"
                                                <?php checked(get_option('botami_lead_email_enabled', '1'), '1'); ?>
                                                class="btm-mr-2 btm-rounded <?php echo (!$is_premium) ? 'premium-component' : ''; ?>"
                                                <?php echo (!$is_premium) ? 'disabled' : ''; ?>
                                            />
                                            <span class="btm-text-gray-700 btm-font-medium">
                                                <?php botamichat_admin_e('admin.enable_lead_email_notifications'); ?>
                                            </span>
                                        </label>
                                        <p class="btm-text-gray-500 btm-text-sm btm-mt-1">
                                            <?php botamichat_admin_e('admin.lead_email_admin_desc', ['admin_email' => get_option('admin_email')]); ?>
                                        </p>
                                    </div>

                                    <!-- Current Admin Email Display -->
                                    <div class="btm-bg-blue-50 btm-p-3 btm-rounded-md">
                                        <p class="btm-text-sm btm-text-blue-800">
                                            <strong><?php botamichat_admin_e('admin.current_email_address'); ?></strong>
                                            <?php echo esc_html(get_option('admin_email')); ?>
                                        </p>
                                        <p class="btm-text-xs btm-text-blue-600 btm-mt-1">
                                            <?php botamichat_admin_e('admin.change_email_instructions'); ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <!-- Enhanced Form Preview -->
                            <div class="btm-bg-gray-100 btm-p-4 btm-rounded-lg">
                                <h3 class="btm-font-medium btm-text-gray-700 btm-mb-3"><?php botamichat_admin_e('admin.form_preview'); ?></h3>
                                <div class="btm-bg-white btm-p-4 btm-rounded-lg btm-shadow-sm" style="max-width: 350px;">
                                    <p class="btm-text-gray-700 btm-mb-3"><?php echo esc_html(get_option('botami_lead_gen_intro_message', botamichat_admin_text('admin.lead_gen_intro_message'))); ?></p>
                                    <div class="btm-space-y-3 btm-mb-3">
                                        <input type="text" placeholder="<?php echo esc_attr(get_option('botami_lead_gen_name_placeholder', botamichat_admin_text('admin.field_placeholder'))); ?>" class="btm-w-full btm-p-2 btm-border btm-border-gray-300 btm-rounded btm-text-sm" disabled>
                                        <input type="text" placeholder="<?php echo esc_attr(get_option('botami_lead_gen_email_placeholder', botamichat_admin_text('admin.field2_placeholder'))); ?>" class="btm-w-full btm-p-2 btm-border btm-border-gray-300 btm-rounded btm-text-sm" disabled>
                                        <input type="text" placeholder="<?php echo esc_attr(get_option('botami_lead_gen_field_placeholder', botamichat_admin_text('admin.field3_placeholder'))); ?>" class="btm-w-full btm-p-2 btm-border btm-border-gray-300 btm-rounded btm-text-sm" disabled>
                                    </div>
                                    <div class="btm-flex btm-items-start btm-mb-3">
                                        <input type="checkbox" class="btm-mt-1 btm-mr-2" disabled>
                                        <p class="btm-text-xs btm-text-gray-600"><?php echo esc_html(get_option('botami_lead_gen_consentment', botamichat_admin_text('admin.consent_message'))); ?></p>
                                    </div>
                                    <button class="btm-w-full btm-py-2 btm-px-4 btm-bg-gray-300 btm-text-gray-700 btm-rounded btm-text-sm btm-font-medium" disabled>
                                        <?php echo esc_html(get_option('botami_lead_gen_button_text', botamichat_admin_text('admin.submit_button'))); ?>
                                    </button>
                                </div>
                                <p class="btm-text-sm btm-text-gray-500 btm-mt-2"><?php botamichat_admin_e('admin.form_preview_desc'); ?> <?php botamichat_admin_e('admin.form_preview_enhanced_desc'); ?></p>
                            </div>
                            <!-- Message d'alerte pour l'export -->
                            <div class="btm-p-4 btm-mt-4 btm-text-sm btm-text-red-800 btm-rounded-lg btm-bg-red-50 dark:btm-bg-gray-800 dark:btm-text-red-400 btm-hidden" id="lead-export-alert" role="alert"></div>
                        </div>
                    </div>
                </div>
                <div
                    class="tab-content btm-transition-opacity btm-duration-500 btm-opacity-0 btm-hidden"
                    id="bot-export">
                    <div class="btm-bg-white btm-h-full btm-shadow-md btm-rounded-lg btm-p-6 btm-mb-6">
                        <h3 class="btm-text-lg btm-font-semibold btm-text-gray-800 btm-mb-4 btm-flex btm-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="btm-mr-2 btm-text-blue-500">
                                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                                <polyline points="7 10 12 15 17 10"></polyline>
                                <line x1="12" y1="15" x2="12" y2="3"></line>
                            </svg>
                            <?php botamichat_admin_e('admin.export_title'); ?>
                        </h3>
                        <div
                            id="date-range-picker"
                            class="btm-flex btm-items-end btm-gap-3">
                            <div class="btm-flex-1">
                                <label for="datepicker-range-start" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2">
                                    <?php botamichat_admin_e('admin.select_start'); ?>
                                </label>
                                <input
                                    id="datepicker-range-start"
                                    name="start"
                                    type="date"
                                    class="btm-bg-gray-50 btm-border btm-border-gray-300 btm-text-gray-900 btm-text-sm btm-rounded-lg btm-focus:ring-2 btm-focus:ring-blue-500 btm-focus:border-blue-500 btm-block btm-w-full btm-px-4 btm-py-2.5 btm-transition-all <?php echo (!$is_pro_or_higher) ? 'pro-badge pro-component' : ''; ?>"
                                    <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                            </div>
                            <div class="btm-flex-1">
                                <label for="datepicker-range-end" class="btm-block btm-text-sm btm-font-medium btm-text-gray-700 btm-mb-2">
                                    <?php botamichat_admin_e('admin.select_end'); ?>
                                </label>
                                <input
                                    id="datepicker-range-end"
                                    name="end"
                                    type="date"
                                    class="btm-bg-gray-50 btm-border btm-border-gray-300 btm-text-gray-900 btm-text-sm btm-rounded-lg btm-focus:ring-2 btm-focus:ring-blue-500 btm-focus:border-blue-500 btm-block btm-w-full btm-px-4 btm-py-2.5 btm-transition-all <?php echo (!$is_pro_or_higher) ? ' pro-badge pro-component' : ''; ?>"
                                    <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?> />
                            </div>
                            <div>
                                <button id="exportButton"
                                    class="btn-botami btm-text-black btm-font-medium btm-px-6 btm-py-2.5 btm-rounded-lg btm-shadow-md btm-hover:shadow-lg btm-transition-all btm-flex btm-items-center btm-gap-2 <?php echo (!$is_pro_or_higher) ? ' pro-badge pro-component' : ''; ?>"
                                    <?php echo (!$is_pro_or_higher) ? 'disabled' : ''; ?>>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                                        <polyline points="7 10 12 15 17 10"></polyline>
                                        <line x1="12" y1="15" x2="12" y2="3"></line>
                                    </svg>
                                    <?php botamichat_admin_e('admin.export_download'); ?>
                                </button>
                            </div>
                        </div>
                        <div
                            class="btm-p-4 btm-m-4 btm-text-sm btm-text-red-800 btm-rounded-lg btm-bg-red-50 dark:btm-bg-gray-800 dark:btm-text-red-400 btm-hidden"
                            id="picker-alert"
                            role="alert"></div>
                    </div>
                </div>
                <button
                    type="submit"
                    class="btm-mt-6 btn-botami text-black btm-px-7 btm-py-2 btm-rounded-lg btm-shadow-md">
                    <?php botamichat_admin_e('admin.save_changes'); ?>
                </button>
        </form>
        <!-- Pro is actif  -->
    <?php endif; ?>
    </div>
</div>
