<?php
/**
 * Uninstall BookSync to Google Calendar Plugin
 *
 * This file is executed when the plugin is deleted from WordPress.
 * It removes all plugin data including options, database tables, and files.
 *
 * @package Google_Event_Sync
 * @since 1.0.0
 */

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete plugin options
delete_option( 'bsgcal_settings' );
delete_option( 'bsgcal_tokens' );
delete_option( 'bsgcal_version' );

// Delete any transients
delete_transient( 'bsgcal_oauth_state' );
delete_transient( 'bsgcal_calendar_cache' );

// Drop custom database tables if they exist
global $wpdb;

$bsgcal_tables = [
	$wpdb->prefix . 'bsgcal_bookings',
	$wpdb->prefix . 'bsgcal_events',
	$wpdb->prefix . 'bsgcal_calendar_cache'
];

foreach ( $bsgcal_tables as $bsgcal_table ) {
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange
	$wpdb->query( $wpdb->prepare( "DROP TABLE IF EXISTS %s", $bsgcal_table ) );
}

// Clear any scheduled hooks
wp_clear_scheduled_hook( 'bsgcal_cleanup_expired_tokens' );
wp_clear_scheduled_hook( 'bsgcal_sync_calendar_events' );

// Remove any custom capabilities
$bsgcal_admin_role = get_role( 'administrator' );
if ( $bsgcal_admin_role ) {
	$bsgcal_admin_role->remove_cap( 'manage_bsgcal_bookings' );
	$bsgcal_admin_role->remove_cap( 'view_bsgcal_bookings' );
}

// Clean up any user meta
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( "DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE 'bsgcal_%'" );

// Clear any cached data
if ( function_exists( 'wp_cache_flush' ) ) {
	wp_cache_flush();
}

// Log uninstall for debugging (optional)
if ( defined( 'WP_DEBUG' ) && WP_DEBUG && defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG ) {
	// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
	error_log( 'BookSync to Google Calendar plugin uninstalled and all data cleaned up.' );
} 