<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BSGCAL_Frontend {
	public static function init() : void {
		add_action( 'wp_enqueue_scripts', [ __CLASS__, 'enqueue_assets' ] );
	}

	public static function enqueue_assets() : void {
		$settings = BSGCAL_Admin::get_settings();
		wp_enqueue_style( 'bsgcal-frontend', BSGCAL_PLUGIN_URL . 'assets/css/frontend.css', [], BSGCAL_VERSION );
		wp_enqueue_script( 'bsgcal-frontend', BSGCAL_PLUGIN_URL . 'assets/js/frontend.js', [], BSGCAL_VERSION, true );
		wp_localize_script( 'bsgcal-frontend', 'BSGCAL_FRONTEND', [
			'rest_base' => esc_url_raw( rest_url( 'bsgcal/v1' ) ),
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'nonce' => wp_create_nonce( 'wp_rest' ),
			'time_buffer' => (int) ($settings['time_buffer_minutes'] ?? 15), // Buffer time in minutes
			'labels' => [
				'name' => $settings['name_label'],
				'phone' => $settings['phone_label'],
				'submit' => __( 'Book', 'booksync-to-google-calendar' ),
				'pick_date' => __( 'Pick a date', 'booksync-to-google-calendar' ),
				'available_slots' => __( 'Available time slots', 'booksync-to-google-calendar' ),
				'no_slots' => $settings['no_slots_label'],
				'loading_slots' => $settings['loading_slots_label'],
				'booked' => $settings['booked_message'],
			],
			'calendar' => [
				'language' => $settings['calendar_language'] ?? get_locale(),
				'weekdays' => $settings['weekday_abbreviations'] ?? [
					'mon' => 'Mon', 'tue' => 'Tue', 'wed' => 'Wed', 'thu' => 'Thu',
					'fri' => 'Fri', 'sat' => 'Sat', 'sun' => 'Sun'
				],
			],
		] );
	}

	public static function render_shortcode( $atts = [] ) : string {
		ob_start();
		?>
		<div id="bsgcal-app" class="bsgcal-app" data-component="booking"></div>
		<?php
		return (string) ob_get_clean();
	}
} 