<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BSGCAL_DB {
	public static function table_name() : string {
		global $wpdb;
		return $wpdb->prefix . 'google_events';
	}

	public static function maybe_initialize() : void {
		// Currently handled by activator dbDelta; method kept for symmetry
	}

	public static function insert_booking( array $data ) : int {
		global $wpdb;
		$defaults = [
			'meeting_start' => null,
			'meeting_end' => null,
			'client_name' => '',
			'client_phone' => '',
			'google_event_id' => null,
			'status' => 'confirmed',
		];
		$data = wp_parse_args( $data, $defaults );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
		$wpdb->insert( self::table_name(), [
			'meeting_start' => $data['meeting_start'],
			'meeting_end' => $data['meeting_end'],
			'client_name' => $data['client_name'],
			'client_phone' => $data['client_phone'],
			'google_event_id' => $data['google_event_id'],
			'status' => $data['status'],
		] );

		return (int) $wpdb->insert_id;
	}

	public static function list_bookings( int $limit = 50, int $offset = 0 ) : array {
		global $wpdb;
		$table = self::table_name();
		// Table name is safe - it's constructed from $wpdb->prefix
		// phpcs:ignore WordPress.DB.PreparedSQLPlaceholders.UnquotedTableName
		$query = $wpdb->prepare(
			// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
			"SELECT * FROM `{$table}` ORDER BY meeting_start DESC LIMIT %d OFFSET %d",
			$limit,
			$offset
		);
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
		return $wpdb->get_results( $query, ARRAY_A );
	}

	public static function count_bookings() : int {
		global $wpdb;
		$table = self::table_name();
		// Table name is safe - it's constructed from $wpdb->prefix
		// phpcs:ignore WordPress.DB.PreparedSQLPlaceholders.UnquotedTableName,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		$query = "SELECT COUNT(*) FROM `{$table}`";
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
		return (int) $wpdb->get_var( $query );
	}

	public static function is_slot_taken( string $start, string $end ) : bool {
		global $wpdb;
		$table = self::table_name();
		// Table name is safe - it's constructed from $wpdb->prefix
		// phpcs:ignore WordPress.DB.PreparedSQLPlaceholders.UnquotedTableName
		$query = $wpdb->prepare(
			// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
			"SELECT COUNT(*) FROM `{$table}` WHERE NOT( meeting_end <= %s OR meeting_start >= %s ) AND status = 'confirmed'",
			$start,
			$end
		);
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
		return (int) $wpdb->get_var( $query ) > 0;
	}
} 