<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BSGCAL_Activator {
	public static function activate() : void {
		self::create_tables();
	}

	public static function deactivate() : void {
		// Nothing for now
	}

	public static function create_tables() : void {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		
		// Main bookings table
		$table_name = $wpdb->prefix . 'google_events';
		$sql = "CREATE TABLE {$table_name} (
			id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
			created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
			meeting_start DATETIME NOT NULL,
			meeting_end DATETIME NOT NULL,
			client_name VARCHAR(191) NOT NULL,
			client_phone VARCHAR(64) NOT NULL,
			google_event_id VARCHAR(191) NULL,
			status VARCHAR(32) NOT NULL DEFAULT 'confirmed',
			PRIMARY KEY (id),
			KEY meeting_start (meeting_start),
			KEY status (status)
		) {$charset_collate};";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta( $sql );
	}
} 