const WIDGET_DEFAULT_WIDTH = "234px";
const WIDGET_OPEN_WIDTH = "431px";
const WIDGET_CLOSED_HEIGHT = "86px";
const WIDGET_OPEN_HEIGHT = "90%";

let widgetState = "close";

function setWidgetBaseStyles() {
    const widget = document.getElementById("vigore-widget");
    if (!widget) return;

    widget.style.bottom = "0";
    widget.style.right = "0";
    updateWidgetStyles();
}

function updateWidgetStyles() {
    const widget = document.getElementById("vigore-widget");
    if (!widget) return;

    if (widgetState === "open") {
        widget.style.height = WIDGET_OPEN_HEIGHT;
        widget.style.width = window.innerWidth <= 501 ? "100%" : WIDGET_OPEN_WIDTH;
    } else {
        widget.style.height = WIDGET_CLOSED_HEIGHT;
        widget.style.width = window.innerWidth <= 501 ? "100%" : WIDGET_DEFAULT_WIDTH;
    }
}

function messageIframe(event) {
    if (event.data && event.data.action === "update_widget") {
        widgetState = event.data.button === "open" ? "open" : "close";
        updateWidgetStyles();
    }
}


setWidgetBaseStyles();

window.addEventListener("resize", updateWidgetStyles);
window.addEventListener("message", messageIframe);
