// Handle instructor selection
function handleInstructorSelection() {
    const select = document.getElementById('vigore_professional_id');
    const originalText = select.options[0].text;
    select.disabled = true;
    select.options[0].text = 'Loading...';
    
    const formData = new FormData();
    formData.append('action', 'vigore_fetch_instructors');
    formData.append('nonce', vigoreAuth.nonce);

    fetch(vigoreAuth.ajaxurl, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(response => {
        if (response.success && response.data && response.data.response) {
            displayInstructors(response.data.response);
        } else {
            throw new Error(response.data || 'Failed to fetch instructors');
        }
    })
    .catch(error => {
        alert(error.message || 'Failed to fetch instructors');
    })
    .finally(() => {
        select.disabled = false;
        select.options[0].text = originalText;
    });
}

// Display instructors in select input
function displayInstructors(instructors) {
    const select = document.getElementById('vigore_professional_id');
    const currentId = document.getElementById('current_professional_id').value;
    
    // Clear existing options except the first one
    while (select.options.length > 1) {
        select.remove(1);
    }
    
    if (!instructors || instructors.length === 0) {
        select.options[0].text = 'No instructors found';
        return;
    }
    
    // Add instructor options
    instructors.forEach(instructor => {
        const option = document.createElement('option');
        option.value = instructor.id;
        option.textContent = `${instructor.firstName} ${instructor.lastName}`;
        if (instructor.id === currentId) {
            option.selected = true;
        }
        select.appendChild(option);
    });
}

// Handle instructor removal
function handleInstructorRemoval() {
    const button = document.getElementById('vigore-remove-instructor');
    const originalText = button.textContent;
    button.disabled = true;
    
    const formData = new FormData();
    formData.append('action', 'vigore_remove_instructor');
    formData.append('nonce', vigoreAuth.nonce);

    fetch(vigoreAuth.ajaxurl, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(response => {
        if (response.success) {
            document.getElementById('vigore_professional_id').value = '';
            button.remove();
            window.location.reload();
        } else {
            throw new Error(response.data || 'Failed to remove instructor');
        }
    })
    .catch(error => {
        alert(error.message || 'Failed to remove instructor');
    })
    .finally(() => {
        button.disabled = false;
        button.textContent = originalText;
    });
}

// Initialize instructor functionality
document.addEventListener('DOMContentLoaded', function() {
    const select = document.getElementById('vigore_professional_id');
    if (select) {
        handleInstructorSelection();
    }

    // Handle form submission
    const form = document.getElementById('vigore-settings-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(form);
            formData.append('action', 'vigore_save_settings');
            formData.append('nonce', vigoreAuth.settingsNonce);
            
            fetch(vigoreAuth.ajaxurl, {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(response => {
                if (response.success) {
                    window.location.reload();
                } else {
                    throw new Error(response.data || 'Failed to save settings');
                }
            })
            .catch(error => {
                alert(error.message || 'Failed to save settings');
            });
        });
    }

    // Handle instructor removal
    const removeButton = document.getElementById('vigore-remove-instructor');
    if (removeButton) {
        removeButton.addEventListener('click', handleInstructorRemoval);
    }
}); 
