"use strict";

/**
 * global wpbc_plugins_params
 */
jQuery(function ($) {
  var wpbc_deactivation_feedback = {
    init: function () {
      this.event_init();
    },
    event_init: function () {
      var _that = this;
      $(document.body).on("click", 'tr[data-plugin="booking/wpdev-booking.php"] span.deactivate a', function (e) {
        e.preventDefault();
        $("#wpbc_deactivate-feedback-popup-wrapper").addClass('active');
      });
      $(document.body).on("click", 'tr[data-plugin="booking-calendar-com/booking-calendar-com.php"] span.deactivate a', function (e) {
        e.preventDefault();
        $('#wpbc_deactivate-feedback-popup-wrapper').addClass('active');
      });
      $("#wpbc_deactivate-feedback-popup-wrapper").click(function (event) {
        var $target = $(event.target);
        if (!$target.closest(".wpbc_deactivate-feedback-popup-inner").length) {
          $("#wpbc_deactivate-feedback-popup-wrapper").removeClass("active");
        }
      });
      $("form.wpbc_deactivate-feedback-form").on('submit', function (e) {
        e.preventDefault();
        _that.send_data($(this));
      });
      $('#wpbc_deactivate-feedback-popup-wrapper').on('click', '.close-deactivate-feedback-popup', function () {
        $('#wpbc_deactivate-feedback-popup-wrapper').removeClass('active');
      });
      $('input.wpbc_deactivate-feedback-input').on('click', function () {
        if (jQuery("form.wpbc_deactivate-feedback-form").find('input[name="reason_slug"]:checked').length) {
          jQuery('.wpbc_deactivate-feedback-popup-form-more-details').show();
          jQuery('.wpbc_deactivate-feedback-popup-form-footer .skip').hide();
        } else {
          jQuery('.wpbc_deactivate-feedback-popup-form-more-details').hide();
          jQuery('.wpbc_deactivate-feedback-popup-form-footer .skip').show();
        }
      });
    },
    send_data: function (form) {
      var reason_slug = form.find('input[name="reason_slug"]:checked').map(function () {
        return jQuery(this).val();
      }).get().join(' | ');
      if (0 === jQuery("form.wpbc_deactivate-feedback-form").find('input[name="reason_slug"]:checked').length) {
        alert("Please select at least one option from the list");
        return;
      }
      if (form.find("button.submit").hasClass("button-disabled")) {
        return;
      }
      var reason_text = '';
      var reason_text_el = form.find('input[name="reason_' + reason_slug + '"]');
      if (reason_text_el.length > 0) {
        reason_text = reason_text_el.val();
      }
      var data = {
        reason_slug: "user_registration_deactivation_notice"
      };
      data["reason_" + reason_slug] = reason_text;
      var values_arr = {};
      jQuery.each(form.serializeArray(), function (i, field) {
        if ('undefined' === typeof values_arr[field.name]) {
          values_arr[field.name] = field.value;
        } else {
          values_arr[field.name] += ' | ' + field.value;
        }
      });
      $.ajax({
        url: wpbc_plugins_params.ajax_url,
        data: values_arr,
        type: "post",
        beforeSend: function () {
          form.find("button.submit").addClass("button-disabled button updating-message");
        }
      }).done(function () {
        window.location = form.find("a.skip").attr("href");
      });
    }
  };
  wpbc_deactivation_feedback.init();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
