<?php
/**
 * Uninstall Handler
 *
 * Fired when the plugin is uninstalled (deleted from WordPress admin).
 * Data is preserved by default to allow safe switching between Lite and PRO versions.
 *
 * @package BSFEF
 * @since 1.0.1
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Check if user wants to keep data when uninstalling
// Default: 'yes' (keep data) - allows safe upgrade to PRO version
// When checkbox is CHECKED, option value is 'yes'
// When checkbox is UNCHECKED, option value is 'no'
$bsfef_keep_data_option = get_option('bsfef_keep_data_on_uninstall', 'yes');

// If 'no' = DELETE data
// If 'yes' = KEEP data
if ($bsfef_keep_data_option === 'no') {
    // Only delete if user explicitly chose to remove all data
    global $wpdb;
    
    // Delete database tables
    $bsfef_table_name = $wpdb->prefix . 'bsfef_booking_slots';
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, PluginCheck.Security.DirectDB.UnescapedDBParameter -- Table name must be interpolated, uninstall requires direct table drop
    $wpdb->query("DROP TABLE IF EXISTS {$bsfef_table_name}");
    
    // Delete plugin options
    delete_option('bsfef_db_version');
    delete_option('bsfef_keep_data_on_uninstall');
    
    // Clear any cached data
    wp_cache_flush();
} else {
    // Keep all booking data - safe for upgrading to PRO version
    // Only remove the uninstall preference (allows clean reinstall)
    // All booking data in wp_bsfef_booking_slots table will be preserved
    delete_option('bsfef_keep_data_on_uninstall');
}
