<?php
/**
 * Lite Pro-Features Stub (wp.org safe)
 * In the Lite build, all PRO checks return false and upsell UI is limited to small notices.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; }

class BSFEF_Pro_Features {

	/* ===== Capability checks (all false in Lite) ===== */
	public static function is_pro() {
		return false; }
	public static function can_use_availability_ranges() {
		return false; }
	public static function can_use_per_range_intervals() {
		return false; }
	public static function can_extend_perpetual() {
		return false; }
	public static function can_use_multi_form() {
		return false; } // PRO: isolate per form
	public static function can_isolate_forms() {
		return false; }  // Alias
	public static function can_customize_styles() {
		return false; }
	public static function can_filter_bookings() {
		return false; }
	public static function can_use_filters() {
		return false; }     // Alias
	public static function can_use_bulk_delete() {
		return false; }

	/*
	===== Helpers ===== */
	// In free version: return '0' to indicate shared slots (used for availability checking)
	// But the actual form_id is still saved in DB for future PRO upgrade
	public static function get_effective_form_id( $form_id ) {
		return '0'; }
	public static function get_upgrade_url() {
		return 'https://products.dopestudio.co.uk/BSEF'; }

	/* ===== UI helpers ===== */
	public static function upgrade_notice( $feature_name = '' ) {
		$url   = esc_url( self::get_upgrade_url() );
		$title = esc_html( $feature_name );
		$desc  = esc_html__( 'This feature is available in the PRO version.', 'booking-slots-for-elementor-forms-lite' );

		if ( trim( $feature_name ) === 'Availability Ranges' ) {
			$title = esc_html__( 'Availability Ranges', 'booking-slots-for-elementor-forms-lite' );
			$desc  = esc_html__( 'Define multiple date ranges with custom time intervals & minimum booking notice. Example: set next weekend with slots from 3 AM – 5 PM with 30-minute intervals and 60 minute notice (can be booked 60 minutes before the slot) before the slot, then the weekend after next with slots from 10 AM – 2 PM with 60-minute intervals no notice (can be booked last minute).', 'booking-slots-for-elementor-forms-lite' );
		}

		return '<div class="notice notice-info inline" style="padding:12px; margin:10px 0;">'
			. '<p style="margin:0 0 8px 0;"><strong>' . $title . '</strong></p>'
			. '<p style="margin:0 0 10px 0;">' . $desc . '</p>'
			. '<a href="' . $url . '" target="_blank" class="button button-primary">'
			. esc_html__( 'Learn More About PRO', 'booking-slots-for-elementor-forms-lite' )
			. '</a>'
			. '</div>';
	}

	public static function get_dynamic_banner() {
		return array(
			'enabled'     => false,
			'message'     => '',
			'link'        => '',
			'button_text' => '',
			'type'        => 'default',
		);
	}

	public static function admin_notice() {
		/* no-op in Lite */ }
}
