<?php
/*
Plugin Name: Book Me
Description: A booking plugin for scheduling appointments, with email notifications for both admin and client.
Version: 1.0.0
Author: Moses Cursor
Text Domain: book-me
Domain Path: /languages
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

// Define plugin directory
define( 'BOOK_ME_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

// Enqueue Scripts and Styles
function bm_enqueue_assets() {
    wp_enqueue_style( 'book-me-style', plugins_url( '/assets/css/booking.css', __FILE__ ), array(), '1.0.0' );
    wp_enqueue_script( 'book-me-script', plugins_url( '/assets/js/booking.js', __FILE__ ), array('jquery'), '1.0.0', true );
}
add_action( 'wp_enqueue_scripts', 'bm_enqueue_assets' );

// Include necessary files
require_once( BOOK_ME_PLUGIN_DIR . 'includes/email-notifications.php' );
require_once( BOOK_ME_PLUGIN_DIR . 'includes/booking-form.php' );

// Shortcode for booking form
function bm_booking_form_shortcode() {
    ob_start();
    bm_display_booking_form();
    return ob_get_clean();
}
add_shortcode( 'booking_form', 'bm_booking_form_shortcode' );

// Handle form submission
function bm_process_booking_form() {
    if ( isset( $_POST['bm_booking_submit'] ) ) {
        // Sanitize user input
        $name = sanitize_text_field( $_POST['bm_name'] );
        $email = sanitize_email( $_POST['bm_email'] );
        $phone = sanitize_text_field( $_POST['bm_phone'] );
        $description = sanitize_textarea_field( $_POST['bm_description'] );

        // Send email notifications
        bm_send_booking_notification( $name, $email, $phone, $description );
        bm_send_admin_notification( $name, $email, $phone, $description );

        // Store booking in the database
        update_option( 'bm_booked_slots', array( 'name' => $name, 'email' => $email, 'phone' => $phone, 'description' => $description ) );
    }
}
add_action( 'init', 'bm_process_booking_form' );
