<?php
namespace BlogKit\Admin\Assets;

class SVG
{
    public function __construct()
    {

    }

    /**
     * Get SVG DOM Element
     *
     * @param string $svg SVG string
     * @return \DOMElement|null SVG DOM Element
     */
    public function getSVG($svg)
    {
        $dom = new \DOMDocument();
        $dom->loadHTML($svg);
        $svg = $dom->getElementsByTagName('svg');
        return $svg->item(0);
    }

    /**
     * Get SVG dimensions
     *
     * @param string $svg SVG string
     * @return array Array containing width and height
     */
    public function getSVGSize($svg)
    {
        $svg = $this->getSVG($svg);
        $width = $svg->getAttribute('width');
        $height = $svg->getAttribute('height');
        return array('width' => $width, 'height' => $height);
    }

    /**
     * Get BlogKit plugin icon SVG
     *
     * @return string SVG icon string
     */
    public static function BlogKitIcon()
    {
        return '<?xml version="1.0" encoding="utf-8"?>
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
     viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
    <linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="4.2174" y1="256" x2="507.7826" y2="256">
        <stop offset="0" style="stop-color:#0049E7"/>
        <stop offset="0.2552" style="stop-color:#1647E9"/>
        <stop offset="0.5967" style="stop-color:#5740EE"/>
        <stop offset="1" style="stop-color:#C835F8"/>
    </linearGradient>
    <path class="st0" d="M507.8,256c0,57.4-19.2,110.3-51.6,152.7c-14,18.5-30.6,35-49.2,48.9c-42.1,31.5-94.3,50.2-150.9,50.2
        c-37,0-72.2-8-103.7-22.3c-22.8-10.3-43.8-23.9-62.4-40.3C37.4,399,4.2,331.4,4.2,256C4.2,116.9,116.9,4.2,256,4.2
        c57.5,0,110.6,19.3,153,51.8c16.6,12.7,31.7,27.5,44.6,44C487.6,142.9,507.8,197.1,507.8,256z"/>
    <g>
        <path class="st1" d="M311.7,179.1c-5.2,60.5-65.8,62.4-65.8,62.4v-44.7c0,0,19.5-8.1,20.1-29.1c0.1-0.9,0.1-1.7,0-2.6v-9.1
            c0-21.8-17.6-39.4-39.4-39.4h-61.1v223.3L118.1,301V100.8c0-12.4,10.1-22.5,22.5-22.5h82.2c46.8-1.4,63.5,14.6,63.5,14.6
            c28,24.6,27.7,60.4,26.5,73.7C312.3,170.8,312,175,311.7,179.1z"/>
        <path class="st1" d="M228.9,157.4h-24.2c-12.3,0-22.3,10-22.3,22.3v217.8l54.5-49.3c0,0,11.9-9.8,24.2-5.4c0,0,12.1,2.9,26.1,22.6
            c12.7,18,25.3,36.2,38.3,54.1l15,20.8h56.8L294,299.8l103.1-103.3h-59.8l-108.4,115V157.4z"/>
    </g>
</g>
</svg>';
    }

    public static function Link()
    {
        return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
        <path d="M211.26 389.24l-60.33 60.33c-25.01 25.01-65.52 25.01-90.51 0-25-25-25-65.5 0-90.5l120.68-120.68c24.99-24.99 65.5-24.99 90.49 0 8.33 8.33 21.84 8.33 30.17 0s8.33-21.84 0-30.17c-41.65-41.65-109.18-41.65-150.83 0L30.25 328.91c-41.65 41.65-41.65 109.18 0 150.83 41.65 41.68 109.18 41.68 150.85 0l60.33-60.33c8.33-8.33 8.33-21.84 0-30.17s-21.84-8.33-30.17 0z"/>
        <path d="M479.75 30.24c-41.65-41.65-109.2-41.65-150.85 0l-72.38 72.38c-8.33 8.33-8.33 21.84 0 30.17 8.33 8.33 21.84 8.33 30.17 0l72.38-72.38c24.99-24.99 65.52-24.99 90.51 0 24.99 24.99 24.99 65.5 0 90.49L316.85 283.64c-24.99 24.99-65.5 24.99-90.49 0-8.33-8.33-21.84-8.33-30.17 0s-8.33 21.84 0 30.17c41.65 41.65 109.18 41.65 150.83 0l132.74-132.74c41.65-41.65 41.65-109.18 0-150.83z"/>
        </svg>';
    }

    public static function Image()
    {
        return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
        <path d="M486.4 68.267H25.6C11.483 68.267 0 79.75 0 93.867v324.267c0 14.117 11.483 25.6 25.6 25.6h460.8c14.117 0 25.6-11.483 25.6-25.6V291.584V93.867c0-14.117-11.483-25.6-25.6-25.6zM25.6 426.667c-4.704 0-8.533-3.829-8.533-8.533V312.271l79.371-79.375c3.208-3.25 8.675-3.292 11.967.042l84.343 84.265-109.498 109.464H25.6zM494.933 418.133c0 4.704-3.829 8.533-8.533 8.533H107.388l253.583-253.504c3.208-3.25 8.679-3.292 11.963.042l122 121.918v123.011zM494.933 270.99L385.037 161.171c-9.675-9.792-26.571-9.75-36.171-.042L204.816 305.138l-84.311-84.233c-9.675-9.792-26.571-9.754-36.171-.037l-67.267 67.27V93.867c0-4.704 3.829-8.533 8.533-8.533h460.8c4.704 0 8.533 3.829 8.533 8.533v177.123z"/>
        <path d="M213.333 128c-28.233 0-51.2 22.967-51.2 51.2s22.967 51.2 51.2 51.2c28.233 0 51.2-22.967 51.2-51.2s-22.967-51.2-51.2-51.2zm0 85.333c-18.821 0-34.133-15.313-34.133-34.133s15.312-34.133 34.133-34.133 34.133 15.313 34.133 34.133-15.313 34.133-34.133 34.133z"/>
        </svg>
        ';
    }

    public static function Audio()
    {
        return '<svg
        version="1.1"
        id="fi_608417"
        xmlns="http://www.w3.org/2000/svg"
        xmlnsXlink="http://www.w3.org/1999/xlink"
        x="0px"
        y="0px"
        viewBox="0 0 480 480"
        style={{ enableBackground: "new 0 0 480 480" }}
        xmlSpace="preserve"
        >
        <g>
            <path d="M278.944,17.577c-5.568-2.656-12.128-1.952-16.928,1.92L106.368,144.009H32c-17.632,0-32,14.368-32,32v128c0,17.632,14.368,32,32,32h74.368l155.616,124.512c2.912,2.304,6.464,3.488,10.016,3.488c2.368,0,4.736-0.512,6.944-1.568c5.536-2.688,9.056-8.288,9.056-14.432v-416C288,25.865,284.48,20.265,278.944,17.577z M96,304.009H32v-128h64V304.009z M256,414.697l-128-102.4V167.721l128-102.4V414.697z" />
            <path d="M369.024,126.857c-6.304-6.24-16.416-6.144-22.624,0.128c-6.208,6.304-6.144,16.416,0.128,22.624c24.16,23.904,37.472,56,37.472,90.4c0,34.4-13.312,66.496-37.472,90.4c-6.304,6.208-6.368,16.32-0.128,22.624c3.136,3.168,7.264,4.736,11.36,4.736c4.064,0,8.128-1.536,11.264-4.64c30.304-29.92,46.976-70.08,46.976-113.12C416,196.969,399.328,156.809,369.024,126.857z" />
            <path d="M414.144,81.769c-6.272-6.208-16.416-6.176-22.624,0.096c-6.208,6.272-6.176,16.416,0.096,22.624C427.968,140.553,448,188.681,448,240.009s-20.032,99.456-56.384,135.52c-6.272,6.208-6.304,16.352-0.096,22.624c3.136,3.168,7.232,4.736,11.36,4.736c4.064,0,8.128-1.536,11.264-4.64C456.608,356.137,480,299.945,480,240.009C480,180.073,456.608,123.881,414.144,81.769z" />
        </g>
        </svg>
        ';
    }

    public static function Gallery()
    {
        return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 430.23 430.23">
        <path d="M217.875 159.668c-24.237 0-43.886 19.648-43.886 43.886 0 24.237 19.648 43.886 43.886 43.886 24.237 0 43.886-19.648 43.886-43.886 0-24.238-19.649-43.886-43.886-43.886zm0 66.873c-12.696 0-22.988-10.292-22.988-22.988s10.292-22.988 22.988-22.988 22.988 10.292 22.988 22.988-10.292 22.988-22.988 22.988z"/>
        <path d="M392.896 59.357 107.639 26.966c-11.071-1.574-22.288 1.658-30.824 8.882-8.535 6.618-14.006 16.428-15.151 27.167l-5.224 42.841H40.243c-22.988 0-40.229 20.375-40.229 43.363V362.9c-.579 21.921 16.722 40.162 38.644 40.741.528.014 1.057.017 1.585.01h286.824c22.988 0 43.886-17.763 43.886-40.751v-8.359c7.127-1.377 13.888-4.224 19.853-8.359 8.465-7.127 13.885-17.22 15.151-28.212l24.033-212.114c2.401-20.44-14.134-41.167-37.143-43.898zm-42.841 303.543c0 11.494-11.494 19.853-22.988 19.853H40.243c-10.383.305-19.047-7.865-19.352-18.248-.016-.535-.009-1.07.021-1.605v-38.661l80.98-59.559c9.728-7.469 23.43-6.805 32.392 1.567l56.947 50.155c8.648 7.261 19.534 11.32 30.825 11.494 8.828.108 17.511-2.243 25.078-6.792l102.922-59.559V362.9zm0-125.91-113.894 66.351c-9.78 5.794-22.159 4.745-30.825-2.612l-57.469-50.678c-16.471-14.153-40.545-15.021-57.992-2.09l-68.963 50.155V149.219c0-11.494 7.837-22.465 19.331-22.465h286.824c12.28.509 22.197 10.201 22.988 22.465V236.99zm59.057-133.955c-.007.069-.013.139-.021.208l-24.555 212.114c.042 5.5-2.466 10.709-6.792 14.106-2.09 2.09-6.792 3.135-6.792 4.18V149.219c-.825-23.801-20.077-42.824-43.886-43.363H77.337l4.702-40.751c1.02-5.277 3.779-10.059 7.837-13.584 4.582-3.168 10.122-4.645 15.674-4.18l284.735 32.914c11.488 1.791 19.918 11.99 18.827 23.48z"/>
        </svg>
        ';
    }

    public static function Quote()
    {
        return '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
        <path d="M50.63 26.23c-.13-1.39-.03-5.18 3.6-10.45a.86.86 0 0 0-.12-1.27c-1.48-1.48-2.4-2.41-3.04-3.07-.85-.86-1.23-1.25-1.8-1.77a.94.94 0 0 0-1.33-.01c-6.33 5.5-13.35 16.88-12.33 30.81.6 8.18 6.56 14.12 14.19 14.12s14.19-6.37 14.19-14.19c0-7.55-5.93-13.74-13.36-14.13zm-.82 26.36c-6.55 0-11.68-5.16-12.2-12.26-1.14-15.67 8.17-25.85 10.99-28.54.27.27.59.59 1.05 1.06.56.57 1.32 1.34 2.47 2.5-4.41 6.79-3.57 11.62-3.21 12.32a.9.9 0 0 0 .9.55c6.72 0 12.19 5.47 12.19 12.19s-5.47 12.19-12.19 12.19zM15.11 26.23c-.13-1.39-.03-5.17 3.6-10.45a.86.86 0 0 0-.12-1.27c-1.48-1.48-2.39-2.41-3.03-3.06-.85-.86-1.23-1.26-1.8-1.77a.94.94 0 0 0-1.33-.01C5.11 15.17-2 26.55-.98 40.49c.6 8.18 6.57 14.12 14.19 14.12s14.19-6.37 14.19-14.19c0-7.55-5.92-13.74-13.36-14.19zM14.29 52.59c-6.55 0-11.68-5.16-12.2-12.27-1.14-15.67 8.17-25.85 10.99-28.54.28.27.6.59 1.05 1.06.56.57 1.32 1.34 2.47 2.5-4.41 6.79-3.57 11.62-3.21 12.32a.9.9 0 0 0 .9.55c6.72 0 12.19 5.47 12.19 12.19s-5.47 12.19-12.19 12.19z"/>
        </svg>
        ';
    }

    public static function Video()
    {
        return '<svg id="fi_3024584" enable-background="new 0 0 189.524 189.524" height="512" viewBox="0 0 189.524 189.524" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path clip-rule="evenodd" d="m94.762 180.048c47.102 0 85.286-38.183 85.286-85.286 0-47.102-38.183-85.286-85.286-85.286-47.102 0-85.286 38.184-85.286 85.286s38.184 85.286 85.286 85.286zm0 9.476c52.335 0 94.762-42.427 94.762-94.762 0-52.336-42.427-94.762-94.762-94.762-52.336 0-94.762 42.426-94.762 94.762 0 52.335 42.426 94.762 94.762 94.762z" fill-rule="evenodd"></path></g><g><path clip-rule="evenodd" d="m119.386 94.762-43.577-29.051v58.103zm8.804-5.519c3.939 2.626 3.939 8.413 0 11.039l-51.545 34.364c-4.408 2.939-10.313-.222-10.313-5.52v-68.727c0-5.298 5.905-8.458 10.313-5.519z" fill-rule="evenodd"></path></g></g></svg>';
    }
    public static function Comments()
    {
        return '<svg id="Layer_1" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg" data-name="Layer 1"><path d="m12 0c-6.617 0-12 5.383-12 12s5.383 12 12 12h12v-12c0-6.617-5.383-12-12-12zm10 22h-10c-5.514 0-10-4.486-10-10s4.486-10 10-10 10 4.486 10 10zm-8.5-10c0 .828-.672 1.5-1.5 1.5s-1.5-.672-1.5-1.5.672-1.5 1.5-1.5 1.5.672 1.5 1.5zm5 0c0 .828-.672 1.5-1.5 1.5s-1.5-.672-1.5-1.5.672-1.5 1.5-1.5 1.5.672 1.5 1.5zm-10 0c0 .828-.672 1.5-1.5 1.5s-1.5-.672-1.5-1.5.672-1.5 1.5-1.5 1.5.672 1.5 1.5z"/></svg>';
    }
    public static function Calender()
    {
        return '<svg id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m446 40h-46v-24c0-8.836-7.163-16-16-16s-16 7.164-16 16v24h-224v-24c0-8.836-7.163-16-16-16s-16 7.164-16 16v24h-46c-36.393 0-66 29.607-66 66v340c0 36.393 29.607 66 66 66h380c36.393 0 66-29.607 66-66v-340c0-36.393-29.607-66-66-66zm-380 32h46v16c0 8.836 7.163 16 16 16s16-7.164 16-16v-16h224v16c0 8.836 7.163 16 16 16s16-7.164 16-16v-16h46c18.748 0 34 15.252 34 34v38h-448v-38c0-18.748 15.252-34 34-34zm380 408h-380c-18.748 0-34-15.252-34-34v-270h448v270c0 18.748-15.252 34-34 34z" fill="currentColor" /></g></svg>';
    }
    public static function Taxonomy() {
        return '<svg xmlns="http://www.w3.org/2000/svg" id="fi_12078967" viewBox="0 0 64 64"><path d="M22,44.5H6a2.00229,2.00229,0,0,0-2,2V58a2.00229,2.00229,0,0,0,2,2H22a2.00229,2.00229,0,0,0,2-2V46.5A2.00229,2.00229,0,0,0,22,44.5ZM6,58V46.5H22L22.001,58Z"></path><path d="M58,44.5H42a2.00229,2.00229,0,0,0-2,2V58a2.00229,2.00229,0,0,0,2,2H58a2.00229,2.00229,0,0,0,2-2V46.5A2.00229,2.00229,0,0,0,58,44.5ZM42,58V46.5H58L58.001,58Z"></path><path d="M46.49023,33a2.3777,2.3777,0,0,1,2.375,2.375V41a1.00013,1.00013,0,0,0,2-.00006V35.375A4.38,4.38,0,0,0,46.49023,31H42.125A9.1354,9.1354,0,0,1,33,21.875V19.5H44.5a2.00229,2.00229,0,0,0,2-2V6a2.00229,2.00229,0,0,0-2-2h-25a2.00229,2.00229,0,0,0-2,2V17.5a2.00229,2.00229,0,0,0,2,2H31v2.375A9.1354,9.1354,0,0,1,21.875,31h-4.5A4.38,4.38,0,0,0,13,35.375V41a1,1,0,0,0,2,0V35.375A2.3777,2.3777,0,0,1,17.375,33h4.5A11.13182,11.13182,0,0,0,32,26.45911,11.13182,11.13182,0,0,0,42.125,33ZM19.5,17.5V6h25l.001,11.5Z"></path></svg>';
    }
    public static function Clock() {
        return '
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M10 0C4.4861 0 0 4.4861 0 10C0 15.5139 4.4861 20 10 20C15.5139 20 20 15.5139 20 10C20 4.4861 15.5139 0 10 0ZM10 18.75C5.17517 18.75 1.25001 14.8248 1.25001 10C1.25001 5.17517 5.17517 1.25001 10 1.25001C14.8248 1.25001 18.75 5.17517 18.75 10C18.75 14.8248 14.8248 18.75 10 18.75Z" fill="#686868"/>
        <path d="M10.625 3.75H9.375V10.2588L13.3081 14.1919L14.1919 13.3081L10.625 9.74119V3.75Z" fill="#686868"/>
        </svg>
        ';
    }
    public static function arrow_left_alt(){
        return '<svg width="16" height="16" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.292892 8.07112C-0.0976315 7.6806 -0.0976315 7.04743 0.292892 6.65691L6.65685 0.292946C7.04738 -0.0975785 7.68054 -0.0975785 8.07107 0.292946C8.46159 0.68347 8.46159 1.31664 8.07107 1.70716L2.41421 7.36401L8.07107 13.0209C8.46159 13.4114 8.46159 14.0446 8.07107 14.4351C7.68054 14.8256 7.04738 14.8256 6.65685 14.4351L0.292892 8.07112ZM16 7.36401V8.36401H0.999999V7.36401V6.36401H16V7.36401Z" fill="black"/>';
    }
    public static function arrow_right_alt(){
        return '<svg width="16" height="16" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M15.7071 8.07112C16.0976 7.6806 16.0976 7.04743 15.7071 6.65691L9.34315 0.292946C8.95262 -0.0975785 8.31946 -0.0975785 7.92893 0.292946C7.53841 0.68347 7.53841 1.31664 7.92893 1.70716L13.5858 7.36401L7.92893 13.0209C7.53841 13.4114 7.53841 14.0446 7.92893 14.4351C8.31946 14.8256 8.95262 14.8256 9.34315 14.4351L15.7071 8.07112ZM0 7.36401L0 8.36401H15V7.36401V6.36401H0L0 7.36401Z" fill="black"/>';
    }
}