<?php
/**
 * BlogBotz Uninstall
 *
 * Fired when the plugin is uninstalled.
 * Cleans up all plugin data from the database.
 *
 * @package BlogBotz
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Define plugin directory if not already defined.
if ( ! defined( 'BLOGBOTZ_PLUGIN_DIR' ) ) {
	define( 'BLOGBOTZ_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

// Delete BlogBotz API user.
require_once BLOGBOTZ_PLUGIN_DIR . 'includes/class-blogbotz-connection.php';
$blogbotz_connection = new BlogBotz_Connection();
$blogbotz_connection->delete_api_user();

// Delete all plugin options.
delete_option( 'blogbotz_site_key' );
delete_option( 'blogbotz_api_key' );
delete_option( 'blogbotz_site_id' );
delete_option( 'blogbotz_connected_at' );
delete_option( 'blogbotz_user_email' );
delete_option( 'blogbotz_user_id' );
delete_option( 'blogbotz_app_password' );
delete_option( 'blogbotz_dashboard_url' );
delete_option( 'blogbotz_author_name' );

// Delete post meta created by the plugin.
global $wpdb;

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.SlowDBQuery.slow_db_query_meta_key -- Required for complete plugin uninstallation cleanup.
$wpdb->delete(
	$wpdb->postmeta,
	array( 'meta_key' => '_blogbotz_post' ),
	array( '%s' )
);

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.SlowDBQuery.slow_db_query_meta_key -- Required for complete plugin uninstallation cleanup.
$wpdb->delete(
	$wpdb->postmeta,
	array( 'meta_key' => '_blogbotz_id' ),
	array( '%s' )
);

// Clear any cached data.
wp_cache_flush();
