<?php
/**
 * BlogBotz Admin Page Template
 *
 * @package BlogBotz
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get connection data from the admin class.
$blogbotz_is_connected    = $this->get_connection()->is_connected();
$blogbotz_connection_data = $this->get_connection()->get_connection_data();
$blogbotz_connect_url     = $this->get_connect_url();

// Check for messages.
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only query parameter for success message
$blogbotz_connected_success = isset( $_GET['connected'] ) && '1' === sanitize_text_field( wp_unslash( $_GET['connected'] ) );
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only query parameter for error message
$blogbotz_connection_error = isset( $_GET['error'] ) ? sanitize_text_field( wp_unslash( $_GET['error'] ) ) : '';
$blogbotz_error_message    = isset( $blogbotz_error_message ) ? $blogbotz_error_message : '';
?>

<!-- BlogBotz Plugin Container - Isolated structure to prevent external plugin injection -->
<div class="wrap blogbotz-wrap" data-blogbotz-plugin-container="true">
	<!-- Isolated Header Container - prevents external content injection -->
	<div id="blogbotz-header-container" class="blogbotz-header-container" data-blogbotz-isolated="true">
		<section data-blogbotz-header-section="true" class="blogbotz-header">
			<div class="blogbotz-logo">
				<img src="<?php echo esc_url( BLOGBOTZ_PLUGIN_URL . 'assets/images/blogbotz-logo.png' ); ?>" alt="<?php esc_attr_e( 'BlogBotz', 'blogbotz-ai-blog-automation' ); ?>" class="blogbotz-logo-img" />
			</div>
			<p class="blogbotz-tagline"><?php esc_html_e( 'AI-Powered Blog Automation for WordPress', 'blogbotz-ai-blog-automation' ); ?></p>
		</section>
	</div>

	<div class="blogbotz-content">
		<!-- All messages displayed here, above the connection status -->
		<?php if ( $blogbotz_connected_success && $blogbotz_is_connected ) : ?>
			<div class="notice notice-success is-dismissible" data-blogbotz-notice="true" data-blogbotz-original-parent="blogbotz-content">
				<p><strong><?php esc_html_e( 'Success!', 'blogbotz-ai-blog-automation' ); ?></strong> <?php esc_html_e( 'Your site is now connected to BlogBotz. You can manage your automated content from the BlogBotz dashboard.', 'blogbotz-ai-blog-automation' ); ?></p>
			</div>
		<?php endif; ?>
		
		<?php
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only query parameter for disconnect message
		if ( isset( $_GET['disconnected'] ) && '1' === sanitize_text_field( wp_unslash( $_GET['disconnected'] ) ) && ! $blogbotz_is_connected ) :
			?>
			<div class="notice notice-info is-dismissible" data-blogbotz-notice="true" data-blogbotz-original-parent="blogbotz-content">
				<p><strong><?php esc_html_e( 'Disconnected', 'blogbotz-ai-blog-automation' ); ?></strong> <?php esc_html_e( 'Your site has been disconnected from BlogBotz. You can reconnect at any time.', 'blogbotz-ai-blog-automation' ); ?></p>
			</div>
		<?php endif; ?>

		<?php if ( $blogbotz_connection_error ) : ?>
			<div class="notice notice-error is-dismissible" data-blogbotz-notice="true" data-blogbotz-original-parent="blogbotz-content">
				<p><strong><?php esc_html_e( 'Connection Failed', 'blogbotz-ai-blog-automation' ); ?></strong> <?php esc_html_e( 'There was a problem connecting to BlogBotz. Please try again.', 'blogbotz-ai-blog-automation' ); ?></p>
			</div>
		<?php endif; ?>

		<?php if ( $blogbotz_error_message ) : ?>
			<div class="notice notice-error is-dismissible" data-blogbotz-notice="true" data-blogbotz-original-parent="blogbotz-content">
				<p><strong><?php esc_html_e( 'BlogBotz Error', 'blogbotz-ai-blog-automation' ); ?></strong> <?php echo esc_html( $blogbotz_error_message ); ?></p>
				<p><?php esc_html_e( 'Please check the following:', 'blogbotz-ai-blog-automation' ); ?></p>
				<ul style="list-style: disc; margin-left: 20px;">
					<li><?php esc_html_e( 'WordPress version is 5.6 or higher', 'blogbotz-ai-blog-automation' ); ?> (<?php echo esc_html( get_bloginfo( 'version' ) ); ?>)</li>
					<li><?php esc_html_e( 'Application Passwords are enabled', 'blogbotz-ai-blog-automation' ); ?></li>
					<li><?php esc_html_e( 'Check WordPress debug log for more details', 'blogbotz-ai-blog-automation' ); ?></li>
				</ul>
			</div>
		<?php endif; ?>

		<?php if ( $blogbotz_is_connected ) : ?>
			<!-- Connected State -->
			<div class="blogbotz-card blogbotz-connected">
				<div class="blogbotz-status">
					<span class="status-indicator connected"></span>
					<span class="status-text"><?php esc_html_e( 'Connected to BlogBotz', 'blogbotz-ai-blog-automation' ); ?></span>
				</div>

				<div class="blogbotz-connection-info">
					<div class="info-row">
						<span class="info-label"><?php esc_html_e( 'Connected Account:', 'blogbotz-ai-blog-automation' ); ?></span>
						<span class="info-value"><?php echo esc_html( $blogbotz_connection_data['user_email'] ?? '' ); ?></span>
					</div>
					<div class="info-row">
						<span class="info-label"><?php esc_html_e( 'Connected Since:', 'blogbotz-ai-blog-automation' ); ?></span>
						<span class="info-value"><?php echo esc_html( isset( $blogbotz_connection_data['connected_at'] ) ? date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $blogbotz_connection_data['connected_at'] ) ) : '' ); ?></span>
					</div>
					<div class="info-row">
						<span class="info-label"><?php esc_html_e( 'Site URL:', 'blogbotz-ai-blog-automation' ); ?></span>
						<span class="info-value"><?php echo esc_html( get_site_url() ); ?></span>
					</div>
				</div>

				<div class="blogbotz-actions">
					<button type="button" id="blogbotz-open-dashboard" class="button button-primary button-hero">
						<span class="dashicons dashicons-external"></span>
						<span class="btn-text"><?php esc_html_e( 'Open BlogBotz Dashboard', 'blogbotz-ai-blog-automation' ); ?></span>
						<span class="btn-loading" style="display: none;">
							<span class="spinner is-active" style="float: none; margin: 0;"></span>
							<?php esc_html_e( 'Opening...', 'blogbotz-ai-blog-automation' ); ?>
						</span>
					</button>
					<button type="button" id="blogbotz-disconnect" class="button button-secondary">
						<?php esc_html_e( 'Disconnect', 'blogbotz-ai-blog-automation' ); ?>
					</button>
				</div>

				<div id="blogbotz-dashboard-error" class="blogbotz-error-box" style="display: none;">
					<p class="error-message"></p>
				</div>
			</div>

			<!-- Features Section -->
			<div class="blogbotz-features">
				<h2><?php esc_html_e( 'What BlogBotz Can Do', 'blogbotz-ai-blog-automation' ); ?></h2>
				<div class="features-grid">
					<div class="feature-card">
						<span class="dashicons dashicons-edit-large"></span>
						<h3><?php esc_html_e( 'Auto-Generate Content', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'AI writes SEO-optimized blog posts based on trending keywords in your niche.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
					<div class="feature-card">
						<span class="dashicons dashicons-calendar-alt"></span>
						<h3><?php esc_html_e( 'Scheduled Publishing', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'Posts are automatically published according to your schedule.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
					<div class="feature-card">
						<span class="dashicons dashicons-admin-links"></span>
						<h3><?php esc_html_e( 'Smart Internal Linking', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'Automatically adds relevant internal links to boost SEO.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
					<div class="feature-card">
						<span class="dashicons dashicons-cart"></span>
						<h3><?php esc_html_e( 'Product Integration', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'For WooCommerce sites, includes product recommendations in posts.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
				</div>
			</div>

		<?php else : ?>
			<!-- Not Connected State -->
			<div class="blogbotz-card blogbotz-not-connected">
				<div class="blogbotz-hero">
					<h2><?php esc_html_e( 'Connect Your Site to BlogBotz', 'blogbotz-ai-blog-automation' ); ?></h2>
					<p><?php esc_html_e( 'Automate your blog with AI-generated, SEO-optimized content. Connect your WordPress site to get started.', 'blogbotz-ai-blog-automation' ); ?></p>

					<button type="button" id="blogbotz-easy-connect" class="blogbotz-connect-btn">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M13.19 8.688a4.5 4.5 0 011.242 7.244l-4.5 4.5a4.5 4.5 0 01-6.364-6.364l1.757-1.757m13.35-.622l1.757-1.757a4.5 4.5 0 00-6.364-6.364l-4.5 4.5a4.5 4.5 0 001.242 7.244" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						</svg>
						<span class="btn-text"><?php esc_html_e( 'Connect to BlogBotz', 'blogbotz-ai-blog-automation' ); ?></span>
						<span class="btn-loading" style="display: none;">
							<span class="spinner is-active" style="float: none; margin: 0;"></span>
							<?php esc_html_e( 'Connecting...', 'blogbotz-ai-blog-automation' ); ?>
						</span>
					</button>

					<div id="blogbotz-connect-error" class="blogbotz-error-box" style="display: none;">
						<p class="error-message"></p>
					</div>

					<p class="blogbotz-note">
						<?php esc_html_e( 'One-click connection - no registration required!', 'blogbotz-ai-blog-automation' ); ?>
					</p>
				</div>

				<div class="blogbotz-benefits">
					<h3><?php esc_html_e( 'Why Connect to BlogBotz?', 'blogbotz-ai-blog-automation' ); ?></h3>
					<ul>
						<li>
							<span class="dashicons dashicons-yes-alt"></span>
							<?php esc_html_e( 'AI-powered content generation tailored to your niche', 'blogbotz-ai-blog-automation' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt"></span>
							<?php esc_html_e( 'Automatic SEO optimization and keyword targeting', 'blogbotz-ai-blog-automation' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt"></span>
							<?php esc_html_e( 'One-click publishing to your WordPress site', 'blogbotz-ai-blog-automation' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt"></span>
							<?php esc_html_e( 'Smart internal linking for better SEO', 'blogbotz-ai-blog-automation' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt"></span>
							<?php esc_html_e( 'WooCommerce product integration (for e-commerce sites)', 'blogbotz-ai-blog-automation' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt"></span>
							<?php esc_html_e( 'Multi-language support', 'blogbotz-ai-blog-automation' ); ?>
						</li>
					</ul>
				</div>
			</div>

			<!-- How It Works -->
			<div class="blogbotz-how-it-works">
				<h2><?php esc_html_e( 'How It Works', 'blogbotz-ai-blog-automation' ); ?></h2>
				<div class="steps-grid">
					<div class="step">
						<div class="step-number">1</div>
						<h3><?php esc_html_e( 'Connect', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'Click the connect button above to link your WordPress site with BlogBotz.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
					<div class="step">
						<div class="step-number">2</div>
						<h3><?php esc_html_e( 'Configure', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'Set up your content categories, posting schedule, and preferences.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
					<div class="step">
						<div class="step-number">3</div>
						<h3><?php esc_html_e( 'Automate', 'blogbotz-ai-blog-automation' ); ?></h3>
						<p><?php esc_html_e( 'Sit back as BlogBotz generates and publishes quality content automatically.', 'blogbotz-ai-blog-automation' ); ?></p>
					</div>
				</div>
			</div>
		<?php endif; ?>
	</div>

	<div class="blogbotz-footer">
		<p>
			<?php
			printf(
				/* translators: 1: Plugin version, 2: Opening anchor tag, 3: Closing anchor tag */
				esc_html__( 'BlogBotz v%1$s | Need help? %2$sVisit our documentation%3$s', 'blogbotz-ai-blog-automation' ),
				esc_html( BLOGBOTZ_VERSION ),
				'<a href="' . esc_url( BLOGBOTZ_APP_URL . '/docs' ) . '" target="_blank">',
				'</a>'
			);
			?>
		</p>
	</div>
</div>
