<?php
/**
 * Plugin Name: BlogBotz - AI Blog Automation
 * Plugin URI: https://blogbotz.com/integrations/wordpress
 * Description: Connect your WordPress site to BlogBotz for AI-powered automated blog content generation and publishing.
 * Version: 1.0.5
 * Author: BlogBotz
 * Author URI: https://blogbotz.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: blogbotz-ai-blog-automation
 * Domain Path: /languages
 * Requires at least: 5.6
 * Requires PHP: 7.4
 *
 * @package BlogBotz
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'BLOGBOTZ_VERSION', '1.0.5' );
define( 'BLOGBOTZ_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'BLOGBOTZ_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BLOGBOTZ_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'BLOGBOTZ_APP_URL', 'https://blogbotz.com' );

/**
 * Log a message for debugging purposes.
 * Only logs if WP_DEBUG and WP_DEBUG_LOG are enabled.
 *
 * @param string $message The message to log.
 */
function blogbotz_log( $message ) {
	if ( defined( 'WP_DEBUG' ) && WP_DEBUG && defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG ) {
		// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Intentional debug logging when WP_DEBUG is enabled.
		error_log( $message );
	}
}

// Autoload plugin classes.
require_once BLOGBOTZ_PLUGIN_DIR . 'includes/class-blogbotz.php';

/**
 * Initialize the plugin.
 *
 * @return BlogBotz Plugin instance.
 */
function blogbotz_init() {
	$plugin = BlogBotz::get_instance();
	return $plugin;
}

// Hook into plugins_loaded.
add_action( 'plugins_loaded', 'blogbotz_init', 10 );

// Activation hook.
register_activation_hook( __FILE__, array( 'BlogBotz', 'activate' ) );

// Deactivation hook.
register_deactivation_hook( __FILE__, array( 'BlogBotz', 'deactivate' ) );
