<?php
class BlogPostReadingTime_Shortcode {
    private $core;

    public function __construct( $core ) {
        $this->core = $core;
        add_shortcode( 'bprt_post_reading_time', [ $this, 'render_shortcode' ] );
        add_shortcode( 'bprt_post_listen', [ $this, 'listen_shortcode' ] );
    }

    public function render_shortcode() {
        if ( is_singular() && get_option( 'bprt_display_mode', 'automatic' ) === 'shortcode' ) {
            return $this->core->get_reading_time( get_the_ID() );
        }
        return '';
    }
    
    public function listen_shortcode() {
        if ( is_singular() && get_option( 'bprt_display_mode', 'automatic' ) === 'shortcode' ) {
            return $this->core->get_listen_button( get_the_ID() );
        }
        return '';
    }
}
