<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class BlogPostReadingTime_Settings {

    public function __construct() {
        add_action( 'admin_menu', [ $this, 'add_settings_menu' ] );
        add_action( 'admin_init', [ $this, 'register_settings' ] );
    }

    public function add_settings_menu() {
        add_options_page(
            esc_html__( 'Blog Post Reading Time Settings', 'blog-post-reading-time' ),
            esc_html__( 'Blog Post Reading Time', 'blog-post-reading-time' ),
            'manage_options',
            'post-reading-time-settings',
            [ $this, 'settings_page_html' ]
        );
    }

    public function register_settings() {
        $options = [
            'bprt_display_position' => 'sanitize_text_field',
            'bprt_show_clock_icon' => 'absint',
            'bprt_custom_label' => 'sanitize_text_field',
            'bprt_font_size' => 'absint',
            'bprt_time_postfix' => 'sanitize_text_field',
            'bprt_words_per_minute' => 'absint',
            'bprt_display_mode' => 'sanitize_text_field',
            'bprt_enable_listen' => 'absint',
        ];

        foreach ( $options as $name => $callback ) {
            register_setting( 'bprt_settings_group', $name, [
                'sanitize_callback' => $callback,
            ] );
        }
    }

    public function settings_page_html() {
        ?>
        <div class="wrap">
            <h1><?php echo esc_html__( 'Blog Post Reading Time Settings', 'blog-post-reading-time' ); ?></h1>
            <form method="post" action="options.php">
                <?php settings_fields( 'bprt_settings_group' ); ?>
                <table class="form-table">
                    <tr><th><?php esc_html_e( 'Display Position', 'blog-post-reading-time' ); ?></th>
                        <td><select name="bprt_display_position">
                            <option value="before_content" <?php selected( get_option('bprt_display_position'), 'before_content' ); ?>><?php esc_html_e( 'Before Content', 'blog-post-reading-time' ); ?></option>
                            <option value="after_title" <?php selected( get_option('bprt_display_position'), 'after_title' ); ?>><?php esc_html_e( 'After Title', 'blog-post-reading-time' ); ?></option>
                            <option value="after_featured_image" <?php selected( get_option('bprt_display_position'), 'after_featured_image' ); ?>><?php esc_html_e( 'After Featured Image', 'blog-post-reading-time' ); ?></option>
                        </select>
                        <p class="description"><?php esc_html_e( 'Choose where to display the reading time.', 'blog-post-reading-time' ); ?></p>
                    </td></tr>
                    <tr><th><?php esc_html_e( 'Clock Icon', 'blog-post-reading-time' ); ?></th>
                        <td><input type="checkbox" name="bprt_show_clock_icon" value="1" <?php checked( get_option('bprt_show_clock_icon'), 1 ); ?> /> <?php esc_html_e( 'Show ⏱ icon', 'blog-post-reading-time' ); ?></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Custom Label', 'blog-post-reading-time' ); ?></th>
                        <td><input type="text" name="bprt_custom_label" value="<?php echo esc_attr( get_option('bprt_custom_label', 'Estimated reading time:') ); ?>" /></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Font Size', 'blog-post-reading-time' ); ?></th>
                        <td><input type="number" name="bprt_font_size" value="<?php echo esc_attr( get_option('bprt_font_size', 14) ); ?>" min="10" max="48" /> px</td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Postfix', 'blog-post-reading-time' ); ?></th>
                        <td><input type="text" name="bprt_time_postfix" value="<?php echo esc_attr( get_option('bprt_time_postfix', 'min read') ); ?>" /></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Words Per Minute', 'blog-post-reading-time' ); ?></th>
                        <td><input type="number" name="bprt_words_per_minute" value="<?php echo esc_attr( get_option('bprt_words_per_minute', 200) ); ?>" min="50" max="1000" /></td>
                    </tr>
                    <tr><th><?php esc_html_e( 'Display Mode', 'blog-post-reading-time' ); ?></th>
                        <td><select name="bprt_display_mode">
                            <option value="automatic" <?php selected( get_option('bprt_display_mode'), 'automatic' ); ?>><?php esc_html_e( 'Automatic', 'blog-post-reading-time' ); ?></option>
                            <option value="shortcode" <?php selected( get_option('bprt_display_mode'), 'shortcode' ); ?>><?php esc_html_e( 'Shortcode Only', 'blog-post-reading-time' ); ?></option>
                        </select></td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e( 'Enable Listen Feature', 'blog-post-reading-time' ); ?></th>
                        <td>
                            <input type="checkbox" name="bprt_enable_listen" value="1" <?php checked( get_option('bprt_enable_listen'), 1 ); ?> />
                            <?php esc_html_e( 'Show "Listen to this Article" button on posts', 'blog-post-reading-time' ); ?>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }
}
