<?php
/**
 * Plugin Name: Blog Post Reading Time
 * Description: Displays estimated reading time on posts.
 * Version: 2.1
 * Author: rathodnaren
 * Author URI: https://github.com/rathodnarendra2024
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: blog-post-reading-time
 * Tags: reading time, estimated read time, post reading time, blog tools
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'BPRT_PATH', plugin_dir_path( __FILE__ ) );
define( 'BPRT_URL', plugin_dir_url( __FILE__ ) );

require_once BPRT_PATH . 'includes/class-bprt-enqueue.php';
require_once BPRT_PATH . 'includes/class-bprt-core.php';
require_once BPRT_PATH . 'includes/class-bprt-settings.php';
require_once BPRT_PATH . 'includes/class-bprt-shortcode.php';

add_action( 'plugins_loaded', function() {
    $core = new BlogPostReadingTime_Core();
    new BlogPostReadingTime_Enqueue();
    new BlogPostReadingTime_Settings();
    new BlogPostReadingTime_Shortcode( $core );
});
