<?php
// $id => ID for referencing table from code or css
// $table_name => table name from database, if table_name is used query attribute is disabled
// $query => name of user defined query
// $field => name of the field
// $rowid => row id from the field, if empty we can use POST or GET variable bdds_view_field_{id}
// $key => id of a record we want to retrive return by query

    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_ADMIN_CLASSES_DIR . "tables/BDDS_Column.php";
    require_once BDDS_PLUGIN_HELPERS_DIR . "BDDS_Formatter.php";

    global $wpdb;
    global $bdds_table_fields, $bdds_table_aliases;
    global $bdds_queried_data, $bdds_attachment_id_fields;

    $wp_tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";

    if(isset($query) && !empty($query)) {
        $key = isset( $atts["key"] ) ? $atts["key"] : null;
        $fields = isset($bdds_table_fields) ? $bdds_table_fields : array();
        $aliases = isset($bdds_table_aliases) ? $bdds_table_aliases : array();

        foreach($fields as $table_field) {
            $table_field = explode('.', $table_field);
            $table_name = isset($table_field[0]) ? $table_field[0] : '';
            $field_name = isset($table_field[1]) ? $table_field[1] : '';
            $aliases_key = "field_alias_$table_name" . "_$field_name";

            if( $field == $field_name && $aliases[$aliases_key] != $table_name . "_$field" ) $field = "$aliases[$aliases_key]";

        }

        $data = $bdds_queried_data[$key]->{$field};

        // If the field contains an attachment ID, format it accordingly
        if (in_array($field, $bdds_attachment_id_fields)) {
            $data = BDDS_Formatter::get_attachment_html($data);

            echo $data;
            return;
        }

    } else {
        $table_name   = $wp_tables_prefix . strtolower( str_replace( ' ', '_', $table_name ) );

        /* Get field value and field (column) type from the DB, in order to
            determine whether the field contains an attachment;
            $result example: stdClass Object (
                [field_value] => 'zip 1'
                [field_type] => 'longtext'
            ) */
        $result = $wpdb->get_row($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
            "SELECT tbl.`$field` as field_value, clmns.DATA_TYPE as field_type
                FROM `$table_name` tbl
                JOIN information_schema.columns clmns
                ON clmns.TABLE_NAME = %s AND clmns.COLUMN_NAME = %s
                WHERE tbl.`id` = %d AND tbl.`deleted_at` IS NULL",
            $table_name,
            $field,
            $rowid
        )); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared

        $data = $result->field_value;
        $field_type = $result->field_type ?: '';

        // If the field contains an attachment ID, format it accordingly
        if (BDDS_Column::isAttachmentIdType($field_type)) {
            $data = BDDS_Formatter::get_attachment_html($data);

            echo $data;
            return;
        }
    }

    echo esc_html($data);