<?php
// defined variables from function
// $id => ID for referencing table from code or css
// $table_name => table name from database, if table_name is used query attribute is disabled
// $query
// $fields => names of fields that should be displayed in table etc. name,lastname,age
// $fieldnames => alias names for fields displayed in table
// $sort => name of columns that are going to have sort options and sets default sort order etc. name_field:asc
// $search => name of columns where search would be performed on
// $rownumbers => true or false, if true show number of rows in first column
// $paginate => number of table rows in table, if not defined all rows are displayed

    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_ADMIN_CLASSES_DIR . "Query.php";
    require_once BDDS_PLUGIN_ADMIN_CLASSES_DIR . "tables/BDDS_Column.php";
    require_once BDDS_PLUGIN_HELPERS_DIR . "BDDS_Formatter.php";
    require_once BDDS_PLUGIN_SERVICES_DIR . "BDDS_QueryService.php";

    global $wpdb;
    $table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . strtolower( str_replace( ' ', '_', $table_name ) );
    $queries_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries";
    $table_structure_result;
    $query_object = null;
    $attachment_id_fields = [];

    if($table_name != $wpdb->prefix . BDDS_PLUGIN_PREFIX . '_') {
        $table_structure_result = $wpdb->get_results( $wpdb->prepare( "DESC `$table_name`" ), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    }

    if(!empty($query)) {
        $query_object = BDDS_QueryService::get_by_name($query);
        $attachment_id_fields = $query_object->getAttachmentIdAliasesOrFields();
    }

    // if shortcode does not have $fields attribute, we need to display all column's to the user
    if( $fields == null ) {
        if(!empty($query)) {
            $fields_arr = $query_object->getFieldsObject()->getFields();

            foreach($fields_arr as $field) {
                $fields .= end(explode('.', $field)) . ',';

            }

        } else {
            foreach( $table_structure_result as $table_structure ) {
                $fields .= $table_structure->Field . ",";

            }
        }

        $fields = rtrim($fields, ',');
    }

    $requested_column_names = array();

    // array of columns to display
    $requested_column_names = explode( ',', $fields );

    $sort_fields            = explode( ',', $sort );
    $sort_field_name        = array();
    $sort_types             = array();

    foreach( $sort_fields as  $field ) {
        $field = explode( ':', $field );
        array_push( $sort_field_name, $field[0] );
        if( isset( $field[1] ) ) {
            array_push( $sort_types, $field[1] );
        }

    }

    $fieldnames_array = explode( ',', $fieldnames );

    // add id to fields so we can get id of each row from query to display it as Row Number
    if ( isset( $rownumbers ) ) $fields = "id," . $fields;

?>

<?php
    // if search value is set we create new array that we iterate trough later to display data
    if ( isset( $_POST[ 'search' ] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Missing
        $value_to_search         = sanitize_text_field(wp_unslash($_POST[ 'search' ])); // phpcs:ignore WordPress.Security.NonceVerification.Missing
        $search_fields           = $search;
        $search_fields_array     = explode( ',', $search );
        $fields_values_to_search = '';
        $fields_values = array();
        $raw_query = isset($query)
                   ? $wpdb->get_var($wpdb->prepare("SELECT query FROM `$queries_table_name` WHERE query_name=%s", $query)) // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                   : null;

        foreach( $search_fields_array as $search_field ) {
            $fields_values_to_search .= is_numeric( $value_to_search )
                                      ? '(' . $search_field . " = %d ) OR "
                                      : '(' . $search_field . " LIKE %s ) OR ";

            array_push($fields_values, sanitize_text_field(wp_unslash($value_to_search)));

        }
        $fields_values_to_search = rtrim( $fields_values_to_search, " OR " );

        if( isset($query) ) {
            $fields = explode(',', $fields);
            $fields = map_deep($fields, 'sanitize_text_field');
            $fields = implode(',', $fields);

            /* Placeholders are add to $fields_values_to_search variable */
            $searched_values = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT $fields FROM ($raw_query) AS `alias` WHERE $fields_values_to_search;", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.PreparedSQLPlaceholders.UnfinishedPrepare
                    $fields_values
                )
            );

        } else {
            $fields = explode(',', $fields);
            $fields = map_deep($fields, 'sanitize_text_field');
            $fields = implode(',', $fields);

            /* Placeholders are add to $fields_values_to_search variable */
            $searched_values = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT $fields FROM `$table_name` WHERE $fields_values_to_search AND `deleted_at` IS NULL;", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.PreparedSQLPlaceholders.UnfinishedPrepare
                    $fields_values
                )
            );

        }
    }
?>

<table id="<?php echo esc_attr($table_id); ?>" class="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-view-table sortable">
    <thead id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-header" class="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-header">
        <tr>
            <?php
                echo ( $rownumbers == 'true' ) ? "<th>Row<br>number</th>" : '';

                if(!empty($query)) {
                    $table_structure_result = explode(',', $fields);
                }
                // show column names in table header & set $attachment_id_fields
                foreach( $table_structure_result as $table_structure ) {
                    // Displaying table or query?
                    if (empty($query)) {
                        // Table
                        $column_name = $table_structure->Field;
                        if (BDDS_Column::isAttachmentIdType($table_structure->Type)) {
                            $attachment_id_fields[] = $column_name;
                        }
                    } else {
                        // Query
                        $column_name = $table_structure;
                    }

                    if ( in_array( $column_name, $requested_column_names ) && in_array( $column_name, $sort_field_name ) ) {
                        $column_name_index = array_search($column_name, $requested_column_names);
                        $sort_url          = add_query_arg( array('sort' => 'desc', 'field' => $column_name, 'table_id' => $table_id ) ) ;

                        if( isset( $_GET[ 'sort' ] ) && $_GET[ 'sort' ] == "desc" ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            $sort_url = add_query_arg( array(
                                'sort' => 'asc',
                                'table_id' => $table_id,
                                'field' => $column_name
                            ) ) ;
                        } else if( isset( $_GET[ 'sort' ] ) && $_GET[ 'sort' ] == "asc" ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                            $sort_url =  add_query_arg( array(
                                'sort' => 'desc',
                                'table_id' => $table_id,
                                'field' => $column_name
                            ) ) ;
                        }

                        if ( isset( $fieldnames ) ) {
                            $column_name = $fieldnames_array[$column_name_index];

                            echo "<th scope='col'>";
                                echo "<a href='" . esc_url($sort_url) . "'>";
                                    echo "<div>" . esc_html($column_name);
                                    echo "<span class='sorting-arrows' style='display:inline-block'>";
                                        echo '<span class="up-arrow" style="display:block;"></span>';
                                        echo '<span class="down-arrow" style="display:block;"></span>';
                                    echo "</div>";
                                echo "</a>";
                            echo "</th>";

                        } else {
                            echo "<th scope='col'>";
                                echo "<a href='" . esc_url($sort_url) . "'>";
                                    echo "<div>" . esc_html($column_name);
                                    echo "<span class='sorting-arrows' style='display:inline-block'>";
                                        echo '<span class="up-arrow" style="display:block;"></span>';
                                        echo '<span class="down-arrow" style="display:block;"></span>';
                                    echo "</div>";
                                echo "</a>";
                            echo "</th>";
                        }

                    } else if ( in_array( $column_name, $requested_column_names ) ) {
                        $column_name_index = array_search($column_name, $requested_column_names);

                        if( isset( $fieldnames )) {
                            $column_name = isset($fieldnames_array[$column_name_index]) ? $fieldnames_array[$column_name_index] : $column_name;
                            echo "<th>" . esc_html($column_name) . "</th>";

                        }else {
                            echo "<th>" . esc_html($column_name) . "</th>";
                        }
                    }
                }
            ?>
        </tr>
    </thead>

    <tbody id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-body" class="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-body">
        <?php
            // show records from table

            if(isset($query)) {
                $select_query = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare("SELECT query FROM `$queries_table_name` WHERE query_name=%s", $query) // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                );

                $table_name    = '';
                $raw_query     = $select_query;
            }

            $fields_array    = explode( ',', $fields );
            $total_records   = isset($query) ? $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM ($raw_query) AS `alias`;")) // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                             : $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM `$table_name` WHERE `deleted_at` IS NULL;" ) ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            $paginate        = !empty( $paginate ) ? $paginate : $total_records;
            $per_page_number = !empty( $paginate ) ? $paginate : 1;
            $total_pages     = ceil( $total_records / $per_page_number );
            $order_field     = isset( $_GET[ 'field' ] )
                ? sanitize_text_field(wp_unslash($_GET[ 'field' ])) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $order           = isset( $_GET[ 'sort' ] )
                ? sanitize_text_field(wp_unslash($_GET[ 'sort' ])) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $page;
            $table_data;

            $page = (
                isset($_GET[ "curr_page" ]) &&
                isset($_GET["pag_table_id"]) &&
                $_GET["pag_table_id"] == $table_id
            ) ? sanitize_text_field(wp_unslash($_GET[ "curr_page" ])) : 1; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

            $start_from = ( $page - 1 ) * $per_page_number;

            // paginate is set so we use query with LIMIT to select specific data
            if ( $paginate > 0 ) {
                if( isset($_GET["table_id"]) && $table_id == $_GET["table_id"] ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended

                    foreach( $table_structure_result as $table_structure ) {
                        $field = empty($query) ? $table_structure->Field : $table_structure;

                        if($order_field == $field) {
                            $order_field = $field;
                        }

                    }

                    if (isset($query)) {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT * FROM ($raw_query) as `alias` ORDER BY $order_field $order LIMIT %d, %d;", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                array($start_from, $per_page_number)
                            )
                        );
                    } else {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT $fields FROM `$table_name` WHERE `deleted_at` IS NULL ORDER BY $order_field $order LIMIT %d, %d;", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                array($start_from, $per_page_number)
                            )
                        );
                    }

                } else {

                    if (isset($query)) {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT * FROM ($raw_query) as `alias` LIMIT %d, %d;", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                array($start_from, $per_page_number)
                            )
                        );
                    } else {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT $fields FROM `$table_name` WHERE `deleted_at` IS NULL LIMIT %d, %d;", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                array($start_from, $per_page_number)
                            )
                        );
                    }
                }

            } else {
                if( isset($_GET["table_id"]) && $table_id == $_GET["table_id"] ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    foreach( $table_structure_result as $table_structure ) {
                        if( $order_field == $table_structure->Field ) {
                            $order_field = $table_structure->Field;
                        }
                    }

                    if (isset($query)) {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT $fields FROM ($raw_query) as `alias` ORDER BY $order_field $order;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            )
                        );
                    } else {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT $fields FROM `$table_name` WHERE `deleted_at` IS NULL ORDER BY $order_field $order;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            )
                        );
                    }
                } else {
                    if (isset($query)) {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT $fields FROM ($raw_query) as `alias`;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            )
                        );
                    } else {
                        $table_data = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                            $wpdb->prepare(
                                "SELECT $fields FROM `$table_name` WHERE `deleted_at` IS NULL;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            )
                        );
                    }
                }

            }

            if(isset($query)) {
                $conditions_object = $wpdb->get_results($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    "SELECT query_object FROM `$queries_table_name` WHERE query_name=%s", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                    $query
                ));
                if (isset($conditions_object[0])) {
                    $conditions_object = unserialize($conditions_object[0]->query_object);
                    $aliases = $conditions_object->getFieldsObject()->getAliases();
                    $tables = $conditions_object->getTablesObject()->getTables();

                    if(count($aliases) > 0) {
                        $fields_array = array();
                        foreach($tables as $table) {
                            $table_name = str_replace($wpdb->prefix . BDDS_PLUGIN_PREFIX . '_', '', $table);
                            foreach($aliases as $key=>$alias) {
                                $field_name = str_replace("field_alias_", '', $key);

                                if($field_name != $alias) {
                                    array_push($fields_array, $alias);

                                } else array_push($fields_array, str_replace($table_name . '_', '', $field_name));
                            }
                        }
                    }
                }

            }

            // if search value is set we need to display different data in table so we loop trough array with searched values
            if (
                isset($_POST[ 'search' ]) &&
                isset($_POST["search_table_id"]) &&
                $_POST["search_table_id"] == $table_id
            ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                for ( $i = 0; $i < count( $searched_values ); $i++ ) {
                    echo "<tr>";
                        for( $j = 0; $j < count( $fields_array ); $j++ ) {
                            $field_name = $fields_array[$j];

                            echo "<td>". esc_html($searched_values[$i]->$field_name) . "</td>";
                        }
                    echo "</tr>";
                }

            } else {
                // search value is not defined so we iterate trough original array
                for ( $i = 0; $i < count( $table_data ); $i++ ) {
                    echo "<tr>";
                        for( $j = 0; $j < count( $fields_array ); $j++ ) {
                            $field_name = $fields_array[$j];

                            /* If the field contains attachment ID, display file URL
                                (and thumbnail) */
                            if (in_array($field_name, $attachment_id_fields)) {
                                $attachment_id = $table_data[$i]->$field_name;
                                $td_content_html = BDDS_Formatter::get_attachment_html($attachment_id);
                            } else {
                                $td_content_html = esc_html($table_data[$i]->$field_name);
                            }

                            if ( in_array( $field_name, $sort_field_name ) ) {
                                echo "<td class='table-data-sort'>" . $td_content_html . "</td>";
                            } else {
                                echo "<td>" . $td_content_html . "</td>";
                            }
                        }
                    echo "</tr>";
                }
            }
        ?>
    </tbody>
</table>

<!-- Links for pagination pages -->
<div id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-pagination-container">
    <?php
        if (
            $paginate > 0 && (
                !isset($_GET["search"]) ||
                isset($_POST["search_table_id"]) && $_POST["search_table_id"] != $table_id
            )
        ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
            $pagLink = "";

            if ( $page >=2 ) {
                echo "<a href=". esc_url( add_query_arg( array('curr_page' => ($page - 1), "pag_table_id" =>$table_id  ) ) ) . ">Prev</a>";
            }

            for ( $i = 1; $i <= $total_pages; $i++ ) {
                if ( $i == $page ) {
                    $pagLink .= "<a href=". esc_url( add_query_arg( array( 'curr_page' => $i, "pag_table_id" => $table_id ) ) ) . " class='active'>$i</a>";
                } else {
                    $pagLink .= "<a href=". esc_url( add_query_arg( array('curr_page' => $i, "pag_table_id" => $table_id) ) ) . ">$i</a>";
                }
            }

            // here we echo multiple anchor elements, so we cannot escape all anchors
            echo $pagLink; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

            if ( $page < $total_pages ) {
                echo "<a href=". esc_url( add_query_arg( array('curr_page' => ($page + 1), "pag_table_id" => $table_id) ) ) . ">Next</a>";
            }
        }
    ?>
</div>

<form method="post">
    <div id="search-container">
        <input type="text" name="search"  placeholder="Search">
        <input type="submit" class="" value="Search">
        <input type="hidden" name="search_table_id" value="<?php echo esc_attr($table_id); ?>">
    </div>
</form>
