<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin" . '/' . BDDS_PLUGIN_SLUG . "-admin.php"; 
    require_once BDDS_PLUGIN_DIR . "admin/classes/BDDS_Helpers.php"; 
    require_once ABSPATH . 'wp-admin/includes/file.php';
?>
<h3><?php echo esc_html($table_name); ?></h3>

<?php 
    global $wpdb;
    global $wp;    
    global $bdds_table_names;
    
    $table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_". $table_name; 
    $table_structure_result = $wpdb->get_results( $wpdb->prepare( "DESC `$table_name`" ), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $enum_values_str = '';
    $is_valid = '';
    $break = 0;
    $table = '';
    $bit_columns = array();
    $attachment_tables = array();

    if ( isset( $_POST[ "submit_data" ] ) && check_admin_referer("bdds-form-view-nonce") ) {
        $post_array       = map_deep($_POST, 'sanitize_text_field' );
        $values_to_insert = array();
        $values_to_edit   = array();
        $database_name    = $wpdb->dbname;

        foreach( $post_array as $key=>$post_value ) {
            if( $key == "id" || $key == "created_at" || $key == "updated_at" || $key == "deleted_at" ) continue;
    
            // insert new value
            if( str_contains( $key, BDDS_PLUGIN_PREFIX . "_field_" ) ) {
                $field_name = str_replace( BDDS_PLUGIN_PREFIX . "_field_", '', $key);
                            
                if ( !empty( $post_value ) ) {
                    // new values are saved as key values in array, later array goes to $wpdb->insert method
                    foreach($bdds_table_names as $bdds_table_name) {
                        $field_exists = $wpdb->get_results($wpdb->prepare("SHOW COLUMNS FROM `$bdds_table_name` LIKE %s", $field_name)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared	
                        if(!empty($field_exists)) $table = $bdds_table_name;
                    }

                    $field_type_sql = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        "SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME=%s AND COLUMN_NAME=%s AND TABLE_SCHEMA=%s", 
                        array($table, $field_name, $database_name)
                    ));
                    
                    $field_type = BDDS_Helpers::getColumnTypeByName($field_type_sql);
                    $is_valid = BDDS_Helpers::validateData($field_type, $post_value, $field_name);

                    if(str_starts_with($field_type_sql, "bit")) array_push($bit_columns, $field_name);
                    
                    if($is_valid == "valid") {
                        $values_to_insert[$field_name] = $post_value;
                    } else {
                        $break = 1;
                        if($table == $table_name) echo "<div style='color:red;'>" . esc_html($is_valid) . "</div>";
                        break;
                    }
                    
                }
    
            // update existing column with a new value
            } else if( str_contains( $key, BDDS_PLUGIN_PREFIX . "_form_field_" ) ) {
                global $bdds_table_names;
                
                $field_name  = str_replace( BDDS_PLUGIN_PREFIX . "_form_field_", '', $key);
                $field_exists;
                $field       = explode( '_', $field_name );
                $column_id   = $field[0];
                $column_name = str_replace($field[0] . '_', '', $field_name); //$field[1]
                $table;
                
                foreach($bdds_table_names as $bdds_table_name) {
                    $field_exists = $wpdb->get_results($wpdb->prepare("SHOW COLUMNS FROM `$bdds_table_name` LIKE %s", $column_name)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                    if(!empty($field_exists)) $table = $bdds_table_name;
                }
    
                $column_type = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    "SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = %s;", 
                    array($database_name, $table, $column_name)
                ));

                $sql_column_type = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    "SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME=%s AND COLUMN_NAME=%s AND TABLE_SCHEMA=%s", 
                    array($table, $column_name, $database_name)
                ));

                $field_type = BDDS_Helpers::getColumnTypeByName($sql_column_type);
                
                if ( !empty( $post_value ) ) {
                    switch( $column_type )
                    {
                        case "datetime":
                            $date = str_replace('T', ' ', $post_value);
                            $is_valid = BDDS_Helpers::validateData($field_type, $date, $field_name);
                            
                            if($is_valid == "valid") {
                                $post_value = $post_value;
                            } else {
                                $break = 1;
                                if($table == $table_name) echo "<div style='color:red;'>" . esc_html($is_valid) . "</div>";
                                break;
                            }

                            break;
    
                        case "bit":
                            $bit = ($post_value == "Yes") ? 1 : 0;
                            $wpdb->query( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                $wpdb->prepare(
                                    "UPDATE `$table_name` SET $column_name = $bit WHERE id=%d", $column_id // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                )
                            );
                            break;
                            
                        default:
                            $is_valid = BDDS_Helpers::validateData($field_type, $post_value, $column_name);
                            if($is_valid == "valid") {
                                $post_value = $post_value;
                            } else {
                                $break = 1;
                                if($table == $table_name) echo "<div style='color:red;'>" . esc_html($is_valid) . "</div>";
                                break;
                            }
    
                    }
                }
    
                if( $column_type != "bit" && !empty($post_value) && $table == $table_name) {
                    $wpdb->update( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        $table_name,
                        array( 
                            $column_name => $post_value
                        ),
                        array(
                            'id' => $column_id,
                            'deleted_at' => NULL 
                        )
                    );
                }
            }
        }
        
        // Handles file uploads
        if (isset( $_POST[ "submit_data" ] ) && isset($_FILES)) {
            foreach($_FILES as $file) {
                $upload = wp_handle_upload(
                    $file,
                    array( 'test_form' => false)
                );

                if ( !empty($upload['error']) ) {
                    wp_die( esc_html($upload['error']) );
                }
                
                $attachment_id = wp_insert_attachment(
                    array(
                        'guid'           => $upload['url'],
                        'post_mime_type' => $upload['type'],
                        'post_title'     => basename($upload['file']),
                        'post_content'   => '',
                        'post_status'    => 'inherit',
                    ),
                    $upload['file']
                );

                if ( is_wp_error($attachment_id) || !$attachment_id ) {
                    wp_die("Upload error!");
                }

                require_once ABSPATH . "wp-admin/includes/image.php";

                wp_update_attachment_metadata(
                    $attachment_id,
                    wp_generate_attachment_metadata( $attachment_id, $upload["file"] )
                );
            }
        }

        if($break == 0) {
            // Insert values into table if no error occurred
            $wpdb->insert( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
                $table_name, 
                $values_to_insert 
            );

            // Little hack to insert value to a column of BIT type
            if(!empty($bit_columns)) {
                foreach($bit_columns as $bit_column) {
                    $inserted_row_id = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        $wpdb->prepare(
                            "SELECT `id` FROM `$table_name` ORDER BY ID DESC LIMIT 1;" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                        )
                    );
                    $bit_value = isset($values_to_insert[$bit_column]) ? $values_to_insert[$bit_column] : null;
                    $bit = ($bit_value == "Yes") ? 1 : 0;
                    // We need to get newly inserted row and update its bit column to a bit value.
                    $wpdb->query( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        $wpdb->prepare(
                            "UPDATE `$table_name` SET $bit_column = $bit WHERE id=%d", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            $inserted_row_id
                        )
                    );
                }
            }
        } 
    }

?>

<form method="post" action="" id="<?php echo esc_attr($form_id); ?>" enctype="multipart/form-data">