<?php 
// $id => ID for referencing table from code or css
// $field_name => field where we insert data
// $allow_edit => if set to true, user can edit values from fields 
// $required => if form filed is required

if ( ! defined( 'ABSPATH' ) ) exit;

global $wpdb;
global $bdds_table_names;

$database_name = $wpdb->dbname;
$column_name   = $field_name;

foreach($bdds_table_names as $bdds_table_name) {
    $types = $wpdb->get_results($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        "SELECT DATA_TYPE,COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = %s;",
        array($database_name, $bdds_table_name, $column_name)
    ));

    $is_null = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        "SELECT IS_NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = %s;",
        array($database_name, $bdds_table_name, $column_name)
    ));

    $field_type = isset($types[0]->DATA_TYPE) ? $types[0]->DATA_TYPE : null;
    $column_type_with_length = isset($types[0]->COLUMN_TYPE) ? $types[0]->COLUMN_TYPE : null;
    $table_name = null;
    if($field_type == "enum" || $column_type_with_length == "varchar(100)") $table_name = $bdds_table_name;
}

$input_name = ($allow_edit) ? BDDS_PLUGIN_PREFIX . "_form_field_$id" . "_$field_name" : BDDS_PLUGIN_PREFIX . "_field_$field_name";
$required   = ($is_null == "YES" || $required == "true") ? "required" : '';

?>

<label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>_form_field_<?php echo esc_attr($id); ?>">
    <?php echo esc_html($field_name); ?>
</label>
<?php 
    switch( $field_type )
    {
        case "datetime":
            echo "<input type='datetime-local' name='" . esc_attr($input_name) . "' id='" . esc_attr(BDDS_PLUGIN_PREFIX) . "_form_field_" . esc_attr($id) . "' " . esc_attr($required) . ">";
            break;

        case "bit":
            echo "<select name='" . esc_attr($input_name) . "' id='" . esc_attr(BDDS_PLUGIN_PREFIX) . "_form_field_" . esc_attr($id) . "' " . esc_attr($required) . ">";
                echo "<option value='Yes'>Yes</option>";
                echo "<option value='No'>No</option>";
            echo "<select>";
            break;

        case "longtext":
            $content = '';
            $custom_editor_id = BDDS_PLUGIN_PREFIX . "_form_field_$id" . "_$field_name";
            $custom_editor_name = $input_name;
            $args = array(
                'media_buttons' => false,
                'textarea_name' => $custom_editor_name,
                'quicktags' => false,
                'tinymce' => array(
                    'toolbar1'  => 'bold,italic,underline,separator,alignleft,aligncenter,alignright,separator,link,unlink,undo,redo',
                    'toolbar2'  => '',
                    'toolbar3'  => ''
                )
            );
            wp_editor($content, $custom_editor_id, $args);
            break;

        case "mediumtext":
            $content = '';
            $custom_editor_id = BDDS_PLUGIN_PREFIX . "_form_field_$id" . "_$field_name";
            $custom_editor_name = $input_name;
            $args = array(
                'media_buttons' => false,
                'textarea_name' => $custom_editor_name,
                'quicktags' => false,
                'tinymce' => array(
                    'toolbar1'  => 'bold,italic,underline,separator,alignleft,aligncenter,alignright,separator,link,unlink,undo,redo',
                    'toolbar2'  => '',
                    'toolbar3'  => ''
                )
            );
            wp_editor($content, $custom_editor_id, $args);
            break;

        case "longblob":
            echo "<input type='file' name='" . esc_attr($input_name) . "' id='" . esc_attr(BDDS_PLUGIN_PREFIX) . "_form_field_" . esc_attr($id) . "' " . esc_attr($required) . ">";
            break;

        case "enum":
            // here column type is returned as enum('val','val2','val3'...)
            $column_type = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                "SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s AND COLUMN_NAME = %s;",
                array($database_name, $table_name, $column_name)
            ));
            // replace enum() with empty string so we can get enum values => first 6 characters are enum('
            $enum_values = rtrim(substr($column_type, 6), "')");
            $values      = explode("','", $enum_values);

            // display enum values as options in select element
            echo "<select name='" . esc_attr($input_name) . "' id='" . esc_attr(BDDS_PLUGIN_PREFIX) . "_form_field_" . esc_attr($id) . "' " . esc_attr($required) . ">";
                foreach($values as $value) {
                    echo "<option value='" . esc_attr($value) . "'>" . esc_html($value) . "</option>";
                }
            echo "</select>";              
            break;

        default:               
            if($column_type_with_length == "varchar(100)") {
                $table_metadata_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";
                $metadata_object = $wpdb->get_results($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        "SELECT `metadata` FROM `$table_metadata_name` WHERE table_name = %s", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                        $table_name
                    )
                )[0];
                $metadata = json_decode($metadata_object->metadata);
                $lookup_tables = $metadata->lookup_tables;
                $values = array();
                $column_id = $wpdb->get_var($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    "SELECT ORDINAL_POSITION FROM INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_NAME=%s", $column_name
                ));
                
                foreach($lookup_tables as $lookup) {
                    $column = "column_$column_id";
                    $lookup_arr = isset($lookup) ? explode('.', $lookup->$column) : array();
                    $lookup_table = isset($lookup_arr[0]) ? $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $lookup_arr[0] : null;
                    $lookup_field = isset($lookup_arr[1]) ? $lookup_arr[1] : null;
                    
                    $values = $wpdb->get_results($wpdb->prepare( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                        "SELECT `$lookup_field` FROM `$lookup_table`" // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                    ));
                }
                
                echo "<select name='" . esc_attr($input_name) . "' id='" . esc_attr(BDDS_PLUGIN_PREFIX) . "_form_field_" . esc_attr($id) . "' " . esc_attr($required) . ">";
                    foreach($values as $value) {
                        $column_value = $value->$lookup_field;
                        if(!empty($column_value)) echo "<option value='" . esc_attr($column_value) . "'>" . esc_html($column_value) . "</option>";
                        
                    }
                echo "</select>";
                
            } else {
                echo "<input type='text' name='" . esc_attr($input_name) . "' id='" . esc_attr(BDDS_PLUGIN_PREFIX) . "_form_field_" . esc_attr($id) . "' " . esc_attr($required) . ">";
            }
            
    }

?>
<br>    