<?php
if (!defined('ABSPATH')) {
    exit;
}

require_once BDDS_PLUGIN_ADMIN_CLASSES_DIR . "tables/BDDS_Column.php";

class BDDS_TableStructureService
{
    /**
     * Return an array of names of attachment ID fields from the table structure.
     *
     * @param stdClass[] $table_structure The structure of the table, array of
     *  table column objects (result of DESC query).
     * @return string[] Array of attachment ID field names.
     *
     * @example `
     * $table_structure = $wpdb->get_results($wpdb->prepare("DESC `$table_name`"), 'OBJECT');
     * $attachment_id_fields = BDDS_TableService::get_attachment_id_fields($table_structure);
     */
    public static function get_attachment_id_fields(array $table_structure): array
    {
        $attachment_id_fields = [];

        /* Determine field type for each column,
            collect names of all the fields that contain attachment IDs */
        foreach ($table_structure as $column) {
            if (BDDS_Column::isAttachmentIdType($column->Type)) {
                $attachment_id_fields[] = $column->Field;
            }
        }

        return $attachment_id_fields;
    }
}
