<?php
if (!defined('ABSPATH')) {
    exit;
}

require_once BDDS_PLUGIN_ADMIN_CLASSES_DIR . "Query.php";


class BDDS_QueryService
{
    /**
     * Return the BDDS_Query object by its ID.
     *
     * @param int $query_id The ID of the query.
     * @return BDDS_Query|null The BDDS_Query object or null if not found.
     */
    public static function get_by_id(int $query_id): ?BDDS_Query
    {
        global $wpdb;

        $query_object = null;

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $query_object_serialized = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT `query_object` FROM `" . BDDS_QUERIES_TABLE_NAME . "` WHERE id = %d",
                $query_id
            )
        );

        $query_object = unserialize($query_object_serialized);

        return $query_object;
    }


    /**
     * Return the BDDS_Query object by the query name.
     *
     * @param string $query_name The name of the query.
     * @return BDDS_Query|null The BDDS_Query object or null if not found.
     */
    public static function get_by_name(string $query_name): ?BDDS_Query
    {
        global $wpdb;

        $query_object = null;

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $query_object_serialized = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT `query_object` FROM `" . BDDS_QUERIES_TABLE_NAME . "` WHERE query_name=%s",
                $query_name
            )
        );

        $query_object = unserialize($query_object_serialized);

        return $query_object;
    }
}
