<?php
if (!defined('ABSPATH')) {
    exit;
}

class BDDS_Formatter
{
    /**
     * Generate HTML for displaying an attachment. (Do not escape.)
     *
     * @param int $attachment_id The ID of the attachment
     * @return string HTML markup for the attachment
     */
    public static function get_attachment_html($attachment_id) : string
    {
        $attachment_url = wp_get_attachment_url($attachment_id);
        $attachment_thumb_url = wp_get_attachment_thumb_url($attachment_id);
        $attachment_title = get_the_title($attachment_id);

        $escaped_url = esc_url($attachment_url);
        $escaped_title_attr = esc_attr($attachment_title);


        if (!empty($attachment_thumb_url)) {
            // Attachment has a thumbnail => show it
            $escaped_thumb_url = esc_url($attachment_thumb_url);

            $content = <<<HTML
                <img
                    class="bdds-attachment-thumbnail"
                    src="{$escaped_thumb_url}"
                    alt="{$escaped_title_attr}"
                    data-attachment-id="{$attachment_id}"
                >
            HTML;
        } else {
            $content = esc_html($attachment_title);
        }

        $html = <<<HTML
            <a
                style="text-decoration: none;"
                class="bdds-attachment-link"
                href="{$escaped_url}"
                target="_blank"
                title="{$escaped_title_attr}"
                data-attachment-id="{$attachment_id}"
            >
                {$content}
            </a>
        HTML;

        return $html;
    }
}
