<?php

/*
*   Plugin Name: Black-Desk
*   Description: Plugin for managing database tables
*   Version:     1.3.5
*   Author:      Piktogram Studio
*   License:     GPL v2 or later
*   License URI: https://www.gnu.org/licenses/gpl-2.0.html
*   Text Domain: black-desk
*   Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'BDDS_VERSION', '1.3.5' );
define( 'BDDS_PLUGIN_NAME', 'Black-Desk' );
define( 'BDDS_PLUGIN_SLUG', 'black-desk' );
define( 'BDDS_PLUGIN_PREFIX', 'bdds' );
define( 'BDDS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'BDDS_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
define( 'BDDS_PLUGIN_ADMIN_CLASSES_DIR', BDDS_PLUGIN_DIR . 'admin/classes/' );
define( 'BDDS_PLUGIN_CLASSES_DIR', BDDS_PLUGIN_DIR . 'classes/' );
define( 'BDDS_PLUGIN_HELPERS_DIR', BDDS_PLUGIN_CLASSES_DIR . 'helpers/' );
define( 'BDDS_PLUGIN_SERVICES_DIR', BDDS_PLUGIN_CLASSES_DIR . 'services/' );
// Tables constants
define( 'BDDS_ATTACHMENT_COLUMN_TYPE', 'longblob' );
define( 'BDDS_TABLE_PREFIX', $wpdb->prefix . BDDS_PLUGIN_PREFIX );
define( 'BDDS_ALIAS_PREFIX', 'field_alias_' );
define( 'BDDS_QUERIES_TABLE_NAME', BDDS_TABLE_PREFIX . "_queries" );

require_once BDDS_PLUGIN_DIR . 'admin/' . BDDS_PLUGIN_SLUG . '-admin.php';
require_once BDDS_PLUGIN_DIR . 'public/' . BDDS_PLUGIN_SLUG . '-public.php';
require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

$bdds_admin = new BDDS_Admin( BDDS_PLUGIN_SLUG, BDDS_VERSION );
$bdds_public = new BDDS_Public( BDDS_PLUGIN_SLUG, BDDS_VERSION );

register_activation_hook( __FILE__, 'bdds_create_metadata_table' );
register_activation_hook( __FILE__, 'bdds_create_queries_table' );

/**
 * Creates metadata table.
 *
 * Creates a table that stores metadata about other tables that have been created.
 *
 * @since 1.0.0.
 *
 * @return array Strings containing the results of the various update queries.
 */
function bdds_create_metadata_table () {
    global $wpdb;

    $table_name      = $wpdb->prefix . 'bdds_table_metadata';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        table_name varchar(255) NOT NULL,
        metadata varchar(21570) NULL,
        PRIMARY KEY (id)
    ) $charset_collate";

    dbDelta( $sql );
}

/**
 * Creates queries table.
 *
 * Creates a table that stores information about created queries.
 * Table fields: query_name, query(raw SQL query) and query_object(query saved as an object).
 *
 * @since 1.0.0.
 *
 * @return array Strings containing the results of the various update queries.
 */
function bdds_create_queries_table () {
    global $wpdb;

    $table_name      = $wpdb->prefix . 'bdds_queries';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        query_name varchar(255) NOT NULL,
        query varchar(21570) NULL,
        query_object varchar(21570) NULL,
        PRIMARY KEY (id)
    ) $charset_collate";

    dbDelta( $sql );
}

function bdds_load_translations() {
    load_plugin_textdomain(BDDS_PLUGIN_SLUG, false, BDDS_PLUGIN_SLUG . "/languages");
}
add_action( 'init', 'bdds_load_translations' );

