<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    if ( isset( $_GET['action'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $action = sanitize_text_field(wp_unslash($_GET['action'])); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

        switch ( $action ) {
            case 'view':
                include __DIR__ . '/action_views/view.php';
                break;

            case 'edit':
                include __DIR__ . '/action_views/edit.php';
                break;

            case 'turncate':
                include __DIR__ . '/action_views/turncate.php';
                break;

            case 'delete':
                include __DIR__ . '/action_views/delete.php';
                break;

            case 'change':
                include __DIR__ . '/action_views/change_structure.php';
                break;

            case 'add_column':
                include __DIR__ . '/action_views/add_column.php';
                break;

            case 'drop':
                include __DIR__ . '/action_views/drop_column.php';
                break;

            case 'drop_row':
                include __DIR__ . '/action_views/drop_row.php';
                break;

        }
?>

<?php } else { ?>

<?php
    global $wpdb;
    $tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_%";
    $table_names     = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->prepare("SHOW TABLES LIKE %s", $tables_prefix )
    );
    $add_table_url = wp_nonce_url(
        add_query_arg("page", BDDS_PLUGIN_PREFIX . "-clean-table-slug"),
        BDDS_PLUGIN_PREFIX . "-add-table-nonce"
    );
?>

<div class="wrap">
    <div style="margin-bottom: 1em;">
        <h1 class="wp-heading-inline"><?php esc_html_e('All Tables', 'black-desk'); ?></h1>
        <a
            class="page-title-action"
            href="<?php echo esc_url($add_table_url); ?>"
        >
            <?php esc_html_e('Add table', 'black-desk'); ?>
        </a>
    </div>

    <hr class="wp-header-end">

    <table class="wp-list-table widefat fixed striped table-view-list pages">
        <thead>
            <th scope="col" class="column-title column-primary manage-column">
                <span><?php esc_html_e('Table Name', 'black-desk'); ?></span>
            </th>
            <th><?php esc_html_e('Table Description', 'black-desk'); ?></th>
            <th><?php esc_html_e('Number of rows', 'black-desk'); ?></th>
        </thead>

        <tbody>
            <?php
                if(!empty($table_names)) {
                    foreach ($table_names as $key => $table_n) {
                        foreach ($table_n as $table_name) {
                            $metadata_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";

                            if ( $table_name == $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata" || $table_name == $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries") {
                                continue;
                            }

                            $number_of_rows       = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM `$table_name`" ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                            $table_name_formatted = str_replace("{$wpdb->prefix}" . BDDS_PLUGIN_PREFIX . "_", "", $table_name);

                            $table_description     = $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                $wpdb->prepare(
                                    "SELECT table_comment FROM INFORMATION_SCHEMA.TABLES WHERE table_name=%s;",
                                    $table_name
                                )
                            );

                            $view_url = add_query_arg(array(
                                "action" => "view",
                                "table_name" => $table_name,
                                "_wpnonce" => wp_create_nonce( 'bdds-table-view-nonce' )
                            ));

                            $edit_url = add_query_arg(array(
                                "action" => "edit",
                                "table_name" => $table_name,
                                "_wpnonce" => wp_create_nonce("bdds-edit-nonce")
                            ));

                            $drop_url = add_query_arg(array(
                                "action" => "delete",
                                "table_name" => $table_name,
                                "_wpnonce" => wp_create_nonce("bdds-drop-table-nonce")
                            ));

                            $truncate_url = add_query_arg(array(
                                "action" => "turncate",
                                "table_name" => $table_name,
                                "from_page" => BDDS_PLUGIN_PREFIX . "_show_tables",
                                "_wpnonce" => wp_create_nonce("bdds-truncate-table-nonce")
                            ));

                            echo "<tr>";
                                echo "<td>";
                                    echo "<strong>";
                                        echo "<a class='row-title' href='" . esc_url($view_url) . "'>". esc_html($table_name_formatted) ."</a>";
                                    echo "</strong>";
                                    echo "<div class='row-actions'>";
                                        echo "<a href='" . esc_url($view_url) . "'>" . esc_html__('View', 'black-desk') . "</a> | ";
                                        echo "<a href='" . esc_url($edit_url) . "'>" . esc_html__('Edit', 'black-desk') . "</a> | ";
                                        echo "<a href='" . esc_url($truncate_url) . "' style='color: red;'>" . esc_html__('Truncate', 'black-desk') . "</a> | ";
                                        echo "<a href='" . esc_url($drop_url) . "' style='color: red;'>" . esc_html__('Delete', 'black-desk') . "</a> ";
                                    echo "</div>";
                                echo "</td>";

                                echo "<td>" . esc_html($table_description) . "</td>";
                                echo "<td>" . esc_html($number_of_rows) . "</td>";
                            echo "</tr>";
                        }
                    }

                } else {
                    echo "At the moment, no tables have been created.";
                }
            ?>
        </tbody>
    </table>
</div>
<?php } ?>
