<?php
    if (! defined('ABSPATH')) exit;
    $prefix = BDDS_PLUGIN_PREFIX;
?>

<div class="wrap">
    <h1>Black-Desk Shortcodes</h1>

    <div class="bdds-intro">
        <p>
            Shortcodes are a powerful feature of Black-Desk that let you seamlessly connect your data tables to any of your WordPress pages or posts, in one of the two directions:
        </p>
        <ol>
            <li>Display data from your tables directly on your page or post;</li>
            <li>Create custom data entry <b>forms</b> to store user input directly into your data tables. With type validation.
            <br>
            Generate new entries, or update existing data.</li>
        </ol>
    </div>


    <h2>Quick Reference</h2>

    <h4>1) Display Existing Data</h4>

    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Shortcode</th>
                <th>Purpose</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><code>[<?php echo $prefix; ?>-view-table]</code></td>
                <td>Displays table data or saved query data as a table with optional pagination, search, and sorting</td>
            </tr>
            <tr>
                <td><code>[<?php echo $prefix; ?>-view-field]</code></td>
                <td>Displays a single field value from the specified table/query, for the specified ID/key</td>
            </tr>
            <tr>
                <td><code>[<?php echo $prefix; ?>-view-repeat]</code></td>
                <td>Displays specified fields for each row in the table/query result</td>
            </tr>
        </tbody>
    </table>


    <h4>2) Create Forms</h4>

    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Shortcode</th>
                <th>Purpose</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><code>[<?php echo $prefix; ?>-form-start]</code></td>
                <td>Opens a data entry/update form</td>
            </tr>
            <tr>
                <td><code>[<?php echo $prefix; ?>-form-field]</code></td>
                <td>Adds an input field to the form</td>
            </tr>
            <tr>
                <td><code>[<?php echo $prefix; ?>-form-stop]</code></td>
                <td>Closes the form</td>
            </tr>
        </tbody>
    </table>

    <h2 class="title">Detailed Usage</h2>

    <div class="bdds-info-card">
        <h3>View Table</h3>
        <code>[<?php echo $prefix; ?>-view-table]</code>
        <p>Displays table data or saved query data in a table format with optional features like search, pagination, and sorting.</p>

        <h4>Attributes [required: <code>table</code> OR <code>query</code>]:</h4>
        <ul>
            <li><code>* table</code> - Name of your table</li>
            <li><code>* query</code> - Name of your saved query to use instead of the table</li>
            <li><code>id</code> - Unique identifier for the table HTML element (so you can reference it in your custom styling or script)</li>
            <li><code>fields</code> - Comma-separated list of fields/columns to display (only comma, <strong>NO WHITESPACE!</strong>)</li>
            <li><code>fieldnames</code> - Corresponding comma-separated column headers in the exact same order as <code>fields</code></li>
            <li><code>sort</code> - Enable sorting for listed columns (comma-separated, no whitespace; <b>default</b>: disabled)</li>
            <li><code>search</code> - Comma-separated list of columns to include in the search (<b>default</b>: none)</li>
            <li><code>paginate</code> - Number of rows per page (<b>default</b>: all)</li>
            <li><code>rownumbers</code> - Add first column showing row numbers (true/false; <b>default</b>: false)</li>
        </ul>

        <br>

        <p><strong>Examples:</strong></p>
        <code>[<?php echo $prefix; ?>-view-table table="app_user"]</code>
        <p>Will display ALL data from the <code>app_user</code> table on a single page.</p>

        <code>[<?php echo $prefix; ?>-view-table id="my-<?php echo $prefix; ?>-table" table="app_user" fields="id,username,first_name,last_name,created_at" fieldnames="ID,Username,First Name,Last Name,Since" sort="id,last_name" search="username,first_name,last_name" rownumbers="true" paginate="20"]</code>

        <p>
            <code>[<?php echo $prefix; ?>-view-table id="my-<?php echo $prefix; ?>-query-table" query="cheap_products" fieldnames="ID,Name,Description,Price" sort="price"]</code>
        </p>
    </div>

    <div class="bdds-info-card">
        <h3>View Field</h3>
        <code>[<?php echo $prefix; ?>-view-field]</code>
        <p>Displays a single field value from the specified table/query, for the specified ID/key.</p>

        <h4>TABLE - Attributes [required: <code>table</code>, <code>rowid</code>, <code>field</code>]:</h4>
        <ul>
            <li><code>* table</code> - Name of your table</li>
            <li><code>* rowid</code> - Specific row ID (in your database table)</li>
            <li><code>* field</code> - Column name of the field to display</li>
        </ul>

        <h4>QUERY - Attributes [required: <code>query</code>, <code>key</code>, <code>field</code>]:</h4>
        <ul>
            <li><code>* query</code> - Name of your saved query to use instead of the table</li>
            <li><code>* key</code> - Corresponding to the order of the row in the query result</li>
            <li><code>* field</code> - Name of the field to display (column name or alias)</li>
        </ul>

        <br>

        <p><strong>Examples:</strong></p>
        <code>[<?php echo $prefix; ?>-view-field table="product" rowid="19" field="description"]</code>
        <p>
            <code>[<?php echo $prefix; ?>-view-field query="product_reviews" key="3" field="product_id"]</code>
        </p>
        <p>
            <code>[<?php echo $prefix; ?>-view-field query="product_reviews" key="3" field="Product Name"]</code>
        </p>
        <p>
            <code>[<?php echo $prefix; ?>-view-field query="product_reviews" key="3" field="comment"]</code>
        </p>
    </div>

    <div class="bdds-info-card">
        <h3>View Repeat</h3>
        <code>[<?php echo $prefix; ?>-view-repeat]</code>
        <p>Displays specified fields for each row in the table/query result. Useful for custom layouts.</p>

        <h4>Attributes [required: <code>table</code> OR <code>query</code>]:</h4>
        <ul>
            <li><code>* table</code> - Name of your table</li>
            <li><code>* query</code> - Name of your saved query to use instead of the table</li>
            <li><code>field</code> - Column name of the field to display for each row</li>
        </ul>

        <br>

        <p><strong>Examples:</strong></p>
        <pre>
            [<?php echo $prefix; ?>-view-repeat table="app_user"]
                [<?php echo $prefix; ?>-view-field field="username"]
                [<?php echo $prefix; ?>-view-field field="first_name"]
            [/<?php echo $prefix; ?>-view-repeat]</pre>
        <pre>
            [<?php echo $prefix; ?>-view-repeat query="list_user_carts"]
                [<?php echo $prefix; ?>-view-field field="first_name"]
                [<?php echo $prefix; ?>-view-field field="last_name"]
                [<?php echo $prefix; ?>-view-field field="product_ids"]
            [/<?php echo $prefix; ?>-view-repeat]</pre>
    </div>

    <div class="bdds-info-card">
        <h3>Form</h3>
        <p>Use these three shortcodes together to create data entry/update forms (with type validation):</p>

        <div class="bdds-secondary-card">
            <h3>Form Start</h3>
            <code>[<?php echo $prefix; ?>-form-start]</code>

            <h4>Attributes [required: <code>table</code>]:</h4>
            <ul>
                <li><code>* table</code> - Name of your table</li>
                <li><code>id</code> - Unique identifier for the form HTML element (so you can reference it in your custom styling or script)</li>
            </ul>
        </div>

        <div class="bdds-secondary-card">
            <h3>Form Field</h3>
            <code>[<?php echo $prefix; ?>-form-field]</code>

            <h4>CREATE a New Record - Attributes [required: <code>field</code>]:</h4>
            <ul>
                <li><code>* field</code> - The name of the field (column) in your table</li>
                <li><code>id</code> - Input field HTML identifier suffix (prefix is <code><?php echo $prefix; ?>_form_field_</code>)</li>
                <li><code>required</code> - Make field required (true/false); front-end validation</li>
            </ul>

            <h4>UPDATE an Existing Record - Attributes [required: <code>field</code>, <code>allowedit="true"</code>, <code>id</code>]:</h4>
            <ul>
                <li><code>* field</code> - The name of the field (column) in your table</li>
                <li><code>* allowedit="true"</code> - if omitted, new entry would be created</li>
                <li><code>* id</code> - ID of the record you want to update (ID in your table)</li>
                <li><code>required</code> - Make field required (true/false); front-end validation</li>
            </ul>
        </div>

        <div class="bdds-secondary-card">
            <h3>Form Stop</h3>
            <code>[<?php echo $prefix; ?>-form-stop]</code>
        </div>

        <br>

        <p><strong>Examples:</strong></p>
        <p>Create:</p>
        <pre>
            [<?php echo $prefix; ?>-form-start id="my-<?php echo $prefix; ?>-form" table="product"]
                [<?php echo $prefix; ?>-form-field id="name" field="name" required="true"]
                [<?php echo $prefix; ?>-form-field id="description" field="description"]
                [<?php echo $prefix; ?>-form-field id="price" field="price" required="true"]
            [<?php echo $prefix; ?>-form-stop]</pre>
        <p>Update:</p>
        <pre>
            [<?php echo $prefix; ?>-form-start id="my-<?php echo $prefix; ?>-update-form" table="product"]
                [<?php echo $prefix; ?>-form-field id="19" allowedit="true" field="name"]
                [<?php echo $prefix; ?>-form-field id="19" allowedit="true" field="description"]
                [<?php echo $prefix; ?>-form-field id="19" allowedit="true" field="price"]
            [<?php echo $prefix; ?>-form-stop]</pre>
    </div>
</div>
