<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;

    // debug info
    if("not-exists" === get_option( BDDS_PLUGIN_PREFIX . "_show_debug", "not-exists")) {
        add_option(BDDS_PLUGIN_PREFIX . "_show_debug", "false");
    }

    $show_debug = isset($_POST["show-debug-info"]) && check_admin_referer("bdds-settings-nonce") ? sanitize_text_field(wp_unslash($_POST["show-debug-info"])) : null;
    if(isset($_POST["save-debug-info"]) && $show_debug == "on" && check_admin_referer("bdds-settings-nonce")) {
        update_option(BDDS_PLUGIN_PREFIX . "_show_debug", "true");

    } else if (isset($_POST["save-debug-info"]) && $show_debug != "on" && check_admin_referer("bdds-settings-nonce")) {
        update_option(BDDS_PLUGIN_PREFIX . "_show_debug", "false");

    }

    $option_status = (get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") ? "checked" : ''
    
?>

<h2>Black-Desk Settings</h2>
<form method="post">
    <table class="form-table">
        <tr> 
            <th>
                <input type="checkbox" name="show-debug-info" <?php echo esc_attr($option_status); ?>>
            </th>
            <td>
                <label for="show-debug-info">Show debug info</label>
            </td>
        </tr>
    </table>
    <p>
        <input type="submit" value="Save" class="button button-primary" style="margin-top: 2em;" name="save-debug-info">
    </p>
    <?php wp_nonce_field("bdds-settings-nonce"); ?>
</form>