<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    if(!empty($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"][BDDS_PLUGIN_PREFIX . "_query_to_save"])
        || isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))
    {
        global $wpdb;

        $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"])
                    ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]))
                    : null;
        $query_to_save = '';
        //$query_to_save = str_replace( "\'", "'", $_POST[ "save_query" ] );
        $queries_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . "queries";
        $query_inserted = false;

        // if edited query is saved in session, save that query to DB
        // else when creating new query save it to DB
        if( isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])) {
            $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
            $query_id = isset($_GET["query_id"]) && wp_verify_nonce($nonce, "bdds-edit-query-preview") ? sanitize_text_field(wp_unslash($_GET["query_id"])) : null;
            $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                          ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                          : null;
            $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
                        ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"]))
                        : '';
            $query_to_save = $query_object->createQuery();
            $serialized_query_object = serialize($query_object);
            $query_updated = false;

            $wpdb->update( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                $queries_table_name,
                array(
                    "query_name" => $query_name,
                    "query" => $query_to_save,
                    "query_object" => $serialized_query_object
                ),
                array(
                    "id" => $query_id
                )
            );

            $wpdb->show_errors();
            if(empty($wpdb->last_error)) {
                $query_updated = true;
                unset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]);

            } else {
                $query_updated = false;
                echo "<p>" . esc_html($wpdb->last_error) . "</p>";
            }

            $wpdb->hide_errors();

        } else {
            $fields_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])
                           ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])))
                           : new BDDS_Select(array(), array());

            $tables_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])
                           ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])))
                           : new BDDS_From(array());

            $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])
                               ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])))
                               : new BDDS_Where();

            // Issue-20 used to occur when $conditions_object was an instance of string
            if (!($conditions_object instanceof BDDS_Where)) {
                $conditions_object = new BDDS_Where();
            }

            $query_object            = new BDDS_Query($fields_object, $tables_object, $conditions_object);
            $query_to_save           = $query_object->createQuery();
            $serialized_query_object = isset($query_object) ? serialize($query_object) : null;

            $wpdb->insert( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
                $queries_table_name,
                array(
                    "query_name" => $query_name,
                    "query" => $query_to_save,
                    "query_object" => $serialized_query_object
                )
            );

            $wpdb->show_errors();
            if(empty($wpdb->last_error)) {
                $query_inserted = true;
                unset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]);

            } else {
                $query_inserted = false;
                echo "<p>" . esc_html($wpdb->last_error) . "</p>";
            }

            echo "<p>" . esc_html($query_inserted) . "</p>";
            $wpdb->hide_errors();

        }
    } else {
        echo "Missing some of the query variables!";

    }