<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $condition_id = isset($_GET["condition_id"]) && 
        (wp_verify_nonce($nonce, "create-select-query-nonce") || wp_verify_nonce($nonce, "bdds-edit-query-nonce")) ? sanitize_text_field(wp_unslash($_GET["condition_id"])) : null; 
    $input_name   = (isset($_GET["action"]) && $_GET["action"] == "edit" 
        && wp_verify_nonce($nonce, "create-select-query-nonce") || wp_verify_nonce($nonce, "bdds-edit-query-nonce")) ? "yes-delete-edit" : "yes-delete-condition";
?>

<h2>Are you sure you want to remove a condition? </h2>

<form method="post">
    <input type="submit" name="<?php echo esc_attr($input_name); ?>" value="Yes" class="button button-primary">
    <input type="submit" name="no-delete-condition" value="No" class="button button-primary">    
    <input type="hidden" name="condition-id" value="<?php echo esc_attr($condition_id);?>">
</form>
