<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin/classes/Query.php";
    require_once BDDS_PLUGIN_HELPERS_DIR . "BDDS_Formatter.php";
    require_once BDDS_PLUGIN_SERVICES_DIR . "BDDS_QueryService.php";

    global $wpdb;
?>

<h1>
    <?php
        $q_name;
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        if(isset($_GET["query_id"]) && wp_verify_nonce($nonce, "bdds-edit-query-preview") || wp_verify_nonce($nonce, "bdds-query-id-preview")) {
            $queries_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries";
            $q_name = $wpdb->get_var($wpdb->prepare("SELECT `query_name` FROM `$queries_table_name` WHERE id=%d;", sanitize_text_field(wp_unslash($_GET["query_id"])))); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            esc_html_e('View ', 'black-desk');
            echo ' - ' . esc_html($q_name);

        } else esc_html_e('Preview Data', 'black-desk');

    ?>
</h1>
<?php
    // Post names
    // session array with values => SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions"]
    // condition_field_name_id
    // field_condition_id
    // field_value_type_id
    // field_value_select_id
    // field_value_text_id
    // condition_operator_id

    $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"])
        ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]))
        : null;
    $tables = array();
    $err_msgs = array();
    $fields = "";
    $conditions = "";
    $tables_string = "";
    $field_alias = "";
    $wp_tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";

    // query id is used when user View's query that's already created
    $query_id = isset($_GET["query_id"]) ? sanitize_text_field(wp_unslash($_GET["query_id"])) : null;
    $queries_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries";

    if (isset($query_id) && isset($_GET["action"]) && $_GET["action"] == "edit") {
        if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true" && isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"])) {
            echo "Session edit variables: ";
            print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        }

        $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                      ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                      : null;

        $q_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
            ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"]))
            : '';
        $final_query = isset($query_object) ? $query_object->createQuery() : null;
        $records     = $wpdb->get_results( $wpdb->prepare( $final_query ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared

        echo "<div style='width: 50%;margin-top:2em;margin-bottom:2em;'><h2>Edited query - "
            . esc_html($q_name) . "</h2><hr>" . esc_html($final_query) . "</div>";

    } else if(isset($query_id)) {
        // if user choose to View a query which already exists
        $query       = $wpdb->get_var($wpdb->prepare("SELECT `query` FROM `$queries_table_name` WHERE id=%d", $query_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $final_query = $query;

        $records     = $wpdb->get_results( $wpdb->prepare( $final_query ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
        // display raw query
        echo "<div style='width: 50%;margin-top:2em;margin-bottom:2em;'><hr>" . esc_html($final_query) . "</div>";

        $query_object = BDDS_QueryService::get_by_id($query_id);

    } else if(!isset($query_id)) {
        if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
            echo "Session: ";
            if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
            echo " Post: ";
            if(isset($_POST)) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r

        }

        foreach($err_msgs as $err_msg) {
            BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                esc_html($err_msg), 'error'
            );
        }

        $fields_object     = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])
                                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])))
                                : new BDDS_Select(array(), array());
        $tables_object     = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])
                                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])))
                                : new BDDS_From(array());
        $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])
                                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])))
                                : new BDDS_Where();

        // Issue-20 used to occur when $conditions_object was an instance of string
        if (!($conditions_object instanceof BDDS_Where)) {
            $conditions_object = new BDDS_Where();
        }

        $query_object = new BDDS_Query($fields_object, $tables_object, $conditions_object);
        $final_query  = $query_object->createQuery();

        if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") echo "<p>" . esc_html($final_query) . "</p>";

        $wpdb->show_errors();

        $records = $wpdb->get_results( $wpdb->prepare( $final_query ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
        if( !empty( $wpdb->last_error ) ) {
            BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                esc_html($wpdb->last_error), 'error'
            );
        } else {
            $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"][BDDS_PLUGIN_PREFIX . "_query_to_save"] = $final_query;
        }

        $wpdb->hide_errors();

    }

    /* On query edit > 'save' - query preview code is executed even though the next
        step does not include the actual query preview, leading to errors:
        - "calling a member function on null" error occurs because $query_object is null;
        - PHP warning "Invalid argument supplied for foreach() ... on line 157." is
            logged because of $records not being set.

        PATCH (until a better solution is found):
            - check & handle $query_object being null;
            - set $attachment_id_fields and $records to [] (not needed in this case)
                to avoid the PHP warning.
    */
    if ($query_object) {
        $attachment_id_fields = $query_object->getAttachmentIdAliasesOrFields();
    } else {
        $attachment_id_fields = [];
        $records = [];
    }
?>

<div class="wrap">
    <form method="post">
        <table class="wp-list-table widefat fixed striped table-view-list pages">
            <thead>
                <tr>
                    <?php
                        if( isset($records[0]) && count($err_msgs) == 0 ){
                            foreach( $records[0] as $key=>$first_record ) {
                                echo "<th><a>" . esc_html($key) . "</a></th>";
                            }
                        }
                    ?>
                </tr>
            </thead>

            <tbody>
                <?php
                    if(count($err_msgs) == 0) {
                        foreach( $records as $record ) {
                            echo "<tr>";
                                foreach ($record as $field => $value) {
                                    if (in_array($field, $attachment_id_fields)) {
                                        $td_content_html = BDDS_Formatter::get_attachment_html($value);
                                    } else {
                                        $td_content_html = esc_html($value);
                                    }

                                    echo "<td>" . $td_content_html . "</td>";
                                }
                            echo "</tr>";
                        }
                    }
                ?>
            </tbody>
        </table>
        <?php if(isset($query_id) && isset($_GET["action"]) && $_GET["action"] == "edit") { ?>

            <div style="margin-top: 1em;">
                <?php $back_to_aliases_arg = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-conditions-slug")?>
                <a href="<?php echo esc_url($back_to_aliases_arg)?>" class="button button-primary">Back</a>

                <?php if(count($err_msgs) == 0 ) { ?>
                    <input type="submit" class="button button-primary" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-query-save" value="<?php esc_attr_e('Save', 'black-desk'); ?>" style="float: right;">
                <?php } ?>
            </div>

        <?php } else if (isset($query_id)){ ?>

            <div style="margin-top: 1em;">
                <?php
                    $back_to_show_queries = remove_query_arg("query_id");
                    $back_to_show_queries = str_replace("page=" . BDDS_PLUGIN_PREFIX . "-query-preview-slug", "page=" . BDDS_PLUGIN_PREFIX . "-all-queries-slug", $back_to_show_queries);
                ?>
                <a class="button button-primary" href="<?php echo esc_url($back_to_show_queries); ?>">Back</a>
            </div>

        <?php } else { ?>

            <div style="margin-top: 1em;">
                <?php $back_to_aliases_arg = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-conditions-slug")?>
                <a href="<?php echo esc_url($back_to_aliases_arg); ?>" class="button button-primary">Back</a>

                <?php if(count($err_msgs) == 0 ) { ?>
                    <input type="submit" class="button button-primary" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-query-save" value="<?php esc_attr_e('Save', 'black-desk'); ?>" style="float: right;">
                <?php } ?>
            </div>

        <?php } ?>
    </form>
</div>
