<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin/classes/Query.php";

    global $wpdb;
    $table_prefix_wildcard = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_%";
    $table_names         = $wpdb->get_results( $wpdb->prepare("SHOW TABLES LIKE %s", $table_prefix_wildcard)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
    $metadata_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata";
    $tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX;
    $query_name_err;
    $number_of_selected_tables_err;
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $post_array = (wp_verify_nonce($nonce, "create-select-query-nonce")) ? map_deep($_POST, 'sanitize_text_field' ) : array();

    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST)) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r

    }

    // show error if user did not select any table
    if (empty($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["selected-tables"]) && isset($_POST[BDDS_PLUGIN_PREFIX . "-query-fields"]) && !isset($_GET["action"]) && !isset($_GET["query_id"])) {
        $query_name = isset($_POST[BDDS_PLUGIN_PREFIX . "_query_name"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "_query_name"])) : null;
        $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"] = (!empty($query_name)) ? $query_name : '';

        $number_of_selected_tables_err = __('At least one table should be selected', 'black-desk');

    }

    // remove selected table, when creating query or editing an existing one
    if(isset($_POST["remove-selected-table"]) || isset($_POST["edit-remove-selected-table"])) {
        $tables_to_remove = isset($_POST["selected-tables"]) ? map_deep($_POST["selected-tables"], 'sanitize_text_field' ) : null; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.MissingUnslash

        if(isset($_POST["remove-selected-table"])) {
            $tables_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])
                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])))
                : null;

            $tables = isset($tables_object) ? $tables_object->getTables() : array();

            $fields_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])
                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"])))
                : null;

            $fields  = isset($fields_object) ? $fields_object->getFields() : array();
            $aliases = isset($fields_object) ? $fields_object->getAliases() : array();

            $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])
                               ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])))
                               : null;

            $conditions = isset($conditions_object) ? $conditions_object->getConditions() : array();

        } else if (isset($_POST["edit-remove-selected-table"])) {
            $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                          ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                          : null;

            $tables_object = isset($query_object) ? $query_object->getTablesObject() : null;
            $tables        = isset($tables_object) ? $tables_object->getTables() : array();

            $fields_object = isset($query_object) ? $query_object->getFieldsObject() : null;
            $fields        = isset($fields_object) ? $fields_object->getFields() : array();
            $aliases       = isset($fields_object) ? $fields_object->getAliases() : array();

            $conditions_object = isset($query_object) ? $query_object->getConditionsObject() : null;
            $conditions        = isset($conditions_object) ? $conditions_object->getConditions() : array();

        }

        $field_exists;
        $alias_exists;
        $condition_exists;

        foreach($tables_to_remove as $table_to_remove) {
            // delete table if exist
            if(in_array($table_to_remove, $tables))
            {
                $array_element_index = array_search($table_to_remove, $tables);
                unset($tables[$array_element_index]);
            }

            // delete fields for table if they exist
            foreach($fields as $key=>$field) {
                $table = explode('.', $field)[0];
                $table = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $table;

                if($table == $table_to_remove) $field_exists = true;

            }

            // delete aliases for table fields if they exist
            foreach($aliases as $key=>$alias) {
                $table = str_replace($wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $table_to_remove);

                if(str_starts_with($key, "field_alias_$table") && !empty($aliases["field_alias_$table"])) $alias_exists = true;

            }

            // delete condition with fields from table
            foreach($conditions as $key=>$condition) {
                $table = str_replace($wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $table_to_remove);

                if(str_starts_with($condition["condition_field_name_0"], $table)) $condition_exists = true;
                if(str_starts_with($condition["field_value_select_0"], $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $table)) $condition_exists = true;

            }
        }

        if(isset($field_exists) || isset($alias_exists) || isset($condition_exists)) {
            if( isset($field_exists) && $field_exists ) echo "<div class='notice notice-error'>Field from the table you are trying to delete is in use!</div>";
            if( isset($alias_exists) && $alias_exists ) echo "<div class='notice notice-error'>Field from the table you are trying to delete has alias!</div>";
            if( isset($condition_exists) && $condition_exists ) echo "<div class='notice notice-error'>Field from the table you are trying to delete is used as condition!</div>";

        } else {
            if(isset($_POST["remove-selected-table"])) {
                $tables = array_values($tables);
                if(isset($tables_object)) $tables_object->setTables($tables);
                $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"] = serialize($tables_object);

            } else if(isset($_POST["edit-remove-selected-table"])) {
                $tables = array_values($tables);
                if(isset($tables_object)) $tables_object->setTables($tables);

                $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);
            }
        }
    }

?>

<h1>Query </h1>
<div id="notice-select-tables" class="notice notice-error" style="display: none;"></div>
<div>
    <?php
        if (!empty($query_name_err)) {
            BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                esc_html($query_name_err), 'error'
            );
        }
        if (!empty($number_of_selected_tables_err)) {
            BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                esc_html($number_of_selected_tables_err), 'error'
            );
        }
    ?>
    <form method="post" id="selected-tables-form" >
        <table id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-select-tables">
        <?php if(!isset($_GET["action"]) && !isset($_GET["query_id"])) {
                // object which holds selected tables in session as serialized object
                $tables_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"])))
                    : null;
                $selected_tables = isset($tables_object) ? $tables_object->getTables() : array();

        ?>
            <div style="margin-top: 2em;margin-bottom: 2em;">
                <label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-query-name"><b><?php esc_html_e('Query Name', 'black-desk'); ?></b></label>
                <span style="color: red;">*</span>
                <input type="text" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-query-name" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>_query_name"
                value="<?php echo (!empty($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"])) ? esc_attr(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]))) : ''; ?>"
                pattern="^[a-z0-9_]+$" required title="<?php esc_attr_e('Only uppercase and lowercase Latin letters, underscore and numbers', 'black-desk'); ?>"
                >
            </div>
            <tbody>
                <tr>
                    <td class="available-tables-td">
                        <select name="available-tables[]" multiple class="regular-text">
                            <?php
                                foreach( $table_names as $table ) {
                                    foreach( $table as $table_name ) {
                                        if( $table_name == $metadata_table_name || $table_name == $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries" ) continue;
                                        if( in_array( $table_name, $post_array ) || in_array($table_name, $selected_tables)) continue;

                                        $formatted_table_name = str_replace( $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $table_name );
                                        echo "<option value='" . esc_attr($table_name) . "'>"
                                                . esc_html($formatted_table_name)
                                            . "</option>";
                                    }
                                }
                            ?>
                        </select>
                    </td>

                    <td class="arrows-td">
                        <input type="submit" name="add-selected-table" value="&#8594;" class="button arrows-input" style="margin-inline: 1em;">
                        <br>
                        <br>
                        <input type="submit" name="remove-selected-table" value="&#8592;" class="button arrows-input" style="margin-inline: 1em;">
                                <?php wp_nonce_field('bdds-query-name-nonce'); ?>
                    </td>

                    <td class="selected-tables-td">
                        <select name="selected-tables[]" multiple class="regular-text">
                            <?php
                                if(isset($selected_tables)) {
                                    foreach($selected_tables as $selected_table) {
                                        $selected_table_without_prefix = str_replace("$tables_prefix".'_', '', $selected_table);
                                        echo "<option value='" . esc_attr($selected_table) . "'>" . esc_html($selected_table_without_prefix) . "</option>";
                                    }
                                }
                            ?>
                        </select>
                    </td>
                </tr>
            </tbody>
            <?php  /* QUERY EDIT */
            } else if (isset($_GET["action"]) && isset($_GET["query_id"]) && $_GET["action"] == "edit") {
                if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true" && isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"])) {
                    echo "Session edit variables: ";
                    print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                }
                $query_id = isset($_GET["query_id"]) ? sanitize_text_field(wp_unslash($_GET["query_id"])) : null;

                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                    : null;

                $selected_tables = $query_object->getTablesObject()->getTables();
                $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
                    ? sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_name"])
                    : '';

            ?>
                <div style="margin-top: 2em;margin-bottom: 2em;">
                    <label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-query-name"><b><?php esc_html_e('Query Name', 'black-desk'); ?></b></label>
                    <span style="color: red;">*</span>
                    <input type="text" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-query-name" name="new-<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>_query_name"
                    value="<?php echo esc_attr($query_name); ?>"
                    pattern="^[a-z0-9_]+$" required title="<?php esc_attr_e('Only uppercase and lowercase Latin letters, underscore and numbers', 'black-desk'); ?>"
                    >
                </div>
                <tbody>
                    <tr>
                        <td>
                            <select name="available-tables[]" multiple class="regular-text">
                                <?php
                                    foreach( $table_names as $table ) {
                                        foreach( $table as $table_name ) {
                                            if( $table_name == $metadata_table_name || $table_name == $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries" ) continue;
                                            if( in_array( $table_name, $post_array ) || in_array($table_name, $selected_tables)) continue;

                                            $formatted_table_name = str_replace( $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $table_name );
                                            echo "<option value='" . esc_attr($table_name) . "'>"
                                                    . esc_html($formatted_table_name)
                                                . "</option>";
                                        }
                                    }
                                ?>
                            </select>
                        </td>

                        <td class="arrows-td">
                            <input type="submit" name="edit-add-selected-table" value="&#8594;" class="button arrows-input" style="margin-inline: 1em;">
                            <br>
                            <br>
                            <input type="submit" name="edit-remove-selected-table" value="&#8592;" class="button arrows-input" style="margin-inline: 1em;">
                        </td>

                        <td>
                            <select name="selected-tables[]" multiple class="regular-text">
                                <?php
                                    if(isset($selected_tables)) {
                                        foreach($selected_tables as $selected_table) {
                                            $selected_table_without_prefix = str_replace("$tables_prefix".'_', '', $selected_table);
                                            echo "<option value='" . esc_attr($selected_table) . "'>" . esc_html($selected_table_without_prefix) . "</option>";
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                </tbody>

            <?php } ?>
            <tfoot>
                <tr>
                    <td>
                        <?php
                            $all_queries_arg = remove_query_arg(array("query_id", "action"));
                            $all_queries_arg = str_replace("page=" . BDDS_PLUGIN_PREFIX . "-query-name-and-tables-slug", "page=" . BDDS_PLUGIN_PREFIX . "-all-queries-slug", $all_queries_arg);
                            $next_input_name = BDDS_PLUGIN_PREFIX . "-query-fields";
                        ?>
                        <a href="<?php echo esc_url($all_queries_arg); ?>" class="button button-primary" style="margin-top: 0.5em;margin-right:1em;float:left;">
                            <?php esc_html_e('Cancel', 'black-desk');?>
                        </a>
                    </td>
                    <td></td>
                    <td>
                        <input
                            type="submit"
                            id="next-button"
                            class="button button-primary"
                            name='<?php echo esc_attr($next_input_name); ?>'
                            value='<?php echo esc_attr_e('Next', 'black-desk');?>'
                            style="margin-top: 0.5em;float:right;"
                        >
                    </td>
                </tr>
            </tfoot>
        </table>
    </form>
</div>