<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin/classes/Query.php";

    global $wpdb;

    $tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX;
    $session_variables = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]) ? sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]) : null;
    $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]) ? sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]) : '';
    $selected_fields_err;
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;

    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST) && wp_verify_nonce($nonce, "create-select-query-nonce")) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r

    }

    if(isset($_POST["remove-selected-field"]) || isset($_POST["edit-remove-selected-field"])) {
        $fields_to_delete = isset($_POST["selected-fields"]) ? map_deep($_POST["selected-fields"], 'sanitize_text_field') : null; //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash

        if(isset($fields_to_delete)) {
            if(isset($_GET["action"]) && $_GET["action"] == "edit" && isset($_GET["query_id"])) {
                $query_object  = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                    : null;

                $fields_object     = isset($query_object) ? $query_object->getFieldsObject() : null;
                $conditions_object = isset($query_object) ? $query_object->getConditionsObject() : null;

            } else {
                $fields_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))) : null;
                $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])))
                    : null;
            }

            $fields        = isset($fields_object) ? $fields_object->getFields() : array();
            $aliases       = isset($fields_object) ? $fields_object->getAliases() : array();
            $conditions    = isset($conditions_object) ? $conditions_object->getConditions() : array();

            $field_exists;
            $alias_exists;
            $condition_exists;

            foreach($fields_to_delete as $field_to_delete) {

                // delete field
                if(in_array($field_to_delete, $fields)) {
                    $array_element_index = array_search($field_to_delete, $fields);
                    unset($fields[$array_element_index]);
                }

                $field_name_without_dot = str_replace('.', '_', $field_to_delete);
                // delete alias if exists
                if(key_exists("field_alias_$field_name_without_dot", $aliases) && $field_name_without_dot != $aliases["field_alias_$field_name_without_dot"]) $alias_exists = true;
                else unset($aliases["field_alias_$field_name_without_dot"]);

                // delete conditions for field if they exist
                foreach($conditions as $key=>$condition) {
                    if($condition["condition_field_name_0"] == $field_to_delete) $condition_exists = true;
                    else unset($condition["condition_field_name_0"]);

                    if($condition["field_value_select_0"] == $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_" . $field_to_delete) $condition_exists = true;
                    else unset($condition["field_value_select_0"]);
                }
            }

            if( isset($field_exists) || isset($alias_exists) || isset($condition_exists) ) {
                if( isset($field_exists) && $field_exists ) {
                    BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                        'Field from the table you are trying to delete is in use!',
                        'error'
                    );
                }
                if( isset($alias_exists) && $alias_exists ) {
                    BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                        'Field from the table you are trying to delete has alias!',
                        'error'
                    );
                }
                if( isset($condition_exists) && $condition_exists ) {
                    BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
                        'Field from the table you are trying to delete is used as condition!',
                        'error'
                    );
                }

            } else {
                if(isset($_GET["action"]) && $_GET["action"] == "edit" && isset($_GET["query_id"])) {
                    if(isset($fields_object)) $fields_object->setFields($fields);
                    if(isset($fields_object)) $fields_object->setAliases($aliases);
                    if(isset($conditions_object)) $conditions_object->setConditions($conditions);

                    $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);

                } else {
                    if(isset($fields_object)) $fields_object->setFields($fields);
                    if(isset($fields_object)) $fields_object->setAliases($aliases);
                    if(isset($conditions_object)) $conditions_object->setConditions($conditions);

                    $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"] = serialize($fields_object);
                    $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"] = serialize($conditions_object);

                }

            }
  }
    }

    if( isset($_POST[BDDS_PLUGIN_PREFIX . "-query-aliases"]) && (!isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]) || empty(unserialize(sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))->getFields()))) {

        $selected_fields_err = __('At least one field should be selected', 'black-desk');

    }

?>

<h2><?php esc_html_e('Select Fields', 'black-desk'); ?></h2>

<?php
    if (isset($selected_fields_err)) {
        BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
            esc_html($selected_fields_err), 'error'
        );
    }
?>

<form id="fields-form" method="post">
    <table id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-select-tables" class="wp-list-table fixed striped table-view-excerpt pages">
        <?php if(!isset($_GET["action"]) && !isset($_GET["query_id"])) {
            $tables_object   = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"]))) : null;
            $selected_tables = isset($tables_object) ? $tables_object->getTables() : array();
            $fields_object   = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))) : null;
            $selected_fields = isset($fields_object) ? $fields_object->getFields() : array();
        ?>
        <tbody>
            <tr>
                <td>
                    <select name="available-fields[]" multiple class="regular-text">
                        <?php
                            foreach( $selected_tables as $selected_table ) {
                                $table_name             = $selected_table;
                                $table_structure_result = $wpdb->get_results( $wpdb->prepare("DESC `$table_name`"), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

                                foreach( $table_structure_result as $table_struct ) {
                                    $table_field_name = str_replace( $tables_prefix . '_', '', $table_name ) . ".$table_struct->Field";
                                    $fields_array = (!empty($session_selected_fields)) ? $fields_object->fields : array();
                                    if(in_array($table_field_name, $selected_fields)) continue;

                                    echo "<option value='" . esc_attr($table_field_name) . "'>";
                                        echo esc_html($table_field_name);
                                    echo "</option>";
                                }
                            }
                        ?>
                    </select>
                </td>
                <td class="arrows-td">
                        <input type="submit" name="add-selected-field" value="&#8594;" class="button arrows-input" style="margin-inline: 1em;">
                        <br>
                        <br>
                        <input type="submit" name="remove-selected-field" value="&#8592;" class="button arrows-input" style="margin-inline: 1em;">
                </td>
                <td class="selected-tables-td">
                    <select name="selected-fields[]" multiple class="regular-text">
                        <?php
                            if(isset($selected_fields)) {
                                foreach($selected_fields as $selected_fields) {
                                    echo "<option>" . esc_html($selected_fields) . "</option>";
                                }
                            }
                        ?>
                    </select>
                </td>
            </tr>
        </tbody>
        <?php } else if (isset($_GET["action"]) && isset($_GET["query_id"]) && $_GET["action"] == "edit") {
                if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true" && isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"])) {
                    echo "Session edit variables: ";
                    print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                }

                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])
                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])))
                    : null;

                $selected_tables = $query_object->getTablesObject()->getTables();
                $selected_fields = $query_object->getFieldsObject()->getFields();
        ?>
        <tbody>
            <tr>
                <td>
                    <select name="available-fields[]" multiple class="regular-text">
                        <?php
                            foreach( $selected_tables as $selected_table ) {
                                $table_name             = $selected_table;
                                $table_structure_result = $wpdb->get_results( $wpdb->prepare( "DESC `$table_name`" ), OBJECT ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

                                foreach( $table_structure_result as $table_struct ) {
                                    $table_field_name = str_replace( $tables_prefix . '_', '', $table_name ) . ".$table_struct->Field";
                                    $fields_array = (!empty($session_selected_fields)) ? $fields_object->fields : array();
                                    if(in_array($table_field_name, $selected_fields)) continue;

                                    echo "<option value='" . esc_attr($table_field_name) . "'>";
                                        echo esc_html($table_field_name);
                                    echo "</option>";
                                }
                            }
                        ?>
                    </select>
                </td>

                <td class="arrows-td">
                        <input type="submit" name="edit-add-selected-field" value="&#8594;" class="button arrows-input" style="margin-inline: 1em;">
                        <br>
                        <br>
                        <input type="submit" name="edit-remove-selected-field" value="&#8592;" class="button arrows-input" style="margin-inline: 1em;">
                </td>

                <td>
                    <select name="selected-fields[]" multiple class="regular-text">
                        <?php
                            if(isset($selected_fields)) {
                                foreach($selected_fields as $selected_field) {
                                    echo "<option>" . esc_html($selected_field) . "</option>";
                                }
                            }
                        ?>
                    </select>
                </td>
            </tr>
        </tbody>

        <?php } ?>
        <tfoot>
            <tr>
                <td>
                    <?php
                        $query_name_slug = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-query-name-and-tables-slug");
                        $next_input_name = BDDS_PLUGIN_PREFIX . "-query-aliases";
                    ?>
                    <a class="button button-primary" href="<?php echo esc_url($query_name_slug); ?>" style="margin-top: 1em;float:left;">Back</a>
                </td>
                <td></td>
                <td>
                    <input type="submit" class="button button-primary" name="<?php echo esc_attr($next_input_name); ?>" value="<?php esc_html_e('Next', 'black-desk'); ?>" style="margin-top: 1em;float:right;">
                </td>
            </tr>
        </tfoot>
    </table>
</form>
