<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<div>
    <?php 
        global $wpdb;

        $query_db_table = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries";
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        $query_id       = isset($_GET["query_id"]) && wp_verify_nonce($nonce, "bdds-delete-query-nonce") ? sanitize_text_field(wp_unslash($_GET["query_id"])) : null;
        $query_name     = $wpdb->get_var( $wpdb->prepare("SELECT `query_name` FROM `$query_db_table` WHERE id=%d", $query_id) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    ?>

    <h2>
        <?php esc_html_e('Are you sure you want to delete query:', 'black-desk')?>
        <span style="color:red"><?php echo esc_html($query_name); ?></span>
    </h2>

    <form method="post">
        <input type="submit" name="yes-delete-query" value="Yes" class="button button-primary" >
        <input type="submit" name="no-delete-query" value="No" class="button button-primary" >
        <input type="hidden" name="query-id-delete" value="<?php echo esc_attr($query_id); ?>">
    </form>
</div>