<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    require_once BDDS_PLUGIN_DIR . "admin/classes/Query.php";

    global $wpdb;

    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST) && wp_verify_nonce($nonce, "create-select-query-nonce")) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r

    }

    $session_variables = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]) ? sanitize_text_field($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]) : null;
    $post_array        = map_deep($_POST, 'sanitize_text_field');
    $wp_tables_prefix  = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";
    
    if(isset($_POST["save-condition"])) {
        if (isset($_GET["action"]) && $_GET["action"] == "edit" && isset($_GET["query_id"])) {
            $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))) : null;
            $conditions_object = $query_object->getConditionsObject();
        
        } else $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"]) 
                                  ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"])))
                                  : new BDDS_Where;
        
        $conditions_arr = array();
        foreach($post_array as $post_key=>$post_value) {
            if(str_starts_with($post_key, "condition_operator_")) $conditions_arr["condition_operator_0"] = $post_value;
            if(str_starts_with($post_key, "condition_field_name_")) $conditions_arr["condition_field_name_0"] = $post_value;
            if(str_starts_with($post_key, "field_condition_")) $conditions_arr["field_condition_0"] = $post_value;
            if(str_starts_with($post_key, "field_value_type_")) $conditions_arr["field_value_type_0"] = $post_value;
            if(str_starts_with($post_key, "field_value_select_")) $conditions_arr["field_value_select_0"] = $post_value;
            if(str_starts_with($post_key, "field_value_text_")) $conditions_arr["field_value_text_0"] = $post_value;
        
        }
       
        $conditions_object->setConditionsWithKeys($conditions_arr);

        if (isset($_GET["action"]) && $_GET["action"] == "edit" && isset($_GET["query_id"])) { 
            $query_object->setConditionsObject($conditions_object);
            
            $_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"] = serialize($query_object);    
        
        } else $_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"] = serialize($conditions_object);
        
    }

?>
<div class="wrap">
    <h2>Query conditions</h2>
    <form method="post">
        <table class="wp-list-table widefat fixed striped table-view-excerpt pages " style="margin-top: 1em;">
        <?php if(!isset($_GET["action"]) && !isset($_GET["query_id"])) { ?>
                <thead>
                    <tr>
                        <th><?php esc_html_e('Logical Operator', 'black-desk'); ?></th>
                        <th><?php esc_html_e('Column Name', 'black-desk'); ?></th>
                        <th><?php esc_html_e('Condition', 'black-desk'); ?></th>
                        <th><?php esc_html_e('Value Type', 'black-desk'); ?></th>
                        <th><?php esc_html_e('Value', 'black-desk'); ?></th>
                        <th><?php esc_html_e('Action', 'black-desk'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $conditions_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["conditions_object"]))) : null;
                        $conditions        = isset($conditions_object) ? $conditions_object->getConditions() : array();
                        $condition_ids     = array();

                        foreach($conditions as $key=>$condition_array) {
                            $condition_id = trim($key, "condition_");
                            $operator     = isset($condition_array["condition_operator_0"]) ? $condition_array["condition_operator_0"] : '';
                            $field_name   = isset($condition_array["condition_field_name_0"]) ? $condition_array["condition_field_name_0"] : '';
                            $condition    = isset($condition_array["field_condition_0"]) ? $condition_array["field_condition_0"] : '';
                            $type         = isset($condition_array["field_value_type_0"]) ? $condition_array["field_value_type_0"] : '';
                            $value_select = !empty($condition_array["field_value_select_0"]) ? $condition_array["field_value_select_0"] : '';
                            $value_text   = !empty($condition_array["field_value_text_0"]) ? $condition_array["field_value_text_0"] : '';

                            $remove_condition_arg = add_query_arg(array(
                                "page" => BDDS_PLUGIN_PREFIX . "-query-delete-condition-slug",
                                "condition_id" => $condition_id
                            )); 

                            echo "<tr>";
                                echo "<td>" . esc_html(strtoupper($operator)) . "</td>";
                                echo "<td>" . esc_html($field_name) . "</td>";
                                echo "<td>" . esc_html($condition) . "</td>";
                                echo "<td>" . esc_html($type) . "</td>";
                                echo "<td>";
                                    echo empty($value_select) ? esc_html($value_text) : esc_html(str_replace($wp_tables_prefix, '', $value_select));
                                echo "</td>";
                                echo "<td>";
                                    echo "<a href='" . esc_url($remove_condition_arg) . "' style='color:red;'>Remove</a>";
                                echo "</td>";
                            echo "</tr>";
                        }
                        
                    ?>
            <?php } else if (isset($_GET["action"]) && $_GET["action"] == "edit" && isset($_GET["query_id"])) {
                        if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true" && isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"])) { 
                            echo "Session edit variables: ";
                            print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                        }
                        
                        $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]) 
                                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))) 
                                : null;

                        $fields_object     = $query_object->getFieldsObject();
                        $tables_object     = $query_object->getTablesObject();
                        $conditions_object = $query_object->getConditionsObject();
                        $conditions        = isset($conditions_object) ? $conditions_object->getConditions() : array();
                        $fields            = isset($fields_object) ? $fields_object->getFields() : array();
                        $selected_tables   = isset($tables_object) ? $tables_object->getTables() : array();
            ?>

                    <thead>
                        <tr>
                            <th><?php esc_html_e('Logical Operator', 'black-desk'); ?></th>
                            <th><?php esc_html_e('Column Name', 'black-desk'); ?></th>
                            <th><?php esc_html_e('Condition', 'black-desk'); ?></th>
                            <th><?php esc_html_e('Value Type', 'black-desk'); ?></th>
                            <th><?php esc_html_e('Value', 'black-desk'); ?></th>
                            <th><?php esc_html_e('Action', 'black-desk'); ?></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php 
                            $id = 1;

                            foreach($conditions as $key=>$condition) {   
                                $condition_id    = trim($key, "condition_");
                                $operator        = isset($condition["condition_operator_0"]) ? $condition["condition_operator_0"] : '';
                                $field_name      = isset($condition["condition_field_name_0"]) ? $condition["condition_field_name_0"] : '';
                                $field_condition = isset($condition["field_condition_0"]) ? $condition["field_condition_0"] : '';
                                $type            = isset($condition["field_value_type_0"]) ? $condition["field_value_type_0"] : '';
                                $value_select    = isset($condition["field_value_select_0"]) ? $condition["field_value_select_0"] : '';
                                $value_text      = ( isset($condition["field_value_text_0"]) || $condition["field_value_text_0"] == 0 ) ? $condition["field_value_text_0"] : '';
                                $value           = ($type == "var") ? $value_text : $value_select;
                                
                                $selected_or  = ($operator == "or") ? "selected" : '';
                                $selected_and = ($operator == "and") ? "selected" : '';
                                
                                $selected_equal    = ($field_condition == 'Equal to') ? "selected" : '';
                                $selected_gt       = ($field_condition == 'Greater than') ? "selected" : '';
                                $selected_lt       = ($field_condition == 'Less than') ? "selected" : '';
                                $selected_gte      = ($field_condition == 'Greater than or equal to') ? "selected" : '';
                                $selected_lte      = ($field_condition == 'Less than or equal to') ? "selected" : '';
                                $selected_notequal = ($field_condition == 'Not Equal to') ? "selected" : '';
                                $selected_like     = ($field_condition == 'Like') ? "selected" : '';

                                $remove_condition_arg = add_query_arg(array(
                                    "page" => BDDS_PLUGIN_PREFIX . "-query-delete-condition-slug",
                                    "condition_id" => $condition_id
                                )); 

                                echo "<tr>";
                                    echo "<td>";
                                    if(!empty($operator)) {
                                        echo "<select name='condition_operator_" . esc_attr($condition_id) . "'>";
                                            echo "<option value='and' " . esc_attr($selected_and) . ">AND</option>";
                                            echo "<option value='or' " . esc_attr($selected_or) . ">OR</option";
                                        echo "</select>";
                                    }
                                    echo "</td>";

                                    echo "<td>" ;
                                        echo "<select name='condition_field_name_" . esc_attr($condition_id) . "' style='width: 100%;'>";
                                            foreach($fields as $field) {
                                                // $field = str_replace('.', '_', $field);
                                                echo ($field == $field_name) 
                                                    ? "<option value='" . esc_attr($field) . "' selected>" . esc_html($field) . "</option>" 
                                                    : "<option value='" . esc_attr($field) . "'>" . esc_html($field) . "</option>";
                                            }
                                        echo "</select";
                                    echo "</td>";

                                    echo "<td>";
                                        echo "<select name='field_condition_" . esc_attr($condition_id) . "' style='width: 100%;'>";
                                            echo "<option value='Equal to' " . esc_attr($selected_equal) . ">Equal to</option>";
                                            echo "<option value='Greater than' " . esc_attr($selected_gt) . ">Greater than</option>";
                                            echo "<option value='Less than' " . esc_attr($selected_lt) . ">Less than</option>";
                                            echo "<option value='Greater than or equal to' " . esc_attr($selected_gte) . ">Greater than or equal to</option>";
                                            echo "<option value='Less than or equal to' " . esc_attr($selected_lte) . ">Less than or equal to</option>";
                                            echo "<option value='Not Equal to' " . esc_attr($selected_notequal) . ">Not Equal to</option>";
                                            echo "<option value='Like' " . esc_attr($selected_like) . ">Like</option>";
                                        echo "</select>";
                                    echo "</td>";

                                    echo "<td>";
                                        echo "<select name='field_value_type_" . esc_attr($condition_id) . "' style='width: 100%;' id='field_value_type_" . esc_attr($id) . "'>";
                                            echo  ($type == "var") ? "<option value='var' selected>VAR</option>" : "<option value='var'>VAR</option>";
                                            echo  ($type == "field") 
                                                    ? "<option value='field' selected>FIELD</option>" 
                                                    : "<option value='field'>FIELD</option>";
                                        echo "</select>";
                                    echo "</td>";

                                    echo "<td>";
                                        $input_hidden = ($type == "var") ? '' : "display:none;";
                                        $select_hidden = ($type == "field") ? '' : "display:none;";
                                        echo "<input type='text' name='field_value_text_" . esc_attr($condition_id) . "' id='field_value_text_" . esc_attr($id) . "' style='width:100%;" . esc_attr($input_hidden) . "' value='" . esc_attr($value) . "'>";

                                        echo "<select name='field_value_select_" . esc_attr($condition_id) . "' id='field_value_select_" . esc_attr($id) . "' style='width:100%;" . esc_attr($select_hidden) . "'>";
                                            echo "<option value=''>-Choose a field-</option>";
                                            foreach( $selected_tables as $selected_table ) {
                                                $table_structure_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                                    $wpdb->prepare( "DESC `$selected_table`"), // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                                    OBJECT 
                                                );
                            
                                                foreach( $table_structure_result as $table_struct ) {
                                                    $option_value = $selected_table . ".$table_struct->Field";
                                                    $value = ($type == "field") ? $value : null;
                                                    $is_selected = ($option_value == $value) ? "selected" : '';
        
                                                    echo "<option value='" . esc_attr($option_value) . "' " . esc_attr($is_selected) . " >";
                                                        echo esc_html(str_replace( $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $selected_table )) . "." . esc_html($table_struct->Field);
                                                    echo "</option>";
                                                }
                                            }
                                        echo "</select>";
                                    echo "</td>";

                                    echo "<td>";
                                        echo "<a href='" . esc_url($remove_condition_arg) . "' style='color:red;padding:1em;'>Remove</a>";
                                    echo "</td>";
                                echo "</tr>";
                                $id++;  
                            }
                        ?>
                    </tbody>
                    <?php } ?>
                    <tr>
                    <?php 
                    // Start add new conditon
                        $table_column_name = isset($_POST["table-column-name"]) ? sanitize_text_field(wp_unslash($_POST["table-column-name"])) : null; 
                        $number_of_conditions = isset($conditions_object) ? count($conditions_object->getConditions()) : 0;
                        if( $number_of_conditions > 0 ) { ?>
                            <td>
                                <select name="condition_operator_">
                                    <option value="and">AND</option>
                                    <option value="or">OR</option>
                                </select>
                            </td>
                    <?php } else { ?>
                            <td></td>
                    <?php } ?>

                        <?php 
                            $fields_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))) : null;
                            $tables_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["tables_object"]))) : null;

                            if (isset($_GET["action"]) && $_GET["action"] == "edit" && isset($_GET["query_id"])) {
                                $tables_object = $query_object->getTablesObject();
                                $fields_object = $query_object->getFieldsObject();
                            }

                            $selected_tables = isset($tables_object) ? $tables_object->getTables() : array();
                            $selected_fields = isset($fields_object) ? $fields_object->getFields() : array();
                        ?>

                        <td>
                            <select name="condition_field_name_" style="width: 100%;">
                                <?php 
                                    foreach( $selected_fields as $selected_field ) { 
                                        // $selected_field = str_replace('.', '_', $selected_field);
                                        echo "<option value='" . esc_attr($selected_field) . "'>" . esc_html($selected_field) . "</option>";
                                    }
                                ?>
                            </select>
                        </td>

                        <td>
                            <select name="field_condition_" style="width: 100%;">
                                <option value="Equal to" >Equal to</option>
                                <option value="Greater than" >Greater than</option>
                                <option value="Less than" >Less than</option>
                                <option value="Greater than or equal to" >Greater than or equal to</option>
                                <option value="Less than or equal to" >Less than or equal to</option>
                                <option value="Not Equal to" >Not Equal to</option>
                                <option value="LIKE" >Like</option>
                            </select>
                        </td>

                        <td>
                            <select name="field_value_type_"  id="field_value_type_0" style="width: 100%;">
                                <option value="var">VAR</option>
                                <option value="field">FIELD</option>
                            </select>
                        </td>

                        <td>
                            <select name="field_value_select_" id="field_value_select_0" style="display: none;width: 100%;">
                                <option value=''>Choose a field</option>
                                <?php
                                    foreach( $selected_tables as $selected_table ) {
                                        $table_structure_result = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                            $wpdb->prepare( "DESC `$selected_table`"), // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                                            OBJECT
                                        );
                    
                                        foreach( $table_structure_result as $table_struct ) {
                                            $option_value = $selected_table . ".$table_struct->Field";
                                            $session_value = (isset($session_field_value_select)) ? $session_field_value_select : null;
                                            $is_selected = ($option_value == $session_value) ? "selected" : '';

                                            echo "<option value='" . esc_attr($option_value) . "' " . esc_attr($is_selected) . " >";
                                                echo esc_html(str_replace( $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_", '', $selected_table )) . "." . esc_html($table_struct->Field);
                                            echo "</option>";
                                        }
                                    }
                                ?>
                            </select>
                            <input type="text" name="field_value_text_" 
                            id="field_value_text_0" 
                            style="width: 100%;"
                            >
                        </td>

                        <td>
                            <input type="submit" name="save-condition" value="Add" class="button button-primary">
                        </td>
                    </tr>
                </tbody>
            <?php wp_nonce_field("bdds-query-edit-preview-nonce"); ?>
        </table>
        <div style="margin-top: 1em;">
        <?php 
            $back_query_aliases_arg = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-aliases-slug"); 
            $next_input_name = (isset($_GET["action"]) && isset($_GET["query_id"]) && $_GET["action"] == "edit") ? BDDS_PLUGIN_PREFIX . "-preview-edit" : BDDS_PLUGIN_PREFIX . "-query-preview";
        ?>
            <a href="<?php echo esc_url($back_query_aliases_arg); ?>" class="button button-primary">Back</a>
            <input type="submit" value="Next" class="button button-primary" name="<?php echo esc_attr($next_input_name); ?>" style="float: right;">
        </div>
    </form>
</div>