<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    require_once BDDS_PLUGIN_DIR . "admin/classes/Query.php";
    global $wpdb;

    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"])) print_r(map_deep(($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]), 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST) && wp_verify_nonce($nonce, "create-select-query-nonce")) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r

    }

    $tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX;
    $query_name = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"]) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["query_name"])) : null;

    $fields_object    = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]["fields_object"]))) : null;
    $selected_fields  = isset($fields_object) ? $fields_object->getFields() : array();
    $aliases = isset($fields_object) ? $fields_object->getAliases() : array();

?>

<form method="post" class="form-table">
        <h2><?php esc_html_e('Field aliases', 'black-desk'); ?></h2>
        <table>
        <?php if(!isset($_GET["action"]) && !isset($_GET["query_id"])) { ?>
            <tbody>
                <?php
                    foreach( $selected_fields as $key=>$selected_field ) { ?>
                        <?php 
                            $selected_field = str_replace('.', '_', $selected_field);
                            $created_aliases = !empty($fields_object->getAliases()) ? $fields_object->getAliases() : null;
                            $created_alias = isset($created_aliases["field_alias_$selected_field"]) ? $created_aliases["field_alias_$selected_field"] : null;
                        ?>
                        <tr>
                            <th scope="row"><b><?php echo esc_html($selected_field); ?></b>&nbsp;</th>
                            <td>
                                <input type='text' 
                                    id="field_alias_<?php echo esc_attr($selected_field); ?>" 
                                    name="field_alias_<?php echo esc_attr($selected_field); ?>"
                                    value="<?php echo (!empty($created_aliases) && $selected_field != $created_alias) ? 
                                            esc_attr(str_replace('.', '_', $created_alias)) : '';?>"
                                    class="regular-text"
                                >
                            </td>
                    <?php } ?>
            </tbody>
        <?php } else if (isset($_GET["action"]) && isset($_GET["query_id"]) && $_GET["action"] == "edit") { ?>
            <?php
                if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true" && isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"])) { 
                    echo "Session edit variables: ";
                    print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
                }    
                
                $query_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]) 
                              ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]))) 
                              : null;

                $fields_object = $query_object->getFieldsObject();
                $aliases       = $fields_object->getAliases();
                $fields        = $fields_object->getFields();
            ?>
            <tbody>
                <?php 
                    foreach($fields as $key=>$field) {
                        $field_name = str_replace('.', '_', $field);
                        if(!isset($aliases["field_alias_$field_name"])) $aliases["field_alias_$field_name"] = $field_name;
                        $alias = ($field_name != $aliases["field_alias_$field_name"]) ? $aliases["field_alias_$field_name"] : '';

                        echo "<tr>";
                            echo "<th>" . esc_html($field_name) . "</th>";
                            echo "<td>";
                                echo "<input type='text' name='field_alias_" . esc_attr($field_name) . "' value='" . esc_attr($alias) . "' class='regular-text'>";
                            echo "</td>";
                        echo "</tr>";
                    }
                ?>
            </tbody>

        <?php } ?>
            <tfoot>
                <tr>
                    <td>
                        <?php 
                            $back_to_fields_arg = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-query-fields-slug");
                            $next_input_name    = BDDS_PLUGIN_PREFIX . "-query-conditions";
                        ?>
                        <input type="submit" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX . "-edit-back-from-aliases"); ?>" 
                         class="button button-primary" style="margin-top: 1em;"
                         value="<?php esc_attr_e('Back', 'black-desk'); ?>"
                        >
                    </td>

                    <td>
                        <input type="submit" id="next-button" class="button button-primary" 
                         name="<?php echo esc_attr($next_input_name); ?>" 
                         value="<?php esc_attr_e('Next', 'black-desk'); ?>" 
                         style="margin-top: 1em;margin-left: 1em;float:right;"
                        >
                    </td>
                </tr>
            </tfoot>
        </table>

</form>