<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    global $wpdb;
    // unset($_SESSION[BDDS_PLUGIN_PREFIX . "_query_variables"]);
    if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"])) unset($_SESSION[BDDS_PLUGIN_PREFIX . "_edit_variables"]["query_object"]);
    $queries_table_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries";
    $add_query_url = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-query-clean-slug");
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;

    $order_by = "query_name";
    if(isset($_GET["order"]) && $_GET["order"] == "asc" && wp_verify_nonce($nonce, "query-orderby-nonce")) {
        $order = "desc";

    } else if (isset($_GET["order"]) && $_GET["order"] == "desc" && wp_verify_nonce($nonce, "query-orderby-nonce")) {
        $order = "asc";

    } else {
        $order = "asc";

    }

    $order_query_arg = add_query_arg(array(
        "orderby" => $order_by,
        "order" => $order
    ));
?>


<div class="wrap">
    <div style="margin-bottom: 1em;">
        <h1 >Queries</h1>
        <h1 class="wp-heading-inline">Create: </h1>
        <a class="page-title-action" href="<?php echo esc_url(wp_nonce_url($add_query_url, "create-select-query-nonce")); ?>">SELECT</a>
        <a class="page-title-action disbled-anchor">INSERT</a>
        <a class="page-title-action disbled-anchor">DELETE</a>
        <a class="page-title-action disbled-anchor">UPDATE</a>
    </div>

    <table class="wp-list-table widefat fixed striped table-view-list pages">
        <thead>
            <th style="width:20px;"><a><?php esc_html_e('ID', 'black-desk'); ?></a></th>
            <th class="manage-column column-title column-primary sorted <?php echo esc_attr($order); ?>">
                <a href="<?php echo esc_url(wp_nonce_url($order_query_arg, "query-orderby-nonce")); ?>">
                    <span><?php esc_html_e('Query Name', 'black-desk'); ?></span>
                    <span class="sorting-indicators">
                        <span class="sorting-indicator asc" aria-hidden="true"></span>
                        <span class="sorting-indicator desc" aria-hidden="true"></span>
                    </span>
                </a>
            </th>
            <th>
                <a><?php esc_html_e('Query Type', 'black-desk'); ?></a>
            </th>

        </thead>

        <tbody>
            <?php
                // $select_queries_sql = "SELECT * FROM $queries_table_name ORDER BY $order_by $order";
                $queries_records    = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare( "SELECT * FROM `$queries_table_name` ORDER BY $order_by $order" ) // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
                );

                foreach( $queries_records as $query_record ) {
                    $query_id_delete_arg = add_query_arg(array(
                        "query_id" => $query_record->id,
                        "page" => BDDS_PLUGIN_PREFIX . "-query-delete-query-slug"
                    ));

                    $query_id_preview_arg = add_query_arg(array(
                        "query_id" => $query_record->id,
                        "page" => BDDS_PLUGIN_PREFIX . "-query-preview-slug"
                    ));

                    $query_id_edit_arg = add_query_arg(array(
                        "query_id" => $query_record->id,
                        "page" => BDDS_PLUGIN_PREFIX . "-query-clean-slug",
                        "action" => "edit"
                    ));

                    // for now we only have SELECT query type
                    $query_type = (str_starts_with($query_record->query, "SELECT")) ? "SELECT" : null;

                    echo "<tr>";
                        echo "<td>" . esc_html($query_record->id) . "</td>";
                        echo "<td>";
                            echo esc_html($query_record->query_name);
                            echo "<div class='row-actions'>
                            <a href='" . esc_url(wp_nonce_url($query_id_preview_arg, 'bdds-query-id-preview')) . "'>View</a> | 
                            <a href='" . esc_url(wp_nonce_url($query_id_edit_arg, "bdds-edit-query-nonce")) . "'>Edit</a> |
                            <a style='color:red;' href='" . esc_url(wp_nonce_url($query_id_delete_arg, "bdds-delete-query-nonce")) . "'>Delete</a></div>";
                        echo "</td>";
                        echo "<td>" . esc_html($query_type) . "</td>";
                    echo "</tr>";
                }
            ?>
        </tbody>
    </table>
</div>
