<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    require_once BDDS_PLUGIN_DIR . "admin/classes/tables/BDDS_Column.php";
    require_once BDDS_PLUGIN_DIR . "admin/classes/tables/BDDS_Columns.php";
    require_once BDDS_PLUGIN_DIR . "admin/classes/BDDS_Helpers.php";

    global $wpdb;

    $query_success     = false;
    $wp_tables_prefix  = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";
    $charset_collate   = $wpdb->get_charset_collate();
    $table_name        = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_name"])
        ? $wp_tables_prefix . sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_name"]))
        : '';
    $table_description = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_description"])
        ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_description"]))
        : '';
    $columns_object    = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]["columns"]) ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]["columns"]))) : null;
    $columns           = isset($columns_object) ? $columns_object->getColumns() : array();
    $break             = 0;

    // begin create table query string
    $sql = "CREATE TABLE $table_name (
  id bigint(20) AUTO_INCREMENT NOT NULL,\n";

    $columns_array = array();
    $lookup_tables = array();

    // append fields to query string
    foreach($columns as $key=>$column)
    {
        $column_id       = end(explode('_', $key));
        $column_name     = $column->getColumnName();
        $column_type     = $column->getColumnType();
        $column_null     = (null !== $column->getColumnNull()) ? $column->getColumnNull() : null;
        $column_default  = (null !== $column->getColumnDefault()) ? $column->getColumnDefault() : null;
        $column_lookup   = (null !== $column->getColumnLookup()) ? $column->getColumnLookup() : null;
        $enum_values     = (null !== $column->getColumnEnumValues()) ? $column->getColumnEnumValues() : null;
        $enum_values_str = '';

        // validate default value for column
        $validate_input = BDDS_Admin::validate_data($column_type, $column_default, $column_name);
        if($validate_input != "valid") {
            echo "<div class='notice notice-error'>" . esc_html($is_valid_input) . "</div>";
            $break = 1;
            break;
        }

        if($column_type == "ENUM" && !empty($enum_values)) {
            foreach($enum_values as $enum_value) {
                if(str_contains($enum_value, "'")) {
                    $enum_value = stripcslashes($enum_value);
                    $enum_value = str_replace("'", "\'", $enum_value);
                }
                if(str_contains('"', $enum_value)) {
                    $enum_value = stripcslashes($enum_value);
                    $enum_value = str_replace('"', '\"', $enum_value);
                }
                $enum_values_str .= "'" . $enum_value . "',";
            }

            $enum_values_str = rtrim($enum_values_str, ',');

        } else if($column_type == "Date time") $column_default = str_replace('T', ' ', $column_default);
          else if($column_type == "Yes no" && $column_default == "Yes") $column_default = 1;
          else if($column_type == "Yes no" && $column_default == "No") $column_default = 0;

        $column_null = ($column_null != "on") ? "NOT NULL" : "NULL";

        // switch colum type to mysql data type
        $column_type = BDDS_Helpers::switchTypeForSQL($column_type);

        array_push( $columns_array, array( "id" => $column_id, "name" => $column_name, "type" => $column_type ) );
        if( isset($column_lookup)) array_push($lookup_tables, array("column_" . ($column_id + 2) => $column_lookup));


        if ( $column_type == "ENUM" ) {
            $sql .= "  $column_name ENUM($enum_values_str) $column_null,\n";

        } else{
            if ( $column_null != '' && $column_default != '' ) {
                $sql .= ($column_type == "bit(1)")
                      ? "  $column_name $column_type DEFAULT $column_default $column_null,\n"
                      : "  $column_name $column_type DEFAULT '$column_default' $column_null,\n";

            } else if ( $column_default != '' && $column_null == '' ) {
                $sql .= ($column_type == "bit(1)")
                      ? "  $column_name $column_type DEFAULT $column_default $column_null,\n"
                      : "  $column_name $column_type DEFAULT '$column_default' $column_null,\n";

            } else if ( $column_null != '' && $column_default == '' ) {
                $sql .= "  $column_name $column_type $column_null,\n";

            } else {
                $sql .= "  $column_name $column_type,\n";
            }
        }
    }

// this variable needs to be close to left because of dbDelta syntax
// dbDelta does not tolerate unnecessary spaces in string which function accepts
// if this variable is away from left side, IDE adds unnecessary spaces which can lead to query error
$sql .= "  created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
  updated_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
  deleted_at datetime NULL,
  PRIMARY KEY  (id)
) $charset_collate  COMMENT='$table_description';";

    // execute create table query with dbDelta
    if( $break == 0 ) dbDelta( $sql );

    if( empty( $wpdb->last_error ) ) {
        // table is created without any errors, now we save structure to bdds metadata table
        $json_metadata = array(
            "columns" => $columns_array,
            "lookup_tables" => $lookup_tables
        );

        $table_metadata_name = $wpdb->prefix . BDDS_PLUGIN_PREFIX . '_table_metadata';

        if( $break == 0 ) {
            // insert values to metadata table
            $wpdb->insert( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
                $table_metadata_name,
                array(
                    'table_name' => $table_name,
                    'metadata' => wp_json_encode( $json_metadata ),
                )
            );

            // unset session variables
            $_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . '_create_started'] = 0;
            unset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]);
            // if query_success is true, redirect user to all tables page
            $query_success = true;

        } else $query_success = false;

    } else {
        BDDS_Admin::get_instance()->bdds_set_admin_notice(
            esc_html($wpdb->last_error), 'error'
        );
    }

    $wpdb->hide_errors();
