<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    $column_id = isset($_GET["column_id"]) && wp_verify_nonce($nonce, "remove-table-column") ? sanitize_text_field(wp_unslash($_GET["column_id"])) : null
?>

<form method="post">
    <h3>Are you sure you want to delete "<?php echo esc_html($column_id); ?>"</h3>
    <input type="submit" class="button button-primary" name="yes-delete-column" value="Yes">
    <input type="submit" class="button button-primary" name="no-delete-column" value="No">
    <input type="hidden" name="column_id" value="<?php echo esc_attr($column_id); ?>">
    <?php wp_nonce_field("table-delete-column"); ?>
</form>