<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;

    require_once BDDS_PLUGIN_DIR . "admin/classes/tables/BDDS_Column.php";
    require_once BDDS_PLUGIN_DIR . "admin/classes/tables/BDDS_Columns.php";

    $nonce = isset($_GET["_wpnonce"]) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET["_wpnonce"])) , "bdds-add-table-nonce") ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST) && wp_verify_nonce($nonce, "bdds-add-table-nonce")) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo "<br>";
    }

    $table_name = (isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_name"])) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_name"])) : '';
    $table_collation = (isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_collation"])) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_collation"])) : '';
    $table_description = (isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_description"])) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"][BDDS_PLUGIN_PREFIX . "_table_description"])) : '';
?>
<h2 style="display:inline-block;"><?php esc_html_e('Table Name', 'black-desk'); ?> - </h2> <p style="display:inline-block"> <b> <?php echo esc_html($table_name); ?> </b> </p> <br>
<h2 style="display:inline-block;">Collation - </h2> <p style="display:inline-block"> <b> <?php echo esc_html($table_collation); ?> </b> </p> <br>
<h2 style="display:inline-block;"><?php esc_html_e('Table description', 'black-desk'); ?> - </h2>
<span style="display: inline;"> <?php echo esc_html($table_description); ?> </span>

<div class="wrap">
    <table class="wp-list-table widefat fixed striped table-view-list pages">
        <thead>
            <th><?php esc_html_e('Column Name', 'black-desk'); ?></th>
            <th><?php esc_html_e('Column Type', 'black-desk'); ?></th>
        </thead>
        <tbody>
            <?php
                $columns_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]["columns"])
                                ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]["columns"])))
                                : null;
                $columns = isset($columns_object) ? $columns_object->getColumns() : array();

                foreach($columns as $key=>$column) {
                    $column_name = $column->getColumnName();
                    $column_type = $column->getColumnType();
    
                    echo "<tr>";
                        echo "<td>" . esc_html($column_name) . "</td>";
                        echo "<td>" . esc_html($column_type) . "</td>";
                    echo "</tr>";
                }
            ?>
        </tbody>
    </table>
    
    <form method="POST">
        <div style="margin-top: 1em;">
            <input type="submit" class="button button-primary" name="add_more_columns" value="<?php esc_attr_e('Add more columns', 'black-desk')?>" name="back">
            <input type="submit" class="button button-primary" value="<?php esc_attr_e('Save', 'black-desk')?>" name="preview_save_columns" style="float: right;">
        </div>
    </form>
</div>