<?php
    if ( ! defined( 'ABSPATH' ) ) exit;

    global $wpdb;
    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST) && wp_verify_nonce($nonce, "bdds-add-table-nonce")) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
    }

    $url = add_query_arg("page", BDDS_PLUGIN_PREFIX . "-add-table-columns-slug");
    $s_table_name = (isset($_SESSION[BDDS_PLUGIN_PREFIX . '_variables'][BDDS_PLUGIN_PREFIX . '_table_name'])) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . '_variables'][BDDS_PLUGIN_PREFIX . '_table_name'])) : '';
    $s_table_desc = (isset($_SESSION[BDDS_PLUGIN_PREFIX . '_variables'][BDDS_PLUGIN_PREFIX . '_table_description'])) ? sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . '_variables'][BDDS_PLUGIN_PREFIX . '_table_description'])) : '';
    // unset($_SESSION['bdds_variables']);

    if( isset($_SESSION[BDDS_PLUGIN_PREFIX . '_create_started']) && $_SESSION[BDDS_PLUGIN_PREFIX . '_create_started'] != 1 ) {
        unset($_SESSION[BDDS_PLUGIN_PREFIX . '_variables']);
    }

    $table_name = isset($_POST[BDDS_PLUGIN_PREFIX . '_table_name']) && wp_verify_nonce($nonce, "bdds-add-table-nonce") ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . '_table_name'])): '';
    $tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";
    $table_name = $tables_prefix . $table_name;
    $show_table_sql = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_name)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
    $table_name_without_prefix = str_replace($tables_prefix, '', $table_name);

?>

<h2><?php esc_html_e('Add Table Name', 'black-desk'); ?></h2>

<?php
    // user did not enter a table name, display error
    if(empty($_POST[BDDS_PLUGIN_PREFIX . '_table_name']) && isset($_POST[BDDS_PLUGIN_PREFIX . '_table_name'])) {
        BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(
            esc_html__('Empty table name', 'black-desk'), 'error'
        );
    }

    // table name already exists, display error
    if($table_name == $show_table_sql) {
        /* translators: %s: name of the table without plugin prefix */
        BDDS_Admin::get_instance()->bdds_set_and_display_admin_notice(sprintf(
            esc_html__("Table name \"%s\" already exists", 'black-desk'), $table_name_without_prefix
        ), 'error');
    }
?>

<form method="POST" action="">
    <table class="form-table">
        <tbody id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-body">
            <tr>
                <th>
                    <label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>_table_name"><?php esc_html_e('Table Name', 'black-desk'); ?> <span style="color:red;">*</span></label>
                </th>
                <td>
                    <input
                        type="text"
                        name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>_table_name"
                        id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>_table_name"
                        class="regular-text"
                        required
                        pattern="^[a-z0-9_]+$"
                        value="<?php echo esc_attr($s_table_name); ?>"
                        title="<?php esc_attr_e('Only lowercase Latin letters, underscore and numbers', 'black-desk'); ?>"
                    >
                    <br>
                    <?php if($table_name == $show_table_sql) {
                        /* translators: %s: name of the table without plugin prefix */
                        echo "<span style='color:red;'>" . sprintf(esc_html__("Table name \"%s\" already exists", 'black-desk'), esc_html($table_name_without_prefix)) . "!</span>";
                    }?>
                </td>
            </tr>

            <tr>
                <th><?php esc_html_e('Table Description', 'black-desk'); ?></th>
                <td>
                    <textarea id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-description" class="regular-text" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-description" rows="4" cols="50"
                        placeholder="<?php esc_attr_e('Enter table description', 'black-desk'); ?>"
                    ><?php echo esc_textarea($s_table_desc);?></textarea>
                </td>
            </tr>

            <tr>
                <th>Collation</th>
                <td>
                    <select id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-collation" class="regular-text" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-table-collation">
                        <option><?php echo esc_html(str_replace( "DEFAULT CHARACTER SET", "", $wpdb->get_charset_collate() )); ?></option>
                    </select>
                </td>
            </tr>

        </tbody>

        <tfoot>
            <tr>
                <td>
                    <input type="submit" class="button button-primary" name="table_name_next" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-next-button" value="<?php esc_attr_e('Next', 'black-desk'); ?>">
                </td>
            </tr>
        </tfoot>
        <?php wp_nonce_field('table-name-nonce'); ?>
    </table>
</form>
