<?php 
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    require_once BDDS_PLUGIN_DIR . "admin/classes/tables/BDDS_Column.php";
    require_once BDDS_PLUGIN_DIR . "admin/classes/tables/BDDS_Columns.php";
    global $wpdb;

    $nonce = isset($_GET["_wpnonce"]) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET["_wpnonce"])) , "bdds-add-table-nonce") ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
    if(get_option(BDDS_PLUGIN_PREFIX . "_show_debug") == "true") {
        echo "Session: ";
        if(isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"])) print_r(map_deep($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"], 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
        echo " Post: ";
        if(isset($_POST) && wp_verify_nonce($nonce, "bdds-add-table-nonce")) print_r(map_deep($_POST, 'sanitize_text_field')); //phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_print_r
    }

    $tables_prefix = $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_";

 ?>


<h2>
    <?php esc_html_e('Add Table Columns', 'black-desk'); ?>
</h2>

<?php 
    $current_name = isset($_POST[BDDS_PLUGIN_PREFIX . "-column-name"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-column-name"])) : '';
    $current_type = isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-column-type"])) : null;
?>

<div class="wrap">
    <form method="post" action="" id="new-column-form">
        <table class="form-table">
            <tbody id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-table-body">
                <tr>
                    <th><?php esc_html_e('Column Name', 'black-desk'); ?> <span style="color:red;">*</span></th>
                    <td id="column-name-td">
                        <input type="text" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-name" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-name"
                        pattern="^[a-zA-Z0-9_]+$" required class="regular-text"
                        title="<?php esc_attr_e('Only uppercase and lowercase Latin letters, underscore and numbers', 'black-desk'); ?>"
                        value="<?php echo esc_attr($current_name); ?>">
                    </td>
                </tr>
    
                <tr>
                    <th><?php esc_html_e('Column Type', 'black-desk'); ?> <span style="color:red;">*</span></th>
                    <td id="column-type-td">
                        <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-type" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-type" class="regular-text" required>
                        <?php if(!isset($current_type)) {?>
                            <option value="">
                                -Select a column type-
                            </option>
                        <?php }?>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::SHORT_TEXT); ?>" <?php if ($current_type == BDDS_Type_Constants::SHORT_TEXT) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::SHORT_TEXT); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::NUMBER); ?>" <?php if (str_starts_with($current_type, BDDS_Type_Constants::NUMBER)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::NUMBER); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::BIG_NUMBER); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::BIG_NUMBER)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::BIG_NUMBER); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::CURRENCY); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::CURRENCY)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::CURRENCY); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::DATE_TIME); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::DATE_TIME)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::DATE_TIME); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::YES_NO); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::YES_NO)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::YES_NO); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::LOOKUP); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::LOOKUP)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::LOOKUP); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::RICH_TEXT); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::RICH_TEXT)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::RICH_TEXT); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::LONG_TEXT); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::LONG_TEXT)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::LONG_TEXT); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::ATTACHMENT); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::ATTACHMENT)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::ATTACHMENT); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::HYPERLINK); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::HYPERLINK)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::HYPERLINK); ?>
                            </option>
                            <option value="<?php echo esc_attr(BDDS_Type_Constants::ENUM); ?>" <?php if (str_contains($current_type, BDDS_Type_Constants::ENUM)) echo "selected"; ?> >
                                <?php echo esc_html(BDDS_Type_Constants::ENUM); ?>
                            </option>
                        </select>
                    </td>
                </tr>
    
                <tr>
                    <th><?php esc_html_e('Allow Null', 'black-desk'); ?></th>
                    <td id="column-null-checkbox-td">
                        <label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-is-null"></label>
                        <input type="checkbox" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-is-null" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-is-null"
                        <?php if(isset($_POST[BDDS_PLUGIN_PREFIX . "-is-null"]) && $_POST[BDDS_PLUGIN_PREFIX . "-is-null"] == "on") echo "checked";?> >
                    </td>
                </tr>
    
                <tr>
                    <th><?php esc_html_e('Default Value', 'black-desk'); ?></th>
                    <?php if ( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Date time" ) { ?>
                        <td id="column-default-text-td">
                            <input type="datetime-local" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value"
                            id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value" class="regular-text">
                        </td>
                    <?php } else if ( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Yes no" ) { ?>
                        <td id="column-default-text-td">
                            <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value">
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </td>
                    <?php } else if ( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && ( $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Rich text" ||
                    $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Long text" || $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Attachment" )) { ?>
    
                    <?php } else if ( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Hyperlink" ) { ?>
                        <td id="column-default-text-td">
                            <input type="url" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value"
                            class="regular-text">
                        </td>
                    <?php } else if ( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "ENUM" ) { ?>
                        <td>
                            <span>If an <b>ENUM</b> column is declared <b>NOT NULL</b>, its <b>default value</b></span><br>
                            <span>  is the first element of the list of permitted values.</span>
                        </td>
                    <?php } else { ?>
                        <td id="column-default-text-td">
                            <label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value"> </label>
                            <input type="text" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-value"
                            class="regular-text">
                        </td>
                    <?php } ?>
                </tr>
                <?php if( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "Lookup" ) { ?>
                    <tr id="lookup-default-select-td">
                        <th><?php esc_html_e('Lookup table and field', 'black-desk'); ?> <span style="color:red;">*</span></th>
                        <td>
                            <select id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-default-lookup" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-table" >
                            <?php
                                $current_db = $wpdb->dbname;
                                $created_tables = $wpdb->get_results("SHOW TABLES;", ARRAY_A); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                $bdds_tables = array();
    
                                foreach($created_tables as $created_t) {
                                    foreach($created_t as $created_table){
                                        $table_name   = $created_table;
                                        $lookup_table = isset($_POST[BDDS_PLUGIN_PREFIX . "-lookup-table-select"]) ? $tables_prefix . sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-lookup-table-select"])) : '';
    
                                        if(str_contains($table_name, $tables_prefix) && $table_name != $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_table_metadata" &&
                                        $table_name != $wpdb->prefix . BDDS_PLUGIN_PREFIX . "_queries") {
                                            $table_name = str_replace($tables_prefix, '', $table_name);
                                            if(isset($lookup_table) && $lookup_table == $tables_prefix . $table_name ) {
                                                echo "<option value='" . esc_attr($table_name) . "' selected>" . esc_html($table_name) . "</option>";
    
                                            } else {
                                                echo "<option value='" . esc_attr($table_name) . "'>" . esc_html($table_name) . "</option>";
    
                                            }
                                            // push table name in array, later we take first element of that array as default table to display field's for
                                            array_push($bdds_tables, $table_name);
    
                                        }
                                    }
                                }
                            ?>
                            </select>
    
                            <select name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-lookup" >
                                <?php
                                    $post_lookup_table = (isset($_POST[BDDS_PLUGIN_PREFIX . "-lookup-table-select"])) ? sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-lookup-table-select"])) : $bdds_tables[0];
                                    // if user choose lookup table we display field's for that table, else we use default tabel(firs table from array)
                                    $selected_lookup_table = (!empty($post_lookup_table)) ? $tables_prefix . $post_lookup_table : '';
    
                                    // $get_fields_sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '$current_db' AND TABLE_NAME = '$selected_lookup_table';";
    
                                    $selected_table_columns = $wpdb->get_results( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
                                        $wpdb->prepare(
                                            "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = %s AND TABLE_NAME = %s;",
                                            array($current_db, $selected_lookup_table)
                                        )
                                    );

                                    foreach($selected_table_columns as $selected_table) {
                                        $column_name = $selected_table->COLUMN_NAME;
                                        echo "<option value='" . esc_attr($column_name) . "'>" . esc_html($column_name) . "</option>";
                                    }
    
                                ?>
                            </select>
                        </td>
                    </tr>
                <?php } else if( isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) && $_POST[BDDS_PLUGIN_PREFIX . "-column-type"] == "ENUM" ) { ?>
                    <tr>
                        <th>ENUM Values</th>
                        <td id="column-enum-values">
                                <textarea name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-enum-values" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-enum-values" class="regular-text" rows="5"></textarea>
                                <br>
                                <label for="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-enum-values">
                                    <i>All values should be one below another</i>
                                </label>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <p class="submit">
            <input type="submit" name="add_new_column" class="button button-primary" id="add-new-column-button" value="<?php esc_attr_e('Add new column', 'black-desk'); ?>">
        </p>
        <?php wp_nonce_field("bdds-table-columns-nonce"); ?>
    </form>
</div>

<form id="lookup-form" method="post">
    <input type="hidden" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-name" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-name" 
    value="<?php echo isset($_POST[BDDS_PLUGIN_PREFIX . "-column-name"]) ? esc_attr(sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-column-name"]))) : '';?>"> 
    <input type="hidden" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-type" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-column-type" 
    value="<?php echo isset($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]) ? esc_attr(sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-column-type"]))) : '';?>">
    <input type="hidden" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-is-null" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-is-null" 
    value="<?php echo isset($_POST[BDDS_PLUGIN_PREFIX . "-is-null"]) ? esc_attr(sanitize_text_field(wp_unslash($_POST[BDDS_PLUGIN_PREFIX . "-is-null"]))) : '';?>">
    <input type="hidden" id="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-table-select" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-table-select">
    <input type="hidden" name="<?php echo esc_attr(BDDS_PLUGIN_PREFIX); ?>-lookup-type" value="Lookup">
</form>

<?php /* Table which displays created columns and information about created columns */ ?>
<div class="wrap">
    <div style="margin-top: 2em;">
        <table class="wp-list-table widefat fixed striped table-view-list">
            <thead>
                <tr>
                    <th><?php esc_html_e('Column Name', 'black-desk'); ?></th>
                    <th><?php esc_html_e('Column Type', 'black-desk'); ?></th>
                    <th><?php esc_html_e('Null', 'black-desk'); ?></th>
                    <th><?php esc_html_e('Default', 'black-desk'); ?></th>
                    <th><?php esc_html_e('Action', 'black-desk'); ?></th>
                </tr>
            </thead>
        
            <tbody>
                <?php 
                    $columns_object = isset($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]["columns"]) 
                                    ? unserialize(sanitize_text_field(wp_unslash($_SESSION[BDDS_PLUGIN_PREFIX . "_variables"]["columns"]))) 
                                    : array();

                    $columns = !empty($columns_object) ? $columns_object->getColumns() : array();
                    foreach( $columns as $key=>$column ) {
                        $column_id     = end(explode('_', $key));
                        $column_name   = !empty( $column->getColumnName() ) ? $column->getColumnName() : '';
                        $column_type   = !empty( $column->getColumnType() ) ? $column->getColumnType() : '';
                        $is_null       = !empty( $column->getColumnNull() ) ? $column->getColumnNull() : '';
                        $default_value = !empty( $column->getColumnDefault() ) ? $column->getColumnDefault() : '';

                        $remove_column_url = add_query_arg(array(
                            "page" => BDDS_PLUGIN_PREFIX . "-remove-column-slug",
                            "column_id" => $column_id
                        ));
                        $remove_column_url = wp_nonce_url($remove_column_url, "remove-table-column");

                        // when datetime is inserted from input type datetime it adds T instead of space, here we replace T with space
                        $default_value = ($column_type == "Date time") ? str_replace('T', ' ', $default_value) : $default_value;
                        // when checked input checkbox returns on, here we check for on and display NULL to user instead of on
                        $is_null = ($is_null == "on") ? "NULL" : '';

                        echo "<tr>";
                            echo "<td>" . esc_html($column_name) . "</td>";
                            echo "<td>" . esc_html($column_type) . "</td>";
                            echo "<td>" . esc_html($is_null) . "</td>";
                            echo "<td>" . esc_html($default_value) . "</td>";
                            echo "<td>";
                                echo "<a href='" . esc_url($remove_column_url) . "' style='color:red;cursor:pointer;'>";
                                    esc_html_e('Remove', 'black-desk');
                                echo "</a>";
                            echo "</td>";
                        echo "</tr>";
                        
                    }
                ?>
            </tbody>
        
        </table>
    </div>


    <form method="post" style="margin-top: 1em;">
        <div>
            <input type="submit" name="table_name_back" id="table-name-back" class="button button-primary" value="<?php esc_attr_e('Back', 'black-desk'); ?>">
            <input type="submit" name="preview_table" class="button button-primary" id="preview-table-button" value="<?php esc_attr_e('Preview table', 'black-desk'); ?>" style="float: right;">
            <?php wp_nonce_url("bdds-add-column-nonce")?>
        </div>
    </form>
</div>