<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<form method="post" action="">
    <div class="tablenav top">
        <div class="alignleft actions bulkactions" name="action_trash">
            <select value="Bulk actions" name='doaction_trash'>
                <option><?php esc_html_e('Bulk actions', 'black-desk'); ?></option>
                <option value="restore_action_trash"><?php esc_html_e('Restore', 'black-desk'); ?></option>
            </select>

            <input type="submit" class="button" id="doaction_trash"  value="<?php esc_attr_e('Apply', 'black-desk'); ?>">
            <?php wp_nonce_field("bdds-doaction-trash-nonce"); ?>
        </div>
    </div>

    <table class="wp-list-table widefat fixed striped table-view-list">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column">
                    <input type="checkbox">
                </td>
                <?php 
                    // show table columns in table header
                    foreach( $table_structure_result as $table_structure ) {
                        // created_at and updated_at should not be displayed in trash view so we skip it 
                        if($table_structure->Field == "created_at" || $table_structure->Field == "updated_at") continue;
                        echo "<th>";
                            echo esc_html($table_structure->Field);
                        echo "</th>";
                    }
                ?>
            </tr>
        </thead>

        <tbody>
            <?php 
                // display deleted records
                foreach( $deleted_records as $deleted_record ) {
                    // id of a row so we can restore it later
                    // record is restored by setting "delete_at" column to NULL, so for that we only need row's ID
                    $row_id = $deleted_record->id;
                    echo "<tr>";
                        echo "<th scopre='row' class='check-column'>";
                            echo "<input type='checkbox' name='restore_deleted_column_" . esc_attr($row_id) . "' value='" . esc_attr($row_id) . "'>";
                        echo "</th>";
                        foreach( $table_structure_result as $table_structure ) {
                            $column_name = $table_structure->Field;
                            // created_at and updated_at should not be displayed in trash view so we skip it 
                            if($column_name == "created_at" || $column_name == "updated_at") continue;
                            echo "<td>" . esc_html($deleted_record->$column_name) . "</td>";
                        }
                    echo "</tr>";
                }
            ?>
        </tbody>
    </table>
</form>

