<?php 
    if ( ! defined( 'ABSPATH' ) ) exit; 
?>

<div id="screen-meta" class="metabox-prefs" style="display: none;">
		<div id="screen-options-wrap" class="" tabindex="-1" aria-label="Screen Options Tab" style="display: block;">
        <form id="adv-settings" method="post">
            <fieldset class="metabox-prefs view-mode">
                <legend><?php esc_html_e('Select Columns', 'black-desk'); ?></legend>
                <?php 
                    global $wpdb;
                    $nonce = isset($_GET["_wpnonce"]) ? sanitize_text_field(wp_unslash($_GET["_wpnonce"])) : null;
                    $table = (
                        wp_verify_nonce($nonce, "bdds-table-view-nonce") || wp_verify_nonce($nonce, "bdds-yes-drop-row-nonce") 
                        || wp_verify_nonce($nonce, "view-truncate-table-nonce") || wp_verify_nonce($nonce, "bdds-no-drop-row-nonce") 
                        || check_admin_referer("bdds-table-view")
                    ) 
                    ? (isset($_GET['table_name']) ? sanitize_text_field(wp_unslash($_GET['table_name'])) : null) : '';

                    $table_desc = $wpdb->get_results($wpdb->prepare("DESC `$table`;")); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

                    foreach( $table_desc as $key=>$table ) {
                        $is_checked = (isset($_POST["screen-column-option-$key"]) && !empty($_POST["screen-column-option-$key"])) ? "checked" : '';
                        echo "<label>";
                            echo "<input type='checkbox' name='screen-column-option-" . esc_attr($key) . "' value='" . esc_attr($table->Field) . "' " . esc_attr($is_checked) . " >";
                            echo esc_html($table->Field);
                        echo "</label>";
                    }
                ?>
            </fieldset>
            <p class="submit">
                <input type="submit" name="screen-options-apply" id="screen-options-apply" 
                  class="button button-primary" value="<?php esc_attr_e('Apply', 'black-desk'); ?>"
                >
            </p>
        </form>
    </div>		
</div>

<div id="screen-meta-links">
    <div id="screen-options-link-wrap" class="hide-if-no-js screen-meta-toggle">
    	<button type="button" id="show-settings-link" class="button show-settings" 
         aria-controls="screen-options-wrap" aria-expanded="false"
        >
          Screen Options
        </button>
    </div>
</div>